/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.api;

import java.util.Map;
import org.eclipse.dirigible.repository.api.IMasterRepository;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryCreationException;
import org.eclipse.dirigible.repository.api.RepositoryFactoryNonOSGi;
import org.eclipse.dirigible.repository.api.RepositoryFactoryOSGi;

public class RepositoryFactory {
    public static IRepository createRepository(Map<String, Object> parameters) throws RepositoryCreationException {
        if (RepositoryFactory.isOSGiEnvironment()) {
            return RepositoryFactoryOSGi.createRepository(parameters);
        }
        return RepositoryFactoryNonOSGi.createRepository(parameters);
    }

    public static IMasterRepository createMasterRepository(Map<String, Object> parameters) throws RepositoryCreationException {
        if (RepositoryFactory.isOSGiEnvironment()) {
            return RepositoryFactoryOSGi.createMasterRepository(parameters);
        }
        return RepositoryFactoryNonOSGi.createMasterRepository(parameters);
    }

    public static boolean isOSGiEnvironment() {
        return Boolean.parseBoolean(System.getProperty("osgi"));
    }
}

