/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.commands;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractClipboardHandler
extends AbstractHandler {
    public static final String CUT = "WORKSPACE_CUT";
    public static final String COPY = "WORKSPACE_COPY";
    public static final String PASTE = "WORKSPACE_PASTE";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.execute(event, (IStructuredSelection)selection);
        }
        return null;
    }

    public void execute(ExecutionEvent event, IStructuredSelection selection) {
        ResourceComparator comparator = new ResourceComparator();
        TreeSet<IResource> resources = new TreeSet<IResource>(comparator);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                resources.add((IResource)element);
            }
            ++n2;
        }
        this.execute(event, resources);
    }

    protected abstract void execute(ExecutionEvent var1, SortedSet<IResource> var2);

    private class ResourceComparator
    implements Comparator<IResource> {
        private ResourceComparator() {
        }

        @Override
        public int compare(IResource o1, IResource o2) {
            int segmentCount2;
            int segmentCount1 = o1.getFullPath().segmentCount();
            if (segmentCount1 == (segmentCount2 = o2.getFullPath().segmentCount())) {
                String path1 = o1.getFullPath().toString();
                String path2 = o2.getFullPath().toString();
                return path2.compareTo(path1);
            }
            return segmentCount2 - segmentCount1;
        }
    }
}

