/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.db.preferences.NewDatasourceDialog;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.datasource.NamedDataSourcesInitializer;
import org.eclipse.dirigible.repository.ext.conf.ConfigurationStore;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class DatasourcesListEditor
extends ListEditor {
    private static final Logger logger = Logger.getLogger(DatasourcesListEditor.class);
    private boolean initalized;

    private DatasourcesListEditor() {
    }

    public DatasourcesListEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected String createList(String[] items) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                buff.append(",");
            }
            buff.append(items[i]);
            ++i;
        }
        return buff.toString();
    }

    protected String[] parseString(String stringList) {
        StringTokenizer tokenizer = new StringTokenizer(",");
        ArrayList<String> items = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            items.add(token);
        }
        return items.toArray(new String[items.size()]);
    }

    protected String getNewInputObject() {
        String id = null;
        String name = null;
        String type = null;
        String location = null;
        NewDatasourceDialog dialog = new NewDatasourceDialog(this.getShell());
        dialog.create();
        if (dialog.open() == 0) {
            id = dialog.getId();
            name = dialog.getName();
            type = dialog.getType();
            location = dialog.getLocation();
            Set names = DataSourceFacade.getInstance().getNamedDataSourcesNames();
            if (names.contains(id)) {
                MessageDialog.openError((Shell)this.getShell(), (String)"", (String)String.format("Datasource with Id: %s already exists", id));
                return null;
            }
            Properties properties = new Properties();
            properties.setProperty("db.id", id);
            properties.setProperty("db.name", name);
            properties.setProperty("db.type", type);
            properties.setProperty("db.location", location);
            IRepository repository = RepositoryFacade.getInstance().getRepository();
            ConfigurationStore store = new ConfigurationStore(repository);
            try {
                store.setGlobalSettings("datasources", id, properties);
                this.reinitializeDatasources();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return id;
    }

    protected void selectionChanged() {
        super.selectionChanged();
        if (this.isInitalized()) {
            Set names = DataSourceFacade.getInstance().getNamedDataSourcesNames();
            List list = this.getList();
            String[] items = list.getItems();
            if (items.length < names.size()) {
                for (String name : names) {
                    if (this.nameIsFound(name, items)) continue;
                    IRepository repository = RepositoryFacade.getInstance().getRepository();
                    ConfigurationStore store = new ConfigurationStore(repository);
                    try {
                        store.removeGlobalSettings("datasources", name);
                        this.reinitializeDatasources();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private void reinitializeDatasources() {
        new NamedDataSourcesInitializer().initializeAvailableDataSources(CommonIDEParameters.getRequest(), RepositoryFacade.getInstance().getRepository());
    }

    private boolean nameIsFound(String name, String[] items) {
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isInitalized() {
        return this.initalized;
    }

    public void setInitalized(boolean initalized) {
        this.initalized = initalized;
    }
}

