/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.create;

import org.eclipse.dirigible.ide.workspace.ui.shared.FocusableWizardPage;
import org.eclipse.dirigible.ide.workspace.ui.shared.IValidationStatus;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.Messages;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.NewProjectWizardModel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewProjectWizardMainPage
extends FocusableWizardPage {
    private static final long serialVersionUID = -2191030355904715681L;
    private static final String ENTER_PROJECT_NAME = Messages.NewProjectWizardMainPage_ENTER_PROJECT_NAME;
    private static final String PAGE_NAME = "Main Page";
    private static final String PAGE_TITLE = Messages.NewProjectWizardMainPage_PAGE_TITLE;
    private static final String PAGE_DESCRIPTION = Messages.NewProjectWizardMainPage_PAGE_DESCRIPTION;
    private final NewProjectWizardModel model;
    private Text projectNameField = null;

    public NewProjectWizardMainPage(NewProjectWizardModel model) {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        Label projectNameLabel = new Label(composite, 0);
        projectNameLabel.setText(ENTER_PROJECT_NAME);
        projectNameLabel.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.projectNameField = new Text(composite, 2048);
        this.projectNameField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.projectNameField.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = -3384299735086998756L;

            public void modifyText(ModifyEvent event) {
                NewProjectWizardMainPage.this.onProjectNameChanged(NewProjectWizardMainPage.this.projectNameField.getText());
            }
        });
        this.setFocusable((Control)this.projectNameField);
        this.initialize();
    }

    public String getProjectName() {
        return this.projectNameField.getText();
    }

    public void setProjectName(String location) {
        if (this.projectNameField == null || this.projectNameField.isDisposed()) {
            return;
        }
        if (!NewProjectWizardMainPage.areEqual(this.projectNameField.getText(), location)) {
            this.projectNameField.setText(location);
        }
    }

    private static boolean areEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return b.equals(a);
    }

    public void setWarningMessage(String message) {
        this.setMessage(message, 2);
    }

    public void setCanFinish(boolean value) {
        this.setPageComplete(value);
    }

    public void dispose() {
        this.projectNameField = null;
        super.dispose();
    }

    public void initialize() {
        this.setProjectName(this.model.getProjectName());
        this.revalidateModel();
    }

    public void onProjectNameChanged(String location) {
        this.model.setProjectName(location);
        this.revalidateModel();
    }

    private void revalidateModel() {
        IValidationStatus status = this.model.validate();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setWarningMessage(null);
            this.setCanFinish(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(null);
            this.setWarningMessage(status.getMessage());
            this.setCanFinish(true);
        } else {
            this.setErrorMessage(null);
            this.setWarningMessage(null);
            this.setCanFinish(true);
        }
    }
}

