/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.rap.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.dirigible.ide.common.ExtensionPointUtils;
import org.eclipse.dirigible.ide.ui.rap.api.IDirigibleWorkbenchInitializer;
import org.eclipse.dirigible.ide.ui.rap.entry.DirigibleWorkbench;

public class DirigibleWorkbenchInitializersManager {
    private static final String EXTENSION_POINT_CANNOT_BE_FOUND_S = "Extension point cannot be found: %s";
    private static final String COULD_NOT_CREATE_INITIALIZER_INSTANCE = "Could not create Initializer instance: %s";
    private static final String INITIALIZER_CLASS_IS_INVALID = "Initializer class is invalid";
    private static final String ATTRIBUTE_INITIALIZER = "initializer";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String EXTENSION_POINT_ID = "org.eclipse.dirigible.ide.ui.rap.init";
    static List<IDirigibleWorkbenchInitializer> initializers = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IDirigibleWorkbenchInitializer> getInitializers() {
        Class<DirigibleWorkbench> clazz = DirigibleWorkbench.class;
        synchronized (DirigibleWorkbench.class) {
            if (initializers == null) {
                initializers = new ArrayList<IDirigibleWorkbenchInitializer>();
                IExtensionPoint extensionPoint = ExtensionPointUtils.getExtensionPoint((String)EXTENSION_POINT_ID);
                if (extensionPoint == null) {
                    throw new RuntimeException(MessageFormat.format(EXTENSION_POINT_CANNOT_BE_FOUND_S, EXTENSION_POINT_ID));
                }
                IConfigurationElement[] initializerElements = DirigibleWorkbenchInitializersManager.getInitializerElements(extensionPoint.getExtensions());
                String initializerName = null;
                try {
                    IConfigurationElement[] iConfigurationElementArray = initializerElements;
                    int n = initializerElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement initializerElement = iConfigurationElementArray[n2];
                        initializerName = initializerElement.getAttribute(ATTRIBUTE_CLASS);
                        initializers.add(DirigibleWorkbenchInitializersManager.createInitializer(initializerElement));
                        ++n2;
                    }
                }
                catch (CoreException ex) {
                    throw new RuntimeException(String.format(COULD_NOT_CREATE_INITIALIZER_INSTANCE, initializerName), ex);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return initializers;
        }
    }

    private static IConfigurationElement[] getInitializerElements(IExtension[] extensions) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (ATTRIBUTE_INITIALIZER.equals(element.getName())) {
                    result.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IConfigurationElement[0]);
    }

    private static IDirigibleWorkbenchInitializer createInitializer(IConfigurationElement initializerElement) throws CoreException {
        Object initializer = initializerElement.createExecutableExtension(ATTRIBUTE_CLASS);
        if (!(initializer instanceof IDirigibleWorkbenchInitializer)) {
            throw new RuntimeException(INITIALIZER_CLASS_IS_INVALID);
        }
        return (IDirigibleWorkbenchInitializer)initializer;
    }
}

