/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.cmis;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.runtime.cmis.CmisObject;
import org.eclipse.dirigible.runtime.cmis.CmisSession;
import org.eclipse.dirigible.runtime.cmis.ContentStream;
import org.eclipse.dirigible.runtime.cmis.Document;

public class Folder
extends CmisObject {
    private CmisSession session;
    private ICollection internalFolder;
    private IRepository repository;
    private boolean rootFolder = false;

    public Folder(CmisSession session) throws IOException {
        super(session, "/");
        this.session = session;
        this.repository = (IRepository)session.getCmisRepository().getInternalObject();
        this.internalFolder = this.repository.getRoot();
        this.rootFolder = true;
    }

    public Folder(CmisSession session, ICollection internalCollection) throws IOException {
        super(session, internalCollection.getPath());
        if ("/".equals(internalCollection.getPath())) {
            this.rootFolder = true;
        }
        this.session = session;
        this.repository = (IRepository)session.getCmisRepository().getInternalObject();
        this.internalFolder = internalCollection;
    }

    public Folder(CmisSession session, String id) throws IOException {
        super(session, id);
        id = this.sanitize(id);
        if ("/".equals(id)) {
            this.rootFolder = true;
        }
        this.session = session;
        this.repository = (IRepository)session.getCmisRepository().getInternalObject();
        this.internalFolder = this.repository.getCollection(id);
    }

    public ICollection getInternalFolder() {
        return this.internalFolder;
    }

    @Override
    protected boolean isCollection() {
        return true;
    }

    public String getPath() {
        return this.getInternalEntity().getPath();
    }

    public Folder createFolder(Map<String, String> properties) throws IOException {
        String name = properties.get("cmis:name");
        return new Folder(this.session, this.internalFolder.createCollection(name));
    }

    public Document createDocument(Map<String, String> properties, ContentStream contentStream, String versioningState) throws IOException {
        String name = properties.get("cmis:name");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)contentStream.getStream(), (OutputStream)out);
        return new Document(this.session, this.internalFolder.createResource(name, out.toByteArray(), true, contentStream.getMimeType()));
    }

    public List<CmisObject> getChildren() throws IOException {
        ArrayList<CmisObject> children = new ArrayList<CmisObject>();
        List collections = this.internalFolder.getCollections();
        for (ICollection collection : collections) {
            children.add(new Folder(this.session, collection));
        }
        List resources = this.internalFolder.getResources();
        for (IResource resource : resources) {
            children.add(new Document(this.session, resource));
        }
        return children;
    }

    public boolean isRootFolder() {
        return this.rootFolder;
    }

    public Folder getFolderParent() throws IOException {
        if (this.internalFolder.getParent() != null) {
            return new Folder(this.session, this.internalFolder.getParent());
        }
        return new Folder(this.session);
    }
}

