/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.mobile.wizard;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.table.TableColumn;
import org.eclipse.dirigible.ide.template.ui.mobile.wizard.MobileForEntityTemplateModel;

public class MobileForEntityTemplateGenerator
extends TemplateGenerator {
    private static final String LOG_TAG = "MOBILE_APP_FOR_ENTITY_GENERATOR";
    private MobileForEntityTemplateModel model;
    private static final String REST_SERVICE_ROOT_JS = "../../js";
    private static final String PARAMETER_PAGE_TITLE = "pageTitle";
    private static final String PARAMETER_TABLE_NAME = "tableName";
    private static final String PARAMETER_DEPENDENT_COLUMN = "dependentColumn";
    private static final String PARAMETER_TABLE_COLUMNS = "tableColumns";
    private static final String PARAMETER_SERVICE_FILE_NAME = "serviceFileName";
    private static final String PARAMETER_ENTITY_NAME = "entityName";
    private static final String PARAMETER_PRIMARY_KEY = "primaryKey";

    public MobileForEntityTemplateGenerator(MobileForEntityTemplateModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        Map parameters = super.prepareParameters();
        parameters.put(PARAMETER_PAGE_TITLE, this.model.getPageTitle());
        parameters.put(PARAMETER_TABLE_NAME, this.model.getTableName());
        parameters.put(PARAMETER_DEPENDENT_COLUMN, this.model.getDependentColumn());
        parameters.put(PARAMETER_TABLE_COLUMNS, this.model.getTableColumns());
        parameters.put(PARAMETER_SERVICE_FILE_NAME, this.generateServiceFileName());
        parameters.put(PARAMETER_ENTITY_NAME, this.getEntityName());
        parameters.put(PARAMETER_PRIMARY_KEY, this.getPrimaryKey());
        return parameters;
    }

    private Object getPrimaryKey() {
        TableColumn[] columns = this.model.getTableColumns();
        TableColumn primaryKey = null;
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (column.isKey()) {
                primaryKey = column;
            }
            ++n2;
        }
        if (primaryKey == null) {
            return null;
        }
        return primaryKey;
    }

    protected String getEntityName() {
        return "data";
    }

    protected Object generateServiceFileName() {
        String result = "";
        if (this.model.getSourceFile() != null) {
            IFile source = this.model.getSourceFile();
            String entityPath = source.getFullPath().toString();
            int index = entityPath.indexOf("ScriptingServices");
            result = index >= 0 ? entityPath.substring(index + "ScriptingServices".length()) : entityPath;
            result = result.replace(source.getFileExtension(), "");
            result = String.valueOf(result) + "js";
        } else {
            result = this.model.getServiceEndpoint();
        }
        return REST_SERVICE_ROOT_JS + result;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    protected String getDefaultRootFolder() {
        return "MobileApplications";
    }
}

