/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.is.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateWizard;
import org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateModel;
import org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateServiceParametersPage;
import org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateTypePage;
import org.eclipse.dirigible.ide.template.ui.is.wizard.Messages;
import org.eclipse.jface.wizard.IWizardPage;

public class IntegrationServiceTemplateWizard
extends TemplateWizard {
    private static final String CREATE_INTEGRATION_SERVICE = Messages.IntegrationServiceTemplateWizard_CREATE_INTEGRATION_SERVICE;
    private final IntegrationServiceTemplateModel model;
    private final IntegrationServiceTemplateTypePage typesPage;
    private final IntegrationServiceTemplateTargetLocationPage targetLocationPage;
    private final IntegrationServiceTemplateServiceParametersPage serviceEndpointPage;

    public IntegrationServiceTemplateWizard(IResource resource) {
        this.setWindowTitle(CREATE_INTEGRATION_SERVICE);
        this.model = new IntegrationServiceTemplateModel();
        this.model.setSourceResource(resource);
        this.typesPage = new IntegrationServiceTemplateTypePage(this.model);
        this.serviceEndpointPage = new IntegrationServiceTemplateServiceParametersPage(this.model);
        this.targetLocationPage = new IntegrationServiceTemplateTargetLocationPage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.typesPage);
        this.addPage((IWizardPage)this.serviceEndpointPage);
        this.addPage((IWizardPage)this.targetLocationPage);
    }

    public TemplateGenerator getTemplateGenerator() {
        IntegrationServiceTemplateGenerator generator = new IntegrationServiceTemplateGenerator(this.model);
        return generator;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFileName()));
        }
        return result;
    }
}

