/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common.service;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.dirigible.ide.template.ui.common.GenerationException;
import org.eclipse.dirigible.ide.template.ui.common.service.GenerationUtils;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;

public abstract class AbstractGenerationServlet
extends HttpServlet {
    private static final long serialVersionUID = -9115022531455267478L;
    private static final Logger logger = Logger.getLogger(AbstractGenerationServlet.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.service(request, response);
    }

    protected IRepository getRepository(HttpServletRequest request) throws ServletException {
        return GenerationUtils.getRepository(request);
    }

    protected IWorkspace getWorkspace(HttpServletRequest request) throws ServletException {
        return GenerationUtils.getWorkspace(request);
    }

    protected abstract String doGeneration(String var1, HttpServletRequest var2) throws GenerationException;

    protected abstract String enumerateTemplates(HttpServletRequest var1) throws GenerationException;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String parameters = IOUtils.toString((InputStream)req.getInputStream());
            String result = this.doGeneration(parameters, req);
            this.printResult(resp, result);
        }
        catch (GenerationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void printResult(HttpServletResponse resp, String result) throws IOException {
        resp.getWriter().print(result);
        resp.getWriter().flush();
        resp.getWriter().close();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String result = this.enumerateTemplates(req);
            this.printResult(resp, result);
        }
        catch (GenerationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }
}

