/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.command;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.common.status.DefaultProgressMonitor;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.jgit.command.CloneCommandHandler;
import org.eclipse.dirigible.ide.jgit.command.Messages;
import org.eclipse.dirigible.ide.jgit.command.ui.CloneDependenciesCommandDialog;
import org.eclipse.dirigible.ide.jgit.utils.CommandHandlerUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class UpdateDependenciesCommandHandler
extends CloneCommandHandler {
    private static final Logger logger = Logger.getLogger(UpdateDependenciesCommandHandler.class);
    private static final String NO_PROJECT_IS_SELECTED_FOR_CLONE_DEPENDENCIES = Messages.CloneDependenciesCommandHandler_NO_PROJECT_IS_SELECTED_FOR_CLONE_DEPENDENCIES;
    private static final String PLEASE_SELECT_ONE = Messages.PushCommandHandler_PLEASE_SELECT_ONE;

    @Override
    public Object execute(ExecutionEvent event, String git) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection.isEmpty()) {
            logger.warn(NO_PROJECT_IS_SELECTED_FOR_CLONE_DEPENDENCIES);
            StatusLineManagerUtil.setWarningMessage((String)NO_PROJECT_IS_SELECTED_FOR_CLONE_DEPENDENCIES);
            MessageDialog.openWarning(null, (String)NO_PROJECT_IS_SELECTED_FOR_CLONE_DEPENDENCIES, (String)PLEASE_SELECT_ONE);
            return null;
        }
        IProject[] projects = CommandHandlerUtils.getProjects(selection, logger);
        if (projects.length == 0) {
            logger.warn(NO_PROJECT_IS_SELECTED_FOR_CLONE_DEPENDENCIES);
            StatusLineManagerUtil.setWarningMessage((String)NO_PROJECT_IS_SELECTED_FOR_CLONE_DEPENDENCIES);
            MessageDialog.openWarning(null, (String)NO_PROJECT_IS_SELECTED_FOR_CLONE_DEPENDENCIES, (String)PLEASE_SELECT_ONE);
            return null;
        }
        DefaultProgressMonitor monitor = new DefaultProgressMonitor();
        monitor.beginTask(TASK_CLONING_REPOSITORY, -1);
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        CloneDependenciesCommandDialog dialog = new CloneDependenciesCommandDialog(parent);
        switch (dialog.open()) {
            case 0: {
                IProject[] iProjectArray = projects;
                if (projects.length == 0) break;
                IProject selectedProject = iProjectArray[0];
                try {
                    HashSet<String> clonedProjects = new HashSet<String>();
                    this.cloneDependencies(dialog.getUsername(), dialog.getPassword(), clonedProjects, selectedProject.getName());
                    this.refreshWorkspace();
                    this.publishProjects(clonedProjects);
                    StatusLineManagerUtil.setInfoMessage((String)"Project(s) has been cloned successfully");
                    break;
                }
                catch (IOException e) {
                    logger.error(String.valueOf(WHILE_CLONING_REPOSITORY_ERROR_OCCURED) + e.getMessage(), (Throwable)e);
                    MessageDialog.openError(null, (String)WHILE_CLONING_REPOSITORY_ERROR_OCCURED, (String)e.getCause().getMessage());
                    break;
                }
                catch (CoreException e) {
                    logger.error(String.valueOf(WHILE_CLONING_REPOSITORY_ERROR_OCCURED) + e.getMessage(), (Throwable)e);
                    MessageDialog.openError(null, (String)WHILE_CLONING_REPOSITORY_ERROR_OCCURED, (String)e.getCause().getMessage());
                }
            }
        }
        monitor.done();
        return null;
    }
}

