/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.command;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.common.status.DefaultProgressMonitor;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.jgit.command.Messages;
import org.eclipse.dirigible.ide.jgit.command.ProjectMetadataManager;
import org.eclipse.dirigible.ide.jgit.command.PullCommandHandler;
import org.eclipse.dirigible.ide.jgit.command.ui.CloneCommandDialog;
import org.eclipse.dirigible.ide.jgit.utils.GitFileUtils;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.publish.PublishManager;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.commands.AbstractWorkspaceHandler;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.repository.project.ProjectMetadataDependency;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CloneCommandHandler
extends AbstractWorkspaceHandler {
    protected static final String PROJECT_S_HAS_BEEN_CLONED_SUCCESSFULLY = "Project(s) has been cloned successfully";
    private static final String PROJECT_S_HAS_BEEN_PUBLISHED = "Project %s has been published";
    private static final String DO_YOU_WANT_TO_PUBLISH_THE_PROJECT_YOU_JUST_CLONED = "Do you want to publish the project(s) you just cloned?";
    private static final String PUBLISH_CLONED_PROJECT = "Publish Cloned Project?";
    protected static final String TASK_CLONING_REPOSITORY = Messages.CloneCommandHandler_TASK_CLONING_REPOSITORY;
    private static final String PLEASE_CHECK_IF_PROXY_SETTINGS_ARE_SET_PROPERLY = Messages.CloneCommandHandler_MASTER;
    private static final String NO_REMOTE_REPOSITORY_FOR = Messages.CloneCommandHandler_NO_REMOTE_REPOSITORY_FOR;
    private static final String DOT_GIT = ".git";
    private static final String PROJECT_WAS_CLONED = Messages.CloneCommandHandler_PROJECT_WAS_CLONED;
    protected static final String WHILE_CLONING_REPOSITORY_ERROR_OCCURED = Messages.CloneCommandHandler_WHILE_CLONING_REPOSITORY_ERROR_OCCURED;
    private static final String NOT_SUPPORTED_REPOSITORY_TYPE = Messages.CloneCommandHandler_NOT_SUPPORTED_REPOSITORY_TYPE;
    private static final String SLASH = "/";
    private static final Logger logger = Logger.getLogger(CloneCommandHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return this.execute(event, null);
    }

    public Object execute(ExecutionEvent event, String git) throws ExecutionException {
        DefaultProgressMonitor monitor = new DefaultProgressMonitor();
        monitor.beginTask(TASK_CLONING_REPOSITORY, -1);
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        CloneCommandDialog dialog = new CloneCommandDialog(parent, git);
        switch (dialog.open()) {
            case 0: {
                try {
                    File gitDirectory = this.createGitDirectory(dialog.getRepositoryURI());
                    HashSet<String> clonedProjects = new HashSet<String>();
                    logger.debug(String.format("Start cloning repository %s ...", dialog.getRepositoryURI()));
                    this.cloneProject(dialog.getRepositoryURI(), dialog.getRepositoryBranch(), dialog.getUsername(), dialog.getPassword(), gitDirectory, clonedProjects);
                    logger.debug(String.format("Cloning repository %s finished successfully.", dialog.getRepositoryURI()));
                    this.refreshWorkspace();
                    this.publishProjects(clonedProjects);
                    StatusLineManagerUtil.setInfoMessage((String)PROJECT_S_HAS_BEEN_CLONED_SUCCESSFULLY);
                    break;
                }
                catch (IOException e) {
                    logger.error(String.valueOf(WHILE_CLONING_REPOSITORY_ERROR_OCCURED) + e.getMessage(), (Throwable)e);
                    MessageDialog.openError(null, (String)WHILE_CLONING_REPOSITORY_ERROR_OCCURED, (String)e.getCause().getMessage());
                }
            }
        }
        monitor.done();
        return null;
    }

    protected File createGitDirectory(String repositoryURI) throws IOException {
        String repositoryName = repositoryURI.substring(repositoryURI.lastIndexOf(SLASH) + 1, repositoryURI.lastIndexOf(DOT_GIT));
        File gitDirectory = GitFileUtils.createTempDirectory("org.eclipse.dirigible.jgit." + repositoryName);
        return gitDirectory;
    }

    /*
     * Exception decompiling
     */
    protected void cloneProject(String repositoryURI, String repositoryBranch, String username, String password, File gitDirectory, Set<String> clonedProjects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void cloneDependencies(String username, String password, Set<String> clonedProjects, String projectName) throws IOException, CoreException {
        IProject selectedProject = WorkspaceLocator.getWorkspace((HttpServletRequest)CommonIDEParameters.getRequest()).getRoot().getProject(projectName);
        ProjectMetadataDependency[] dependencies = ProjectMetadataManager.getDependencies(selectedProject);
        PullCommandHandler pull = new PullCommandHandler();
        if (dependencies != null) {
            ProjectMetadataDependency[] projectMetadataDependencyArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectMetadataDependency dependency = projectMetadataDependencyArray[n2];
                if ("git".equalsIgnoreCase(dependency.getType())) {
                    String projectGuid = dependency.getGuid();
                    if (!clonedProjects.contains(projectGuid)) {
                        IProject alreadyClonedProject = WorkspaceLocator.getWorkspace((HttpServletRequest)CommonIDEParameters.getRequest()).getRoot().getProject(projectGuid);
                        if (!alreadyClonedProject.exists()) {
                            String projectRepositoryURI = dependency.getUrl();
                            String projectRepositoryBranch = dependency.getBranch();
                            File projectGitDirectory = this.createGitDirectory(projectRepositoryURI);
                            logger.debug(String.format("Start cloning of the project %s from the repository %s and branch %s into the directory %s ...", projectGuid, projectRepositoryURI, projectRepositoryBranch, projectGitDirectory.getCanonicalPath()));
                            this.cloneProject(projectRepositoryURI, projectRepositoryBranch, username, password, projectGitDirectory, clonedProjects);
                        } else {
                            logger.debug(String.format("Project %s has been already cloned, hence do pull instead.", projectGuid));
                            pull.pullProjectFromGitRepository(alreadyClonedProject);
                        }
                        clonedProjects.add(projectGuid);
                    } else {
                        logger.debug(String.format("Project %s has been already cloned during this session.", projectGuid));
                    }
                } else {
                    String errorMessage = String.format(NOT_SUPPORTED_REPOSITORY_TYPE, dependency.getType());
                    logger.error(errorMessage);
                    MessageDialog.openError(null, (String)WHILE_CLONING_REPOSITORY_ERROR_OCCURED, (String)errorMessage);
                }
                ++n2;
            }
        }
    }

    protected void publishProjects(Set<String> clonedProjects) {
        if (clonedProjects.size() > 0 && MessageDialog.openConfirm(null, (String)PUBLISH_CLONED_PROJECT, (String)DO_YOU_WANT_TO_PUBLISH_THE_PROJECT_YOU_JUST_CLONED)) {
            block2: for (String projectName : clonedProjects) {
                IProject[] projects;
                IProject[] iProjectArray = projects = WorkspaceLocator.getWorkspace((HttpServletRequest)CommonIDEParameters.getRequest()).getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (project.getName().equals(projectName)) {
                        try {
                            PublishManager.publishProject((IProject)project, (HttpServletRequest)CommonIDEParameters.getRequest());
                            logger.info(String.format(PROJECT_S_HAS_BEEN_PUBLISHED, project.getName()));
                        }
                        catch (PublishException e) {
                            logger.error(String.valueOf(WHILE_CLONING_REPOSITORY_ERROR_OCCURED) + e.getMessage(), (Throwable)e);
                            String causedBy = String.valueOf(NO_REMOTE_REPOSITORY_FOR) + e.getCause().getMessage();
                            MessageDialog.openError(null, (String)WHILE_CLONING_REPOSITORY_ERROR_OCCURED, (String)causedBy);
                        }
                        continue block2;
                    }
                    ++n2;
                }
            }
        }
    }
}

