/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.extensions.ui.view;

import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.extensions.ui.view.ExtensionsViewContentProvider;
import org.eclipse.dirigible.ide.extensions.ui.view.ExtensionsViewLabelProvider;
import org.eclipse.dirigible.ide.extensions.ui.view.Messages;
import org.eclipse.dirigible.ide.extensions.ui.view.SimpleTreeNode;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.extensions.EExtensionException;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionManager;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class ExtensionsManagerView
extends ViewPart {
    private static final Logger logger = Logger.getLogger(ExtensionsManagerView.class);
    private TreeViewer viewer;
    private Action actionRemove;
    private Action actionRefresh;
    private ExtensionManager extensionManager = new ExtensionManager(RepositoryFacade.getInstance().getRepository(), DataSourceFacade.getInstance().getDataSource(CommonIDEParameters.getRequest()), CommonIDEParameters.getRequest());

    public void createPartControl(Composite parent) {
        PatternFilter filter = new PatternFilter();
        FilteredTree tree = new FilteredTree(parent, 770, filter, true);
        this.viewer = tree.getViewer();
        TreeColumn column = new TreeColumn(this.viewer.getTree(), 16384);
        column.setText(Messages.ExtensionsManagerView_EXTENSIONS);
        column.setWidth(600);
        this.viewer.setContentProvider((IContentProvider)new ExtensionsViewContentProvider(this.extensionManager));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ExtensionsViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){
            private static final long serialVersionUID = -8683354310299838422L;

            public void menuAboutToShow(IMenuManager manager) {
                ExtensionsManagerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRemove);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRemove);
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRemove);
        manager.add((IAction)this.actionRefresh);
    }

    private void makeActions() {
        this.actionRemove = new Action(){
            private static final long serialVersionUID = 1336014167502247774L;

            public void run() {
                if (!ExtensionsManagerView.this.viewer.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)ExtensionsManagerView.this.viewer.getSelection();
                    Object[] selectedElements = selection.toArray();
                    if (MessageDialog.openConfirm((Shell)ExtensionsManagerView.this.viewer.getControl().getShell(), (String)Messages.ExtensionsManagerView_DELETE_EXTENSIONS_TITLE, (String)Messages.ExtensionsManagerView_DELETE_EXTENSIONS_DIALOG_DESCRIPTION)) {
                        String extensionToDelete = "";
                        try {
                            try {
                                Object[] objectArray = selectedElements;
                                int n = selectedElements.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object element = objectArray[n2];
                                    SimpleTreeNode simpleTreeNode = (SimpleTreeNode)element;
                                    extensionToDelete = simpleTreeNode.getName();
                                    if (simpleTreeNode.isRootElement()) {
                                        ExtensionsManagerView.this.extensionManager.removeExtensionPoint(simpleTreeNode.getName());
                                    } else {
                                        ExtensionsManagerView.this.extensionManager.removeExtension(simpleTreeNode.getName(), simpleTreeNode.getParent().getName());
                                    }
                                    ++n2;
                                }
                            }
                            catch (EExtensionException e) {
                                MessageDialog.openError((Shell)ExtensionsManagerView.this.viewer.getControl().getShell(), (String)(String.valueOf(Messages.ExtensionsManagerView_FAILED_TO_DELETE_EXTENSION) + extensionToDelete), (String)e.getMessage());
                                ExtensionsManagerView.this.viewer.refresh();
                            }
                        }
                        finally {
                            ExtensionsManagerView.this.viewer.refresh();
                        }
                    }
                }
            }
        };
        this.actionRemove.setText(Messages.ExtensionsManagerView_DELETE_LABEL);
        this.actionRemove.setToolTipText(Messages.ExtensionsManagerView_DELETE_ACTION_TOOL_TIP);
        this.actionRemove.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE"));
        this.actionRefresh = new Action(){
            private static final long serialVersionUID = 506492927597193506L;

            public void run() {
                ExtensionsManagerView.this.viewer.refresh();
            }
        };
        this.actionRefresh.setText(Messages.ExtensionsManagerView_REFRESH_LABEL);
        this.actionRefresh.setToolTipText(Messages.ExtensionsManagerView_REFRESH_ACTION_TOOLTIP);
        this.actionRefresh.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        private static final long serialVersionUID = -8832089975378999206L;

        NameSorter() {
        }

        public int compare(Viewer lviewer, Object e1, Object e2) {
            if (e1 != null && e2 != null && e1 instanceof SimpleTreeNode && e2 instanceof SimpleTreeNode && !(((SimpleTreeNode)e1).isRootElement() ^ ((SimpleTreeNode)e2).isRootElement())) {
                return super.compare(lviewer, (Object)e1.toString(), (Object)e2.toString());
            }
            return super.compare(lviewer, e1, e2);
        }
    }
}

