/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.debug;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.eclipse.dirigible.repository.ext.debug.DebugManager;
import org.eclipse.dirigible.repository.ext.debug.DebugModel;
import org.eclipse.dirigible.repository.ext.debug.DebugSessionModel;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.js.debug.WebSocketDebugBridgeServletInternal;

public class WebSocketDebugSessionServletInternal {
    private static final Logger logger = Logger.getLogger(WebSocketDebugBridgeServletInternal.class);
    private static final Gson GSON = new Gson();
    private static Map<String, List<Session>> openUserSessions = new ConcurrentHashMap<String, List<Session>>();

    @OnOpen
    public void onOpen(Session session) throws IOException {
        String userId = RequestUtils.getUser((Session)session);
        List<Session> userSessions = openUserSessions.get(userId);
        if (userSessions == null) {
            userSessions = new ArrayList<Session>();
        }
        userSessions.add(session);
        openUserSessions.put(userId, userSessions);
        logger.debug("[Internal] onOpen: " + userId);
    }

    @OnError
    public void onError(Session session, String error) {
        logger.error("[Internal] onError: " + error);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        DebugSessionDTO dto = (DebugSessionDTO)GSON.fromJson(message, DebugSessionDTO.class);
        String userId = RequestUtils.getUser((Session)session);
        DebugModel debugModel = DebugManager.getDebugModel((String)userId);
        DebugSessionModel sessionModel = debugModel.getSessionModelById(dto.sessionId);
        debugModel.setActiveSession(sessionModel);
        DebugManager.registerDebugModel((String)userId, (DebugModel)debugModel);
        logger.info("Setting sesion with id " + dto.sessionId);
    }

    @OnClose
    public void onClose(Session session) {
        String userId = RequestUtils.getUser((Session)session);
        List<Session> userSessions = openUserSessions.get(userId);
        if (userSessions == null) {
            logger.error("[Internal] onClose: Could not find the given session for currently active user!");
            return;
        }
        Iterator<Session> iterator = userSessions.iterator();
        while (iterator.hasNext()) {
            Session nextSession = iterator.next();
            if (!nextSession.getId().equalsIgnoreCase(session.getId())) continue;
            iterator.remove();
        }
        if (userSessions.isEmpty()) {
            openUserSessions.remove(userId);
        }
        logger.debug("[Internal] onClose: Session " + userId + " has ended");
    }

    public static void sendCurrentDebugModelSessionsToUser(String userId, DebugModel debugModel) {
        List sessions = debugModel.getSessions();
        List<DebugSessionDTO> sessionDTOs = WebSocketDebugSessionServletInternal.getSessionDTOs(userId, sessions);
        WebSocketDebugSessionServletInternal.sendToUser(userId, sessionDTOs);
    }

    private static List<DebugSessionDTO> getSessionDTOs(String userId, List<DebugSessionModel> models) {
        Set<String> sessionIds = WebSocketDebugSessionServletInternal.getSessionIds(models);
        return WebSocketDebugSessionServletInternal.getSessionDTOsForIds(sessionIds);
    }

    private static Set<String> getSessionIds(List<DebugSessionModel> models) {
        HashSet<String> sessionIds = new HashSet<String>();
        int i = 0;
        while (i < models.size()) {
            DebugSessionModel session = models.get(i);
            String uniqueSessionId = WebSocketDebugSessionServletInternal.getDebugSessionId(i, session);
            sessionIds.add(uniqueSessionId);
            ++i;
        }
        return sessionIds;
    }

    private static String getDebugSessionId(int index, DebugSessionModel session) {
        StringBuilder label = new StringBuilder();
        label.append(session.getUserId()).append(":").append(index + 1).append(":").append(session.getExecutionId()).append(":");
        return label.toString();
    }

    private static List<DebugSessionDTO> getSessionDTOsForIds(Set<String> debugSessionIds) {
        ArrayList<DebugSessionDTO> sessionDTOs = new ArrayList<DebugSessionDTO>();
        for (String sessionId : debugSessionIds) {
            DebugSessionDTO dto = new DebugSessionDTO(sessionId);
            sessionDTOs.add(dto);
        }
        return sessionDTOs;
    }

    private static void sendToUser(String userId, List<DebugSessionDTO> sessionDTOs) {
        List<Session> userSessions = openUserSessions.get(userId);
        if (userSessions != null) {
            for (Session session : userSessions) {
                try {
                    session.getBasicRemote().sendText(GSON.toJson(sessionDTOs));
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void clearCurrentSession(String userId) {
        DebugModel debugModel = DebugManager.getDebugModel((String)userId);
        DebugSessionModel currentSession = debugModel.getActiveSession();
        debugModel.removeSession(currentSession);
        List sessions = debugModel.getSessions();
        if (!sessions.isEmpty()) {
            debugModel.setActiveSession((DebugSessionModel)sessions.get(0));
        }
        DebugManager.registerDebugModel((String)userId, (DebugModel)debugModel);
        WebSocketDebugSessionServletInternal.sendCurrentDebugModelSessionsToUser(userId, debugModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        for (List<Session> openSessions : openUserSessions.values()) {
            for (Session session : openSessions) {
                try {
                    Session session2 = session;
                    synchronized (session2) {
                        session.close();
                    }
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    private static class DebugSessionDTO {
        private String sessionId;

        public DebugSessionDTO(String sessionId) {
            this.sessionId = sessionId;
        }
    }
}

