/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.debug;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.ext.debug.BreakpointMetadata;
import org.eclipse.dirigible.repository.ext.debug.DebugModel;
import org.eclipse.dirigible.repository.ext.debug.DebugSessionMetadata;
import org.eclipse.dirigible.repository.ext.debug.DebugSessionModel;
import org.eclipse.dirigible.repository.ext.debug.IDebugExecutor;
import org.eclipse.dirigible.repository.ext.debug.LinebreakMetadata;
import org.eclipse.dirigible.repository.ext.debug.VariableValue;
import org.eclipse.dirigible.repository.ext.debug.VariableValuesMetadata;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.js.debug.DebuggerActionCommander;
import org.eclipse.dirigible.runtime.js.debug.JavaScriptDebugger;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;

public class JavaScriptDebugFrame
implements DebugFrame {
    private static final String ILLEGAL = "illegal";
    private static final String NULL = "null";
    private static final String NATIVE = "native";
    private static final String FUNCTION = "function";
    private static final String UNDEFINED = "undefined";
    private static final Logger logger = Logger.getLogger(JavaScriptDebugFrame.class);
    private static final int SLEEP_TIME = 50;
    private DebuggerActionCommander debuggerActionCommander;
    private Stack<DebuggableScript> scriptStack;
    private Stack<Scriptable> activationStack;
    private int stepOverLineNumber = 0;
    private int previousLineNumber = 0;
    private boolean stepOverFinished = true;
    private DebugModel debugModel;
    private DebugSessionModel session;

    public JavaScriptDebugFrame(DebugModel debugModel, HttpServletRequest request, JavaScriptDebugger javaScriptDebugger) {
        this.logDebug("entering JavaScriptDebugFrame.constructor");
        this.debugModel = debugModel;
        String sessionId = request.getSession().getId();
        String executionId = UUID.randomUUID().toString();
        String userId = RequestUtils.getUser((HttpServletRequest)request);
        this.session = this.debugModel.createSession();
        this.debuggerActionCommander = new DebuggerActionCommander(this.session, sessionId, executionId, userId);
        this.session.setDebugExecutor((IDebugExecutor)this.getDebuggerActionCommander());
        this.debuggerActionCommander.init();
        this.debuggerActionCommander.setDebugFrame(this);
        this.debuggerActionCommander.setDebugger(javaScriptDebugger);
        this.scriptStack = new Stack();
        this.activationStack = new Stack();
        this.debugModel.getDebugController().register(this.session);
        this.logDebug("exiting JavaScriptDebugFrame.constructor");
    }

    public DebugModel getDebugModel() {
        return this.debugModel;
    }

    public void onEnter(Context context, Scriptable activation, Scriptable thisObj, Object[] args) {
        this.logDebug("entering JavaScriptDebugFrame.onEnter()");
        DebuggableScript script = (DebuggableScript)context.getDebuggerContextData();
        this.scriptStack.push(script);
        this.activationStack.push(activation);
        this.logDebug("exiting JavaScriptDebugFrame.onEnter()");
    }

    public void onLineChange(Context context, int lineNumber) {
        this.blockExecution();
        this.processAction(lineNumber, this.getNextCommand());
    }

    public void onExceptionThrown(Context context, Throwable ex) {
        this.logError("[debugger] onExceptionThrown()");
    }

    public void onExit(Context context, boolean byThrow, Object resultOrException) {
        this.logDebug("entering JavaScriptDebugFrame.onExit()");
        this.scriptStack.pop();
        this.activationStack.pop();
        if (this.scriptStack.isEmpty()) {
            this.debuggerActionCommander.clean();
            DebuggerActionCommander commander = this.getDebuggerActionCommander();
            DebugSessionMetadata metadata = new DebugSessionMetadata(commander.getSessionId(), commander.getExecutionId(), commander.getUserId());
            this.clearVariables();
            this.finishDebugSession(metadata);
        }
        this.logDebug("exiting JavaScriptDebugFrame.onExit()");
    }

    private void finishDebugSession(DebugSessionMetadata metadata) {
        this.session.getDebugController().finish(this.session);
    }

    private void clearVariables() {
        if (this.session.getVariableValuesMetadata() != null) {
            this.session.getVariableValuesMetadata().getVariableValueList().clear();
            this.notifyVariableValuesMetadata();
        }
    }

    public void onDebuggerStatement(Context context) {
        this.print(-1);
        if (this.debuggerActionCommander.isExecuting()) {
            this.debuggerActionCommander.pauseExecution();
        }
    }

    private void processAction(int lineNumber, IDebugExecutor.DebugCommand nextCommand) {
        if (nextCommand != IDebugExecutor.DebugCommand.SKIP_ALL_BREAKPOINTS) {
            if (this.isBreakpoint(lineNumber)) {
                this.hitBreakpoint(lineNumber);
            } else {
                switch (nextCommand) {
                    case CONTINUE: {
                        break;
                    }
                    case STEPINTO: {
                        this.stepInto(lineNumber);
                        break;
                    }
                    case STEPOVER: {
                        this.stepOver(lineNumber);
                        break;
                    }
                    case SKIP_ALL_BREAKPOINTS: {
                        break;
                    }
                }
            }
            this.previousLineNumber = lineNumber;
        }
    }

    private void hitBreakpoint(int lineNumber) {
        this.logDebug("entering JavaScriptDebugFrame.hitBreakpoint(): " + lineNumber);
        this.print(lineNumber);
        this.debuggerActionCommander.stepOver();
        this.debuggerActionCommander.pauseExecution();
        this.logDebug("exiting JavaScriptDebugFrame.hitBreakpoint()");
    }

    private void stepInto(int lineNumber) {
        this.logDebug("entering JavaScriptDebugFrame.stepInto(): " + lineNumber);
        this.print(lineNumber);
        this.debuggerActionCommander.pauseExecution();
        this.logDebug("exiting JavaScriptDebugFrame.stepInto()");
    }

    private void stepOver(int lineNumber) {
        this.logDebug("entering JavaScriptDebugFrame.stepOver(): " + lineNumber);
        if (this.stepOverFinished) {
            this.stepOverFinished = false;
            this.stepOverLineNumber = this.previousLineNumber;
        }
        if (this.stepOverLineNumber + 1 == lineNumber) {
            this.stepOverFinished = true;
            this.stepOverLineNumber = -1;
            this.stepInto(lineNumber);
        }
        this.logDebug("entering JavaScriptDebugFrame.stepOver()");
    }

    private void blockExecution() {
        this.logDebug("entering JavaScriptDebugFrame.blockExecution()");
        while (!this.debuggerActionCommander.isExecuting() && this.getNextCommand() != IDebugExecutor.DebugCommand.CONTINUE && this.getNextCommand() != IDebugExecutor.DebugCommand.SKIP_ALL_BREAKPOINTS) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logDebug("exiting JavaScriptDebugFrame.blockExecution()");
    }

    private IDebugExecutor.DebugCommand getNextCommand() {
        return this.debuggerActionCommander.getCommand();
    }

    private boolean isBreakpoint(int row) {
        String path = this.scriptStack.peek().getSourceName();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        DebuggerActionCommander commander = this.getDebuggerActionCommander();
        LinebreakMetadata breakpoint = new LinebreakMetadata(commander.getSessionId(), commander.getExecutionId(), commander.getUserId(), path, Integer.valueOf(row));
        Set<BreakpointMetadata> breakpoints = this.debuggerActionCommander.getBreakpoints();
        return breakpoints.contains(breakpoint.getBreakpoint());
    }

    private void print(int row) {
        DebuggerActionCommander commander = this.getDebuggerActionCommander();
        DebuggableScript script = this.scriptStack.peek();
        Scriptable activation = this.activationStack.peek();
        ArrayList<VariableValue> variableValuesList = new ArrayList<VariableValue>();
        int i = 0;
        while (i < script.getParamAndVarCount()) {
            String variable = script.getParamOrVarName(i);
            Object value = activation.get(variable, activation);
            if (variable != null && value != null) {
                String valueContent = this.parseValueToString(value);
                variableValuesList.add(new VariableValue(variable, valueContent));
            }
            ++i;
        }
        VariableValuesMetadata variableValuesMetadata = new VariableValuesMetadata(commander.getSessionId(), commander.getExecutionId(), commander.getUserId(), variableValuesList);
        this.session.setVariableValuesMetadata(variableValuesMetadata);
        this.notifyVariableValuesMetadata();
        String sourceName = script.getSourceName();
        this.sendOnBreakLineChange(sourceName, row);
    }

    private String parseValueToString(Object value) {
        String result = null;
        if (value instanceof Undefined) {
            result = UNDEFINED;
        } else if (value instanceof Boolean) {
            result = value.toString();
        } else if (value instanceof Number) {
            result = value.toString();
        } else if (value instanceof CharSequence) {
            result = value.toString();
        } else if (value instanceof BaseFunction) {
            result = FUNCTION;
        } else if (value instanceof NativeJavaObject) {
            result = NATIVE;
        } else if (value instanceof ScriptableObject) {
            try {
                result = new Gson().toJson(value);
            }
            catch (Throwable throwable) {
                result = ILLEGAL;
            }
        } else {
            result = NULL;
        }
        return result;
    }

    private void notifyVariableValuesMetadata() {
        if (this.session.getVariableValuesMetadata() != null) {
            this.session.getDebugController().refreshVariables();
        }
    }

    private void sendOnBreakLineChange(String path, Integer row) {
        DebuggerActionCommander commander = this.getDebuggerActionCommander();
        LinebreakMetadata currentLineBreak = new LinebreakMetadata(commander.getSessionId(), commander.getExecutionId(), commander.getUserId(), path, row);
        this.session.setCurrentLineBreak(currentLineBreak);
        this.session.getDebugController().onLineChange(currentLineBreak, this.session);
    }

    public DebuggerActionCommander getDebuggerActionCommander() {
        return this.debuggerActionCommander;
    }

    private void logError(String message) {
        logger.error(message);
    }

    private void logDebug(String message) {
        if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
    }
}

