/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.utils;

import org.json.JSONException;
import org.json.JSONObject;

public class RequestUtils {
    public static boolean isBreakpointMessage(String message) {
        return message != null && message.contains("Debugger") && message.toLowerCase().contains("breakpoint");
    }

    public static boolean isSetBreakpointMessage(String message) {
        return message != null && message.contains("Debugger.setBreakpoint");
    }

    public static boolean isGetResourceContent(String message) {
        return message != null && message.contains("Page.getResourceContent");
    }

    public static Integer getMessageId(String message) {
        try {
            return new JSONObject(message).getInt("id");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static String getMessageMethod(String message) {
        try {
            return new JSONObject(message).getString("method");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static boolean isGetResourceTree(String message) {
        return message != null && message.contains("Page.getResourceTree");
    }

    public static boolean isRemoveBreakpointMessage(String message) {
        return message != null && message.contains("Debugger.removeBreakpoint");
    }

    public static boolean isGetScritpSource(String message) {
        return message != null && message.contains("Debugger.getScriptSource");
    }

    public static boolean isStepIntoMessage(String message) {
        return message != null && message.contains("Debugger.stepInto");
    }

    public static boolean isStepOutMessage(String message) {
        return message != null && message.contains("Debugger.stepOut");
    }

    public static boolean isStepOverMessage(String message) {
        return message != null && message.contains("debugger.stepOver");
    }

    public static boolean isDebuggerStepMessage(String message) {
        return message != null && message.contains("Debugger.step");
    }

    public static boolean isGetProperties(String message) {
        return message != null && message.contains("Runtime.getProperties");
    }

    public static boolean isEvaluateOnCallFrame(String message) {
        return message != null && message.contains("Debugger.evaluateOnCallFrame");
    }

    public static boolean isSetScriptSource(String message) {
        return message != null && message.contains("Debugger.setScriptSource");
    }

    public static boolean isInspectorEnable(String message) {
        return message != null && message.contains("Inspector.enable");
    }
}

