/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.processing;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.websocket.Session;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.MessageRequest;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.OnExceptionHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.DebuggingService;

public class MessageDispatcher {
    private static final Map<Session, List<String>> SENT_MSG = new HashMap<Session, List<String>>();
    private static final Map<Session, List<String>> RECEIVED_MSG = new HashMap<Session, List<String>>();
    private static final Logger LOGGER = Logger.getLogger((String)DebuggingService.class.getCanonicalName());

    public static void sendMessage(String message, Session recipient) {
        MessageDispatcher.sendAsyncMessage(message, recipient);
    }

    public static void sendAsyncMessage(String message, Session sender) {
        MessageDispatcher.storeSentMessage(message, sender);
        sender.getAsyncRemote().sendText(message);
        LOGGER.debug(String.format("Sending asynchronous message to client with id [ %s ]. Content: [ %s ].", sender.getId(), message));
    }

    public static void sendSyncMessage(String message, Session sender) {
        MessageDispatcher.storeSentMessage(message, sender);
        try {
            sender.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not send synchronous message to client %s.", sender.getId()), (Throwable)e);
            try {
                new OnExceptionHandler().handle(e.getMessage(), sender);
            }
            catch (IOException iOException) {}
        }
    }

    private static void storeSentMessage(String message, Session sender) {
        List<String> sentMsgs = SENT_MSG.get(sender);
        if (sentMsgs == null) {
            sentMsgs = new ArrayList<String>();
        }
        sentMsgs.add(message);
        SENT_MSG.put(sender, sentMsgs);
    }

    public static void receiveFrom(String message, Session recipient) {
        List<String> receivedMsgs = RECEIVED_MSG.get(recipient);
        if (receivedMsgs == null) {
            receivedMsgs = new ArrayList<String>();
        }
        receivedMsgs.add(message);
        RECEIVED_MSG.put(recipient, receivedMsgs);
        LOGGER.debug(String.format("Received message [ %s ] from client with id [ %s ].", message, recipient.getId()));
    }

    public static boolean sentMessagesForSessionContain(String text, String sessionId) {
        List<String> receivedMessages = MessageDispatcher.receivedMessages(sessionId);
        if (receivedMessages == null) {
            return false;
        }
        return receivedMessages.contains(text);
    }

    public static boolean sentMessageContain(String text) {
        return MessageDispatcher.nestedCollectionContains(SENT_MSG.values(), text);
    }

    public static boolean receivedMessagesContain(String text) {
        return MessageDispatcher.nestedCollectionContains(RECEIVED_MSG.values(), text);
    }

    private static boolean nestedCollectionContains(Collection<? extends Collection<String>> collection, String text) {
        for (Collection<String> collection2 : collection) {
            if (!collection2.contains(text)) continue;
            return true;
        }
        return false;
    }

    public static Map<Session, List<String>> getHistory() {
        HashMap<Session, List<String>> history = new HashMap<Session, List<String>>();
        history.putAll(SENT_MSG);
        history.putAll(RECEIVED_MSG);
        return history;
    }

    public static boolean sessionHistoryContains(String sessionId, String text) {
        List<String> userHistory = MessageDispatcher.getSessionHistory(sessionId);
        for (String message : userHistory) {
            if (!message.contains(text)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getSessionHistory(String sessionId) {
        ArrayList<String> userHistory = new ArrayList<String>();
        Map<Session, List<String>> history = MessageDispatcher.getHistory();
        for (Map.Entry<Session, List<String>> e : history.entrySet()) {
            Session session = e.getKey();
            if (!session.getId().equalsIgnoreCase(sessionId)) continue;
            userHistory.addAll((Collection<String>)e.getValue());
        }
        return userHistory;
    }

    public static Integer getMessageIdForMessageMethod(String sessionId, String method) {
        List<String> sessionHistory = MessageDispatcher.getSessionHistory(sessionId);
        Iterator<String> iterator = sessionHistory.iterator();
        while (iterator.hasNext()) {
            Gson gson = new Gson();
            String message = iterator.next();
            MessageRequest request = (MessageRequest)gson.fromJson(message, MessageRequest.class);
            String requestMethod = request.getMethod();
            if (!requestMethod.equalsIgnoreCase(method)) continue;
            return request.getId();
        }
        return null;
    }

    public static List<String> receivedMessages(String sessionId) {
        for (Map.Entry<Session, List<String>> e : RECEIVED_MSG.entrySet()) {
            Session session = e.getKey();
            if (!session.getId().equalsIgnoreCase(sessionId)) continue;
            return e.getValue();
        }
        return null;
    }
}

