/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.service;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dirigible.ide.common.status.LogProgressMonitor;
import org.eclipse.dirigible.ide.template.ui.common.GenerationException;
import org.eclipse.dirigible.ide.template.ui.common.TemplateType;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypesEnumerator;
import org.eclipse.dirigible.ide.template.ui.common.service.AbstractGenerationWorker;
import org.eclipse.dirigible.ide.template.ui.html.service.WebContentEntityTemplateTypeDiscriminator;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlForEntityTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlForEntityTemplateModel;
import org.eclipse.dirigible.ide.template.ui.html.wizard.TableColumn;
import org.eclipse.dirigible.repository.api.IRepository;

public class WebContentEntityGenerationWorker
extends AbstractGenerationWorker {
    private static final String PARAM_SERVICE_ENDPOINT = "serviceEndpoint";
    private static final String PARAM_PAGE_TITLE = "pageTitle";
    private static final String PARAM_COLUMN_LABEL = "label";
    private static final String PARAM_COLUMN_WIDGET_TYPE = "widgetType";
    private static final String PARAM_COLUMN_SIZE = "size";
    private static final String PARAM_COLUMN_VISIBLE = "visible";
    private static final String PARAM_COLUMN_PRIMARY_KEY = "primaryKey";
    private static final String PARAM_COLUMN_TYPE = "type";
    private static final String PARAM_COLUMN_NAME = "name";
    private static final String PARAM_TABLE_NAME = "tableName";
    private static final String PARAM_COLUMNS = "columns";

    public WebContentEntityGenerationWorker(IRepository repository, IWorkspace workspace) {
        super(repository, workspace);
    }

    public String generate(String parameters, HttpServletRequest request) throws GenerationException {
        try {
            JsonElement parametersElement = new JsonParser().parse(parameters);
            JsonObject parametersObject = parametersElement.getAsJsonObject();
            HtmlForEntityTemplateModel model = new HtmlForEntityTemplateModel();
            HtmlForEntityTemplateGenerator generator = new HtmlForEntityTemplateGenerator(model);
            TemplateType[] templates = TemplateTypesEnumerator.prepareTemplateTypes((String)WebContentEntityTemplateTypeDiscriminator.getTemplatesPath(), (String)WebContentEntityTemplateTypeDiscriminator.getCategory(), (HttpServletRequest)request);
            this.setParametersToModel(parametersObject, model, templates);
            generator.generate(request);
        }
        catch (Exception e) {
            throw new GenerationException((Throwable)e);
        }
        return "Generation passed successfully.";
    }

    protected void setParametersToModel(JsonObject parametersObject, HtmlForEntityTemplateModel model, TemplateType[] templates) throws GenerationException {
        IProject project;
        if (parametersObject.has("templateType")) {
            String templateType = parametersObject.get("templateType").getAsString();
            TemplateType[] templateTypeArray = templates;
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateType template = templateTypeArray[n2];
                if (template.getLocation().substring(WebContentEntityTemplateTypeDiscriminator.getTemplatesPath().length()).indexOf(String.valueOf(templateType) + "/") == 0) {
                    model.setTemplate(template);
                    break;
                }
                ++n2;
            }
            if (model.getTemplate() == null) {
                throw new GenerationException(String.format("Template %s does not exist in this instance", templateType));
            }
        } else {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "templateType"));
        }
        if (!parametersObject.has("fileName")) {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "fileName"));
        }
        model.setFileName(parametersObject.get("fileName").getAsString());
        if (parametersObject.has("projectName")) {
            String projectName = parametersObject.get("projectName").getAsString();
            project = this.getWorkspace().getRoot().getProject(projectName);
            if (!project.exists()) {
                try {
                    project.create((IProgressMonitor)new LogProgressMonitor());
                }
                catch (CoreException e) {
                    throw new GenerationException((Throwable)e);
                }
            }
        } else {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "projectName"));
        }
        model.setTargetContainer(project.getFullPath().toString());
        if (!parametersObject.has("packageName")) {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "packageName"));
        }
        String packageName = parametersObject.get("packageName").getAsString();
        model.setProjectPackageName("WebContent/" + packageName);
        model.setPackageName(packageName);
        if (parametersObject.has(PARAM_COLUMNS)) {
            ArrayList<TableColumn> columnDefinitions = new ArrayList<TableColumn>();
            JsonArray columns = parametersObject.get(PARAM_COLUMNS).getAsJsonArray();
            for (JsonElement columnElement : columns) {
                if (!columnElement.isJsonObject()) continue;
                JsonObject columnObject = columnElement.getAsJsonObject();
                TableColumn columnDefinition = new TableColumn(columnObject.get(PARAM_COLUMN_NAME).getAsString(), columnObject.get(PARAM_COLUMN_PRIMARY_KEY).getAsBoolean(), columnObject.get(PARAM_COLUMN_VISIBLE).getAsBoolean(), columnObject.get(PARAM_COLUMN_TYPE).getAsString(), columnObject.get(PARAM_COLUMN_SIZE).getAsInt(), columnObject.get(PARAM_COLUMN_WIDGET_TYPE).getAsString(), columnObject.get(PARAM_COLUMN_LABEL).getAsString());
                columnDefinitions.add(columnDefinition);
            }
            model.setTableColumns(columnDefinitions.toArray(new TableColumn[0]));
        } else {
            this.checkIfRequired(model, PARAM_COLUMNS);
        }
        if (parametersObject.has(PARAM_TABLE_NAME)) {
            model.setTableName(parametersObject.get(PARAM_TABLE_NAME).getAsString());
        } else {
            this.checkIfRequired(model, PARAM_TABLE_NAME);
        }
        if (parametersObject.has(PARAM_PAGE_TITLE)) {
            model.setPageTitle(parametersObject.get(PARAM_PAGE_TITLE).getAsString());
        } else {
            this.checkIfRequired(model, PARAM_PAGE_TITLE);
        }
        if (parametersObject.has(PARAM_SERVICE_ENDPOINT)) {
            model.setServiceEndpoint(parametersObject.get(PARAM_SERVICE_ENDPOINT).getAsString());
        } else {
            this.checkIfRequired(model, PARAM_SERVICE_ENDPOINT);
        }
    }

    public String getTemplates(HttpServletRequest request) throws GenerationException {
        try {
            TemplateType[] templates = TemplateTypesEnumerator.prepareTemplateTypes((String)WebContentEntityTemplateTypeDiscriminator.getTemplatesPath(), (String)WebContentEntityTemplateTypeDiscriminator.getCategory(), (HttpServletRequest)request);
            String result = new Gson().toJson((Object)templates);
            return result;
        }
        catch (Exception e) {
            throw new GenerationException((Throwable)e);
        }
    }
}

