/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.db.service;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dirigible.ide.common.status.LogProgressMonitor;
import org.eclipse.dirigible.ide.template.ui.common.GenerationException;
import org.eclipse.dirigible.ide.template.ui.common.TemplateType;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypesEnumerator;
import org.eclipse.dirigible.ide.template.ui.common.service.AbstractGenerationWorker;
import org.eclipse.dirigible.ide.template.ui.db.service.DataStructureTemplateTypeDiscriminator;
import org.eclipse.dirigible.ide.template.ui.db.wizard.ColumnDefinition;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateModel;
import org.eclipse.dirigible.repository.api.IRepository;

public class DatabaseGenerationWorker
extends AbstractGenerationWorker {
    private static final String PARAM_COLUMN_DEFAULT_VALUE = "defaultValue";
    private static final String PARAM_COLUMN_NOT_NULL = "notNull";
    private static final String PARAM_COLUMN_PRIMARY_KEY = "primaryKey";
    private static final String PARAM_COLUMN_LENGTH = "length";
    private static final String PARAM_COLUMN_TYPE = "type";
    private static final String PARAM_COLUMN_NAME = "name";
    private static final String PARAM_ROWS = "rows";
    private static final String PARAM_QUERY = "query";
    private static final String PARAM_COLUMNS = "columns";

    public DatabaseGenerationWorker(IRepository repository, IWorkspace workspace) {
        super(repository, workspace);
    }

    public String generate(String parameters, HttpServletRequest request) throws GenerationException {
        try {
            JsonElement parametersElement = new JsonParser().parse(parameters);
            JsonObject parametersObject = parametersElement.getAsJsonObject();
            DataStructureTemplateModel model = new DataStructureTemplateModel();
            DataStructureTemplateGenerator generator = new DataStructureTemplateGenerator(model);
            TemplateType[] templates = TemplateTypesEnumerator.prepareTemplateTypes((String)DataStructureTemplateTypeDiscriminator.getTemplatesPath(), (String)DataStructureTemplateTypeDiscriminator.getCategory(), (HttpServletRequest)request);
            this.setParametersToModel(parametersObject, model, templates);
            generator.generate(request);
        }
        catch (Exception e) {
            throw new GenerationException((Throwable)e);
        }
        return "Generation passed successfully.";
    }

    protected void setParametersToModel(JsonObject parametersObject, DataStructureTemplateModel model, TemplateType[] templates) throws GenerationException {
        IProject project;
        if (parametersObject.has("templateType")) {
            String templateType = parametersObject.get("templateType").getAsString();
            TemplateType[] templateTypeArray = templates;
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateType template = templateTypeArray[n2];
                if (template.getLocation().substring(DataStructureTemplateTypeDiscriminator.getTemplatesPath().length()).indexOf(String.valueOf(templateType) + "/") == 0) {
                    model.setTemplate(template);
                    break;
                }
                ++n2;
            }
            if (model.getTemplate() == null) {
                throw new GenerationException(String.format("Template %s does not exist in this instance", templateType));
            }
        } else {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "templateType"));
        }
        if (!parametersObject.has("fileName")) {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "fileName"));
        }
        model.setFileName(parametersObject.get("fileName").getAsString());
        if (parametersObject.has("projectName")) {
            String projectName = parametersObject.get("projectName").getAsString();
            project = this.getWorkspace().getRoot().getProject(projectName);
            if (!project.exists()) {
                try {
                    project.create((IProgressMonitor)new LogProgressMonitor());
                }
                catch (CoreException e) {
                    throw new GenerationException((Throwable)e);
                }
            }
        } else {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "projectName"));
        }
        model.setTargetContainer(project.getFullPath().toString());
        if (!parametersObject.has("packageName")) {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "packageName"));
        }
        String packageName = parametersObject.get("packageName").getAsString();
        model.setProjectPackageName("DataStructures/" + packageName);
        model.setPackageName(packageName);
        if (parametersObject.has(PARAM_COLUMNS)) {
            ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
            JsonArray columns = parametersObject.get(PARAM_COLUMNS).getAsJsonArray();
            for (JsonElement columnElement : columns) {
                if (!columnElement.isJsonObject()) continue;
                JsonObject columnObject = columnElement.getAsJsonObject();
                ColumnDefinition columnDefinition = new ColumnDefinition();
                columnDefinition.setName(columnObject.get(PARAM_COLUMN_NAME).getAsString());
                columnDefinition.setType(columnObject.get(PARAM_COLUMN_TYPE).getAsString());
                columnDefinition.setLength(columnObject.get(PARAM_COLUMN_LENGTH).getAsInt());
                columnDefinition.setPrimaryKey(columnObject.get(PARAM_COLUMN_PRIMARY_KEY).getAsBoolean());
                columnDefinition.setNotNull(columnObject.get(PARAM_COLUMN_NOT_NULL).getAsBoolean());
                columnDefinition.setDefaultValue(columnObject.get(PARAM_COLUMN_DEFAULT_VALUE).getAsString());
                columnDefinitions.add(columnDefinition);
            }
            model.setColumnDefinitions(columnDefinitions.toArray(new ColumnDefinition[0]));
        } else {
            this.checkIfRequired(model, PARAM_COLUMNS);
        }
        if (parametersObject.has(PARAM_QUERY)) {
            model.setQuery(parametersObject.get(PARAM_QUERY).getAsString());
        } else {
            this.checkIfRequired(model, PARAM_QUERY);
        }
        if (parametersObject.has(PARAM_ROWS)) {
            String rows;
            model.setDsvSampleRows(rows.split((rows = parametersObject.get(PARAM_ROWS).getAsString()).indexOf("\n") >= 0 ? "\n" : "\r"));
        } else {
            this.checkIfRequired(model, PARAM_ROWS);
        }
    }

    public String getTemplates(HttpServletRequest request) throws GenerationException {
        try {
            TemplateType[] templates = TemplateTypesEnumerator.prepareTemplateTypes((String)DataStructureTemplateTypeDiscriminator.getTemplatesPath(), (String)DataStructureTemplateTypeDiscriminator.getCategory(), (HttpServletRequest)request);
            String result = new Gson().toJson((Object)templates);
            return result;
        }
        catch (Exception e) {
            throw new GenerationException((Throwable)e);
        }
    }
}

