/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.registry.ui;

import java.net.URL;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.registry.ui.Messages;
import org.eclipse.dirigible.ide.ui.widget.extbrowser.ExtendedBrowser;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class RegistryView
extends ViewPart {
    private static final String REFRESH = Messages.RegistryView_REFRESH;
    private static final URL DIRIGIBLE_REFRESH_ICON_URL = RegistryView.class.getResource("/resources/refresh.png");
    private final ISelectionListener selectionListener = new SelectionListenerImpl();
    private ExtendedBrowser browser = null;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.attachSelectionListener((IWorkbenchPartSite)site);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        Composite holder = new Composite(parent, 0);
        holder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        holder.setLayout((Layout)new GridLayout(3, false));
        Button goButton = new Button(holder, 8);
        goButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        goButton.setToolTipText(REFRESH);
        goButton.setImage(this.createImage(DIRIGIBLE_REFRESH_ICON_URL));
        goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1316287800753595995L;

            public void widgetSelected(SelectionEvent e) {
                RegistryView.this.browser.refresh();
            }
        });
        this.browser = new ExtendedBrowser(parent, 0);
        this.browser.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.setUrl(CommonIDEParameters.getRuntimeUrl());
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        this.detachSelectionListener(this.getSite());
        this.browser = null;
        super.dispose();
    }

    private void attachSelectionListener(IWorkbenchPartSite site) {
        if (site == null) {
            return;
        }
        ISelectionService selectionService = this.getSelectionService(site);
        if (selectionService != null) {
            selectionService.addSelectionListener(this.selectionListener);
        }
    }

    private void detachSelectionListener(IWorkbenchPartSite site) {
        if (site == null) {
            return;
        }
        ISelectionService selectionService = this.getSelectionService(site);
        if (selectionService != null) {
            selectionService.removeSelectionListener(this.selectionListener);
        }
    }

    private ISelectionService getSelectionService(IWorkbenchPartSite site) {
        IWorkbenchWindow window = site.getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getSelectionService();
    }

    private void handleElementSelected(Object element) {
    }

    private Image createImage(URL imageURL) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        return this.resourceManager.createImage(imageDescriptor);
    }

    private class SelectionListenerImpl
    implements ISelectionListener {
        private SelectionListenerImpl() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                this.selectionChanged((IStructuredSelection)selection);
            }
        }

        private void selectionChanged(IStructuredSelection selection) {
            Object element = selection.getFirstElement();
            if (element != null) {
                RegistryView.this.handleElementSelected(element);
            }
        }
    }
}

