/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.debug.ui;

import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.common.CommonIDEUtils;
import org.eclipse.dirigible.ide.debug.model.IDebugIDEController;
import org.eclipse.dirigible.ide.debug.ui.BreakpointViewContentProvider;
import org.eclipse.dirigible.ide.debug.ui.BreakpointViewLabelProvider;
import org.eclipse.dirigible.ide.debug.ui.Messages;
import org.eclipse.dirigible.ide.debug.ui.SessionsViewContentProvider;
import org.eclipse.dirigible.ide.debug.ui.SessionsViewLabelProvider;
import org.eclipse.dirigible.ide.debug.ui.SessionsWSView;
import org.eclipse.dirigible.ide.debug.ui.VariablesViewContentProvider;
import org.eclipse.dirigible.ide.debug.ui.VariablesViewLabelProvider;
import org.eclipse.dirigible.ide.editor.ace.AceEditor;
import org.eclipse.dirigible.ide.editor.orion.OrionEditor;
import org.eclipse.dirigible.ide.workspace.RemoteResourcesPlugin;
import org.eclipse.dirigible.ide.workspace.ui.commands.OpenHandler;
import org.eclipse.dirigible.ide.workspace.ui.view.WebViewerView;
import org.eclipse.dirigible.repository.ext.debug.BreakpointMetadata;
import org.eclipse.dirigible.repository.ext.debug.DebugModel;
import org.eclipse.dirigible.repository.ext.debug.DebugModelFacade;
import org.eclipse.dirigible.repository.ext.debug.DebugSessionModel;
import org.eclipse.dirigible.repository.ext.debug.IDebugController;
import org.eclipse.dirigible.repository.ext.debug.LinebreakMetadata;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DebugView
extends ViewPart
implements IDebugIDEController,
IPropertyListener {
    public static final String ID = "org.eclipse.dirigible.ide.debug.ui.DebugView";
    private static final String INTERNAL_ERROR_DEBUG_BRIDGE_IS_NOT_PRESENT = "Internal error - DebugBridge is not present";
    private static final String DEBUG_PROCESS_TITLE = "Debug Process";
    private static final String FILE = Messages.DebugView_FILE;
    private static final String SLASH = "/";
    private static final String SCRIPTING_SERVICES = "/ScriptingServices";
    private static final String SOURCE = Messages.DebugView_SOURCE;
    private static final String ROW = Messages.DebugView_ROW;
    private static final String VALUES = Messages.DebugView_VALUES;
    private static final String VARIABLES = Messages.DebugView_VARIABLES;
    private static final String SESSIONS = Messages.DebugView_SESSIONS;
    private static final String SKIP_BREAKPOINTS = Messages.DebugView_SKIP_BREAKPOINTS;
    private static final String CONTINUE = Messages.DebugView_CONTINUE;
    private static final String STEP_OVER = Messages.DebugView_STEP_OVER;
    private static final String STEP_INTO = Messages.DebugView_STEP_INTO;
    private static final String REFRESH = Messages.DebugView_REFRESH;
    private static final URL DIRIGIBLE_TERMINATE_ICON_URL = DebugView.class.getResource("/resources/terminate.png");
    private static final URL DIRIGIBLE_CONTINUE_ICON_URL = DebugView.class.getResource("/resources/resume.png");
    private static final URL DIRIGIBLE_STEP_OVER_ICON_URL = DebugView.class.getResource("/resources/step-out.png");
    private static final URL DIRIGIBLE_STEP_INTO_ICON_URL = DebugView.class.getResource("/resources/step-into.png");
    private static final URL DIRIGIBLE_REFRESH_ICON_URL = DebugView.class.getResource("/resources/refresh.png");
    private static final Logger logger = Logger.getLogger(DebugView.class);
    private static final int MAX_WAITS = 20;
    private static final int SLEEP_TIME = 500;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private TreeViewer sessionsTreeViewer;
    private SessionsViewContentProvider sessionsContentProvider;
    private TreeViewer variablesTreeViewer;
    private VariablesViewContentProvider variablesContentProvider;
    private TreeViewer breakpointsTreeViewer;
    private BreakpointViewContentProvider breakpointsContentProvider;
    private boolean sessionsMetadataRecieved = false;
    private boolean previewListenerRegistered = false;
    Button stepIntoButton;
    Button stepOverButton;
    Button continueButton;
    Button skipAllBreakpointsButton;
    private boolean isRAPView = false;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.registerPreviewListener(this);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        DebugModelFacade.createDebugModel((String)CommonIDEParameters.getUserName(), (IDebugController)this);
        Composite holder = new Composite(parent, 0);
        holder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        holder.setLayout((Layout)new GridLayout(8, false));
        this.createButtonsRow(holder);
        SashForm sashFormSessions = new SashForm(parent, 2304);
        sashFormSessions.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.isRAPView) {
            this.createSessionsTableRAP((Composite)sashFormSessions);
        } else {
            this.createSessionsTable((Composite)sashFormSessions);
        }
        SashForm sashForm = new SashForm((Composite)sashFormSessions, 2304);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createVariablesTable((Composite)sashForm);
        this.createBreakpointsTable((Composite)sashForm);
        this.registerPreviewListener(this);
        this.enableDebugButtons(true);
    }

    private void registerPreviewListener(DebugView debugView) {
        IWorkbenchPage workbenchPage;
        if (!this.previewListenerRegistered && (workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            IViewPart viewPart = workbenchPage.findView(WebViewerView.ID);
            if (viewPart == null) {
                try {
                    viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(WebViewerView.ID);
                }
                catch (PartInitException e) {
                    this.logError(e.getMessage(), e);
                    return;
                }
            }
            viewPart.addPropertyListener((IPropertyListener)debugView);
            this.previewListenerRegistered = true;
        }
    }

    private DebugSessionModel refreshMetaData() {
        DebugSessionModel session = this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession();
        this.refreshAllViews();
        return session;
    }

    private void createButtonsRow(Composite holder) {
        if (this.isRAPView) {
            Button refreshButton = this.createButton(holder, REFRESH, DIRIGIBLE_REFRESH_ICON_URL);
            refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private static final long serialVersionUID = 1316287800753595995L;

                public void widgetSelected(SelectionEvent e) {
                    DebugView.this.waitForMetadata(DebugView.this.refreshMetaData());
                }
            });
        }
        this.stepIntoButton = this.createButton(holder, STEP_INTO, DIRIGIBLE_STEP_INTO_ICON_URL);
        this.stepIntoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = -2027392635482495783L;

            public void widgetSelected(SelectionEvent e) {
                DebugSessionModel session = DebugView.this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession();
                if (session != null) {
                    DebugView.this.stepInto();
                    DebugView.this.waitForMetadata(session);
                }
            }
        });
        this.stepOverButton = this.createButton(holder, STEP_OVER, DIRIGIBLE_STEP_OVER_ICON_URL);
        this.stepOverButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 6512558201116618008L;

            public void widgetSelected(SelectionEvent e) {
                DebugSessionModel session = DebugView.this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession();
                if (session != null) {
                    DebugView.this.stepOver();
                    DebugView.this.waitForMetadata(session);
                }
            }
        });
        this.continueButton = this.createButton(holder, CONTINUE, DIRIGIBLE_CONTINUE_ICON_URL);
        this.continueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = -478646368834480614L;

            public void widgetSelected(SelectionEvent e) {
                DebugSessionModel session = DebugView.this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession();
                if (session != null) {
                    DebugView.this.continueExecution();
                    DebugView.this.waitForMetadata(session);
                }
            }
        });
        this.skipAllBreakpointsButton = this.createButton(holder, SKIP_BREAKPOINTS, DIRIGIBLE_TERMINATE_ICON_URL);
        this.skipAllBreakpointsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 5141833336402908961L;

            public void widgetSelected(SelectionEvent e) {
                DebugSessionModel session = DebugView.this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession();
                if (session != null) {
                    DebugView.this.skipAllBreakpoints();
                    DebugView.this.waitForMetadata(session);
                }
            }
        });
        this.enableDebugButtons(false);
    }

    private Button createButton(Composite holder, String toolTipText, URL imageUrl) {
        Button button = new Button(holder, 8);
        button.setLayoutData((Object)new GridData(131072, 128, false, false));
        button.setToolTipText(toolTipText);
        button.setImage(this.createImage(imageUrl));
        return button;
    }

    private void createSessionsTableRAP(Composite holder) {
        this.sessionsTreeViewer = new TreeViewer(holder, 770);
        this.sessionsTreeViewer.getTree().setHeaderVisible(true);
        Tree tree = this.sessionsTreeViewer.getTree();
        TreeColumn column = new TreeColumn(tree, 16384);
        column.setText(SESSIONS);
        column.setWidth(150);
        this.sessionsContentProvider = new SessionsViewContentProvider();
        this.sessionsTreeViewer.setContentProvider((IContentProvider)this.sessionsContentProvider);
        this.sessionsTreeViewer.setLabelProvider((IBaseLabelProvider)new SessionsViewLabelProvider());
        this.sessionsTreeViewer.setInput((Object)this.getViewSite());
        this.sessionsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                    String sessionInfo = (String)structuredSelection.getFirstElement();
                    DebugView.this.selectedSessionTreeItem(sessionInfo);
                }
            }
        });
    }

    private void createSessionsTable(Composite holder) {
        new SessionsWSView(holder);
    }

    private void selectedSessionTreeItem(String sessionInfo) {
        StringTokenizer tokenizer = new StringTokenizer(sessionInfo, ":");
        tokenizer.nextToken();
        tokenizer.nextToken();
        String executionId = tokenizer.nextToken();
        this.selectedDebugSession(executionId);
    }

    private void selectedDebugSession(String executionId) {
        DebugSessionModel session = this.getDebugModel(CommonIDEParameters.getUserName()).getSessionByExecutionId(executionId);
        this.getDebugModel(CommonIDEParameters.getUserName()).setActiveSession(session);
    }

    private void createVariablesTable(Composite holder) {
        this.variablesTreeViewer = new TreeViewer(holder, 770);
        this.variablesTreeViewer.getTree().setHeaderVisible(true);
        Tree tree = this.variablesTreeViewer.getTree();
        TreeColumn column = new TreeColumn(tree, 16384);
        column.setText(VARIABLES);
        column.setWidth(150);
        column = new TreeColumn(tree, 16384);
        column.setText(VALUES);
        column.setWidth(595);
        this.variablesContentProvider = new VariablesViewContentProvider(this.getDebugModel(CommonIDEParameters.getUserName()));
        this.variablesTreeViewer.setContentProvider((IContentProvider)this.variablesContentProvider);
        this.variablesTreeViewer.setLabelProvider((IBaseLabelProvider)new VariablesViewLabelProvider());
        this.variablesTreeViewer.setInput((Object)this.getViewSite());
    }

    private void createBreakpointsTable(Composite holder) {
        this.breakpointsTreeViewer = new TreeViewer(holder, 770);
        this.breakpointsTreeViewer.getTree().setHeaderVisible(true);
        Tree tree = this.breakpointsTreeViewer.getTree();
        TreeColumn column = new TreeColumn(tree, 16384);
        column.setText(FILE);
        column.setWidth(150);
        column = new TreeColumn(this.breakpointsTreeViewer.getTree(), 16384);
        column.setText(ROW);
        column.setWidth(50);
        column = new TreeColumn(this.breakpointsTreeViewer.getTree(), 16384);
        column.setText(SOURCE);
        column.setWidth(350);
        this.breakpointsContentProvider = new BreakpointViewContentProvider(this.getDebugModel(CommonIDEParameters.getUserName()).getBreakpointsMetadata());
        this.breakpointsTreeViewer.setContentProvider((IContentProvider)this.breakpointsContentProvider);
        this.breakpointsTreeViewer.setLabelProvider((IBaseLabelProvider)new BreakpointViewLabelProvider());
        this.breakpointsTreeViewer.setInput((Object)this.getViewSite());
        this.breakpointsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                logger.debug("DebugView -> BreakpointsView -> selectionChanged");
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                    BreakpointMetadata breakpointMetadata = (BreakpointMetadata)structuredSelection.getFirstElement();
                    DebugView.this.openEditor(CommonIDEUtils.formatToIDEPath((String)"ScriptingServices", (String)breakpointMetadata.getFullPath()), breakpointMetadata.getRow());
                }
            }
        });
    }

    private void refreshAllViews() {
        try {
            this.breakpointsTreeViewer.refresh(true);
            this.variablesTreeViewer.refresh(true);
            this.sessionsTreeViewer.refresh(true);
            if (this.sessionsTreeViewer.getSelection().isEmpty() && !DebugModelFacade.getDebugModel((String)CommonIDEParameters.getUserName()).getSessions().isEmpty()) {
                TreeItem treeItem = this.sessionsTreeViewer.getTree().getTopItem();
                this.sessionsTreeViewer.getTree().setSelection(treeItem);
                this.selectedSessionTreeItem(treeItem.getText());
            }
            this.enableDebugButtons(true);
        }
        catch (Exception exception) {}
    }

    private void enableDebugButtons(boolean enabled) {
        this.stepIntoButton.setEnabled(enabled);
        this.stepOverButton.setEnabled(enabled);
        this.continueButton.setEnabled(enabled);
        this.skipAllBreakpointsButton.setEnabled(enabled);
    }

    private void waitForMetadata(final DebugSessionModel session) {
        if (session == null) {
            return;
        }
        final Display display = PlatformUI.createDisplay();
        final ServerPushSession pushSession = new ServerPushSession();
        Runnable backGroundRunnable = new Runnable(){
            boolean openEditor = false;

            @Override
            public void run() {
                int wait = 0;
                while (wait < 20) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        DebugView.this.logError(e.getMessage(), e);
                    }
                    ++wait;
                    if (session.isUpdated()) {
                        DebugView.this.refreshAllViews();
                    }
                    if (session.getCurrentLineBreak() != null) {
                        this.openEditor = true;
                        wait = 20;
                    }
                    session.setUpdated(false);
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DebugView.this.refreshMetaData();
                        if (openEditor) {
                            String path = session.getCurrentLineBreak().getBreakpoint().getFullPath();
                            Integer row = session.getCurrentLineBreak().getBreakpoint().getRow();
                            try {
                                DebugView.this.openEditor(CommonIDEUtils.formatToIDEPath((String)"ScriptingServices", (String)path), row);
                            }
                            catch (Exception e) {
                                logger.warn(e.getMessage());
                            }
                            openEditor = false;
                        }
                        pushSession.stop();
                    }
                });
            }
        };
        pushSession.start();
        Thread backGroundThread = new Thread(backGroundRunnable);
        backGroundThread.setDaemon(true);
        backGroundThread.start();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    private Image createImage(URL imageURL) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        return this.resourceManager.createImage(imageDescriptor);
    }

    public void register(DebugSessionModel session) {
        this.sessionsMetadataRecieved = true;
    }

    public void finish(DebugSessionModel session) {
        session.getModel().removeSession(session);
        this.sessionsMetadataRecieved = true;
    }

    public void onLineChange(LinebreakMetadata linebreak, DebugSessionModel session) {
        session.setCurrentLineBreak(linebreak);
        this.sessionsMetadataRecieved = true;
    }

    public void refreshVariables() {
        this.sessionsMetadataRecieved = true;
    }

    public void refreshBreakpoints() {
        this.sessionsMetadataRecieved = true;
    }

    public void removeSession(String sessionId, String executionId, String userId) {
        DebugModelFacade.getInstance().removeSession(userId, executionId);
    }

    public DebugModel getDebugModel(String user) {
        return DebugModelFacade.getDebugModel((String)user);
    }

    public DebugSessionModel getDebugSessionModel(String executionId, String userId) {
        return this.getDebugModel(userId).getSessionByExecutionId(executionId);
    }

    public void refresh() {
    }

    private boolean checkDebugExecutor() {
        if (this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession() == null) {
            logger.error("No active debug session");
            return false;
        }
        if (this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession().getDebugExecutor() == null) {
            logger.error("Active debug session exists, but there is no executor assigned");
            return false;
        }
        return true;
    }

    public void stepInto() {
        if (this.checkDebugExecutor()) {
            this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession().getDebugExecutor().stepInto();
        }
    }

    public void stepOver() {
        if (this.checkDebugExecutor()) {
            this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession().getDebugExecutor().stepOver();
        }
    }

    public void continueExecution() {
        if (this.checkDebugExecutor()) {
            this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession().getDebugExecutor().continueExecution();
        }
    }

    public void skipAllBreakpoints() {
        if (this.checkDebugExecutor()) {
            this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession().getDebugExecutor().skipAllBreakpoints();
        }
    }

    public IEditorPart openEditor(String path, int row) {
        IProject[] projects;
        Path location = new Path(path);
        IWorkspace workspace = RemoteResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        if (root.exists((IPath)location)) {
            IFile file = root.getFile((IPath)location);
            return this.openWorkspaceFile(row, file);
        }
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists((IPath)location)) {
                IFile file = project.getFile((IPath)location);
                return this.openWorkspaceFile(row, file);
            }
            ++n2;
        }
        return null;
    }

    private IEditorPart openWorkspaceFile(int row, IFile file) {
        IEditorPart sourceCodeEditor = OpenHandler.open((Object)file, (int)row);
        if (sourceCodeEditor != null && sourceCodeEditor instanceof AceEditor) {
            ((AceEditor)sourceCodeEditor).setDebugRow(row);
        } else if (sourceCodeEditor != null && sourceCodeEditor instanceof OrionEditor) {
            ((OrionEditor)sourceCodeEditor).setDebugRow(row);
        }
        return sourceCodeEditor;
    }

    public void setBreakpoint(String path, int row) {
        BreakpointMetadata breakpoint = new BreakpointMetadata(path, Integer.valueOf(row));
        this.getDebugModel(CommonIDEParameters.getUserName()).getBreakpointsMetadata().getBreakpoints().add(breakpoint);
        this.refreshAllViews();
    }

    public void clearBreakpoint(String path, int row) {
        BreakpointMetadata breakpoint = new BreakpointMetadata(path, Integer.valueOf(row));
        Set breakpoints = this.getDebugModel(CommonIDEParameters.getUserName()).getBreakpointsMetadata().getBreakpoints();
        Iterator iterator = breakpoints.iterator();
        while (iterator.hasNext()) {
            BreakpointMetadata breakpointMetadata = (BreakpointMetadata)iterator.next();
            if (!breakpointMetadata.equals((Object)breakpoint)) continue;
            iterator.remove();
            break;
        }
        this.refreshAllViews();
    }

    public void clearAllBreakpoints() {
        this.getDebugModel(CommonIDEParameters.getUserName()).getBreakpointsMetadata().getBreakpoints().clear();
    }

    private void logError(String message, Throwable t) {
        if (logger.isErrorEnabled()) {
            logger.error(message, t);
        }
    }

    private void logDebug(String message) {
        if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
    }

    private void logWarn(String message) {
        if (logger.isWarnEnabled()) {
            logger.warn(message);
        }
    }

    private void refreshSessionsView() {
        final Display display = PlatformUI.createDisplay();
        final ServerPushSession pushSession = new ServerPushSession();
        Runnable backGroundRunnable = new Runnable(){

            @Override
            public void run() {
                int wait = 0;
                while (wait < 20) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        DebugView.this.logError(e.getMessage(), e);
                    }
                    ++wait;
                    if (!DebugView.this.sessionsMetadataRecieved) continue;
                    DebugView.this.sessionsMetadataRecieved = false;
                    wait = 20;
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DebugView.this.refreshAllViews();
                        pushSession.stop();
                    }
                });
            }
        };
        pushSession.start();
        Thread backGroundThread = new Thread(backGroundRunnable);
        backGroundThread.setDaemon(true);
        backGroundThread.start();
    }

    public void propertyChanged(Object source, int propId) {
        this.waitForMetadata(this.getDebugModel(CommonIDEParameters.getUserName()).getActiveSession());
    }
}

