/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.ServletRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.RequestDispatcherAdaptor;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;

public class HttpServletRequestWrapperImpl
extends HttpServletRequestWrapper {
    private final Stack<DispatchTargets> dispatchTargets = new Stack();
    private final HttpServletRequest request;
    private Map<String, Part> parts;
    private final Lock lock = new ReentrantLock();
    private static final Set<String> dispatcherAttributes = new HashSet<String>();

    static {
        dispatcherAttributes.add("javax.servlet.error.exception");
        dispatcherAttributes.add("javax.servlet.error.exception_type");
        dispatcherAttributes.add("javax.servlet.error.message");
        dispatcherAttributes.add("javax.servlet.error.request_uri");
        dispatcherAttributes.add("javax.servlet.error.servlet_name");
        dispatcherAttributes.add("javax.servlet.error.status_code");
        dispatcherAttributes.add("javax.servlet.forward.context_path");
        dispatcherAttributes.add("javax.servlet.forward.path_info");
        dispatcherAttributes.add("javax.servlet.forward.query_string");
        dispatcherAttributes.add("javax.servlet.forward.request_uri");
        dispatcherAttributes.add("javax.servlet.forward.servlet_path");
        dispatcherAttributes.add("javax.servlet.include.context_path");
        dispatcherAttributes.add("javax.servlet.include.path_info");
        dispatcherAttributes.add("javax.servlet.include.query_string");
        dispatcherAttributes.add("javax.servlet.include.request_uri");
        dispatcherAttributes.add("javax.servlet.include.servlet_path");
    }

    public static HttpServletRequestWrapperImpl findHttpRuntimeRequest(HttpServletRequest request) {
        while (request instanceof HttpServletRequestWrapper) {
            if (request instanceof HttpServletRequestWrapperImpl) {
                return (HttpServletRequestWrapperImpl)request;
            }
            request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
        }
        return null;
    }

    public HttpServletRequestWrapperImpl(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public String getAuthType() {
        String authType = (String)this.getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            return authType;
        }
        return this.request.getAuthType();
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return this.request.getRemoteUser();
    }

    public String getPathInfo() {
        DispatchTargets currentDispatchTargets = this.dispatchTargets.peek();
        if (currentDispatchTargets.getServletName() != null || currentDispatchTargets.getDispatcherType() == DispatcherType.INCLUDE) {
            return ((DispatchTargets)this.dispatchTargets.get(0)).getPathInfo();
        }
        return currentDispatchTargets.getPathInfo();
    }

    public DispatcherType getDispatcherType() {
        return this.dispatchTargets.peek().getDispatcherType();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.dispatchTargets.peek().getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public String getQueryString() {
        DispatchTargets currentDispatchTargets = this.dispatchTargets.peek();
        if (currentDispatchTargets.getServletName() != null || currentDispatchTargets.getDispatcherType() == DispatcherType.INCLUDE) {
            return this.request.getQueryString();
        }
        return currentDispatchTargets.getQueryString();
    }

    public String getRequestURI() {
        DispatchTargets currentDispatchTargets = this.dispatchTargets.peek();
        if (currentDispatchTargets.getServletName() != null || currentDispatchTargets.getDispatcherType() == DispatcherType.INCLUDE) {
            return this.request.getRequestURI();
        }
        return currentDispatchTargets.getRequestURI();
    }

    public ServletContext getServletContext() {
        return this.dispatchTargets.peek().getServletRegistration().getServletContext();
    }

    public String getServletPath() {
        DispatchTargets currentDispatchTargets = this.dispatchTargets.peek();
        if (currentDispatchTargets.getServletName() != null || currentDispatchTargets.getDispatcherType() == DispatcherType.INCLUDE) {
            return ((DispatchTargets)this.dispatchTargets.get(0)).getServletPath();
        }
        if (currentDispatchTargets.getServletPath().equals("/")) {
            return "";
        }
        return currentDispatchTargets.getServletPath();
    }

    public String getContextPath() {
        return this.dispatchTargets.peek().getContextController().getFullContextPath();
    }

    public Object getAttribute(String attributeName) {
        DispatchTargets current = this.dispatchTargets.peek();
        DispatcherType dispatcherType = current.getDispatcherType();
        boolean hasServletName = current.getServletName() != null;
        Map<String, Object> specialOverides = current.getSpecialOverides();
        if (dispatcherType == DispatcherType.ERROR) {
            if (dispatcherAttributes.contains(attributeName) && !attributeName.startsWith("javax.servlet.error.")) {
                return null;
            }
        } else if (dispatcherType == DispatcherType.INCLUDE) {
            if (attributeName.equals("javax.servlet.include.context_path")) {
                if (hasServletName) {
                    return null;
                }
                if (specialOverides.containsKey("javax.servlet.include.context_path")) {
                    return specialOverides.get("javax.servlet.include.context_path");
                }
                return current.getContextController().getContextPath();
            }
            if (attributeName.equals("javax.servlet.include.path_info")) {
                if (hasServletName) {
                    return null;
                }
                if (specialOverides.containsKey("javax.servlet.include.path_info")) {
                    return specialOverides.get("javax.servlet.include.path_info");
                }
                return current.getPathInfo();
            }
            if (attributeName.equals("javax.servlet.include.query_string")) {
                if (hasServletName) {
                    return null;
                }
                if (specialOverides.containsKey("javax.servlet.include.query_string")) {
                    return specialOverides.get("javax.servlet.include.query_string");
                }
                return current.getQueryString();
            }
            if (attributeName.equals("javax.servlet.include.request_uri")) {
                if (hasServletName) {
                    return null;
                }
                if (specialOverides.containsKey("javax.servlet.include.request_uri")) {
                    return specialOverides.get("javax.servlet.include.request_uri");
                }
                return current.getRequestURI();
            }
            if (attributeName.equals("javax.servlet.include.servlet_path")) {
                if (hasServletName) {
                    return null;
                }
                if (specialOverides.containsKey("javax.servlet.include.servlet_path")) {
                    return specialOverides.get("javax.servlet.include.servlet_path");
                }
                return current.getServletPath();
            }
            if (dispatcherAttributes.contains(attributeName)) {
                return null;
            }
        } else if (dispatcherType == DispatcherType.FORWARD) {
            if (hasServletName && attributeName.startsWith("javax.servlet.forward")) {
                return null;
            }
            DispatchTargets original = (DispatchTargets)this.dispatchTargets.get(0);
            if (attributeName.equals("javax.servlet.forward.context_path")) {
                if (specialOverides.containsKey("javax.servlet.forward.context_path")) {
                    return specialOverides.get("javax.servlet.forward.context_path");
                }
                return original.getContextController().getContextPath();
            }
            if (attributeName.equals("javax.servlet.forward.path_info")) {
                if (specialOverides.containsKey("javax.servlet.forward.path_info")) {
                    return specialOverides.get("javax.servlet.forward.path_info");
                }
                return original.getPathInfo();
            }
            if (attributeName.equals("javax.servlet.forward.query_string")) {
                if (specialOverides.containsKey("javax.servlet.forward.query_string")) {
                    return specialOverides.get("javax.servlet.forward.query_string");
                }
                return original.getQueryString();
            }
            if (attributeName.equals("javax.servlet.forward.request_uri")) {
                if (specialOverides.containsKey("javax.servlet.forward.request_uri")) {
                    return specialOverides.get("javax.servlet.forward.request_uri");
                }
                return original.getRequestURI();
            }
            if (attributeName.equals("javax.servlet.forward.servlet_path")) {
                if (specialOverides.containsKey("javax.servlet.forward.servlet_path")) {
                    return specialOverides.get("javax.servlet.forward.servlet_path");
                }
                return original.getServletPath();
            }
            if (dispatcherAttributes.contains(attributeName)) {
                return null;
            }
        }
        return this.request.getAttribute(attributeName);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        DispatchTargets currentDispatchTarget = this.dispatchTargets.peek();
        ContextController contextController = currentDispatchTarget.getContextController();
        if (!path.startsWith("/")) {
            path = String.valueOf(currentDispatchTarget.getServletPath()) + "/" + path;
        } else if (path.startsWith(contextController.getFullContextPath())) {
            path = path.substring(contextController.getFullContextPath().length());
        }
        DispatchTargets requestedDispatchTargets = contextController.getDispatchTargets(path, null);
        if (requestedDispatchTargets == null) {
            return null;
        }
        return new RequestDispatcherAdaptor(requestedDispatchTargets, path);
    }

    public static String getDispatchPathInfo(HttpServletRequest req) {
        if (req.getDispatcherType() == DispatcherType.INCLUDE) {
            return (String)req.getAttribute("javax.servlet.include.path_info");
        }
        return req.getPathInfo();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = this.request.getSession(create);
        if (session != null) {
            DispatchTargets currentDispatchTarget = this.dispatchTargets.peek();
            return currentDispatchTarget.getContextController().getSessionAdaptor(session, ((Servlet)currentDispatchTarget.getServletRegistration().getT()).getServletConfig().getServletContext());
        }
        return null;
    }

    public synchronized void pop() {
        if (this.dispatchTargets.size() > 1) {
            this.dispatchTargets.pop();
        }
    }

    public synchronized void push(DispatchTargets toPush) {
        toPush.addRequestParameters(this.request);
        this.dispatchTargets.push(toPush);
    }

    public void removeAttribute(String name) {
        if (dispatcherAttributes.contains(name)) {
            DispatchTargets current = this.dispatchTargets.peek();
            current.getSpecialOverides().remove(name);
        } else {
            this.request.removeAttribute(name);
        }
        DispatchTargets currentDispatchTarget = this.dispatchTargets.peek();
        EventListeners eventListeners = currentDispatchTarget.getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(currentDispatchTarget.getServletRegistration().getServletContext(), (ServletRequest)this, name, null);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
        }
    }

    public void setAttribute(String name, Object value) {
        boolean added;
        boolean bl = added = this.request.getAttribute(name) == null;
        if (dispatcherAttributes.contains(name)) {
            DispatchTargets current = this.dispatchTargets.peek();
            if (value == null) {
                current.getSpecialOverides().remove(name);
            } else {
                current.getSpecialOverides().put(name, value);
            }
        } else {
            this.request.setAttribute(name, value);
        }
        DispatchTargets currentDispatchTarget = this.dispatchTargets.peek();
        EventListeners eventListeners = currentDispatchTarget.getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(currentDispatchTarget.getServletRegistration().getServletContext(), (ServletRequest)this, name, value);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            if (added) {
                servletRequestAttributeListener.attributeAdded(servletRequestAttributeEvent);
                continue;
            }
            servletRequestAttributeListener.attributeReplaced(servletRequestAttributeEvent);
        }
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this.getParts0().get(name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return new ArrayList<Part>(this.getParts0().values());
    }

    private Map<String, Part> getParts0() throws IOException, ServletException {
        ServletRegistration servletRegistration = this.getServletRegistration();
        if (servletRegistration == null) {
            throw new ServletException("Not a servlet request!");
        }
        this.lock.lock();
        try {
            if (this.parts != null) {
                Map<String, Part> map = this.parts;
                return map;
            }
            this.parts = servletRegistration.parseRequest((HttpServletRequest)this);
            Map<String, Part> map = this.parts;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ServletRegistration getServletRegistration() {
        EndpointRegistration<?> servletRegistration = this.dispatchTargets.peek().getServletRegistration();
        if (servletRegistration instanceof ServletRegistration) {
            return (ServletRegistration)servletRegistration;
        }
        return null;
    }
}

