/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common.service;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.dirigible.ide.template.ui.common.GenerationException;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateParameterMetadata;
import org.eclipse.dirigible.repository.api.IRepository;

public abstract class AbstractGenerationWorker {
    protected static final String PARAM_PACKAGE_NAME = "packageName";
    protected static final String PARAM_PROJECT_NAME = "projectName";
    protected static final String PARAM_FILE_NAME = "fileName";
    protected static final String PARAM_TEMPLATE_TYPE = "templateType";
    protected static final String GENERATION_PASSED_SUCCESSFULLY = "Generation passed successfully.";
    protected static final String MANDATORY_PARAMETER_S_HAS_NOT_BEEN_PROVIDED = "Mandatory parameter [%s] has not been provided";
    protected static final String TEMPLATE_S_DOES_NOT_EXIST_IN_THIS_INSTANCE = "Template %s does not exist in this instance";
    private IRepository repository;
    private IWorkspace workspace;

    public AbstractGenerationWorker(IRepository repository, IWorkspace workspace) {
        this.repository = repository;
        this.workspace = workspace;
    }

    public abstract String generate(String var1, HttpServletRequest var2) throws GenerationException;

    public abstract String enumerateTemplates(HttpServletRequest var1) throws GenerationException;

    public IRepository getRepository() {
        return this.repository;
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    protected boolean isBuiltInParameter(String param) {
        return PARAM_PACKAGE_NAME.equals(param) || PARAM_PROJECT_NAME.equals(param) || PARAM_FILE_NAME.equals(param) || PARAM_TEMPLATE_TYPE.equals(param);
    }

    protected void checkIfRequired(GenerationModel model, String param) throws GenerationException {
        TemplateParameterMetadata[] requiredParameters;
        TemplateParameterMetadata[] templateParameterMetadataArray = requiredParameters = model.getTemplate().getTemplateMetadata().getParameters();
        int n = requiredParameters.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateParameterMetadata requiredParameter = templateParameterMetadataArray[n2];
            if (requiredParameter != null && param.equals(requiredParameter.getName()) && requiredParameter.isRequired()) {
                throw new GenerationException(String.format(MANDATORY_PARAMETER_S_HAS_NOT_BEEN_PROVIDED, param));
            }
            ++n2;
        }
    }
}

