/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.twiki.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class DefinitionListBlock
extends Block {
    private static final Pattern startPattern = Pattern.compile(" {3}\\$\\s+([^:]+):\\s+(.+)");
    private int blockLineCount;
    private Matcher matcher;

    protected int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_LIST, new Attributes());
        } else {
            this.matcher = startPattern.matcher(line);
            if (!this.matcher.matches()) {
                this.setClosed(true);
                return 0;
            }
        }
        ++this.blockLineCount;
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_TERM, new Attributes());
        this.markupLanguage.emitMarkupLine(this.parser, this.state, this.matcher.start(1), this.matcher.group(1), 0);
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_ITEM, new Attributes());
        this.markupLanguage.emitMarkupLine(this.parser, this.state, this.matcher.start(2), this.matcher.group(2), 0);
        this.builder.endBlock();
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            this.blockLineCount = 0;
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

