/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.publish.ui.command;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.publish.PublishManager;
import org.eclipse.dirigible.ide.publish.ui.command.PublishCommandMessages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ActivateFileCommandHandler
extends AbstractHandler {
    private static final String NO_PROJECTS_IN_SELECTION_NOTHING_TO_ACTIVATE = PublishCommandMessages.NO_PROJECTS_IN_SELECTION_NOTHING_TO_ACTIVATE;
    private static final String NOTHING_IS_SELECTED_TO_BE_ACTIVATED = PublishCommandMessages.NOTHING_IS_SELECTED_TO_BE_ACTIVATED;
    private static final Logger logger = Logger.getLogger(ActivateFileCommandHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection.isEmpty()) {
            logger.warn(NOTHING_IS_SELECTED_TO_BE_ACTIVATED);
            return null;
        }
        IFile[] files = PublishManager.getFiles((ISelection)selection);
        if (files.length == 0) {
            logger.warn(NO_PROJECTS_IN_SELECTION_NOTHING_TO_ACTIVATE);
            return null;
        }
        boolean success = true;
        String errorMessage = null;
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            try {
                this.activateFile(file);
                StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_ACTIVATED, file.getName()));
            }
            catch (Exception ex) {
                errorMessage = ex.getMessage();
                logger.error(errorMessage, (Throwable)ex);
                success = false;
            }
            ++n2;
        }
        if (!success) {
            logger.error(errorMessage);
            MessageDialog.openError(null, (String)PublishCommandMessages.ACTIVATION_FAIL_TITLE, errorMessage);
        }
        return null;
    }

    protected void activateFile(IFile file) throws PublishException {
        List publishers = PublishManager.getPublishers();
        for (IPublisher publisher : publishers) {
            publisher.activateFile(file);
        }
    }
}

