/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.parser;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.poi.xwpf.usermodel.IBody;
import org.obeonetwork.m2doc.parser.ParsingToken;
import org.obeonetwork.m2doc.parser.TokenIterator;

public class TokenProvider
implements Iterator<ParsingToken> {
    private TokenIterator runIterator;
    private LinkedList<ParsingToken> lookAhead;

    public TokenProvider(IBody body) {
        this.runIterator = new TokenIterator(body);
        this.lookAhead = new LinkedList();
    }

    public ParsingToken lookAhead(int i) {
        this.loadNext(i);
        if (this.lookAhead.size() == 0 && i > 0) {
            return null;
        }
        return this.lookAhead.get(i - 1);
    }

    public boolean hasElements(int i) {
        this.loadNext(i);
        return this.lookAhead.size() >= i;
    }

    private void loadNext(int i) {
        int laSize = this.lookAhead.size();
        int leftToRead = i - laSize;
        int j = 0;
        while (this.runIterator.hasNext() && j < leftToRead) {
            this.lookAhead.addLast(this.runIterator.next());
            ++j;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.lookAhead.isEmpty() || this.runIterator.hasNext();
    }

    @Override
    public ParsingToken next() {
        if (!this.lookAhead.isEmpty()) {
            return this.lookAhead.removeFirst();
        }
        return this.runIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

