/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;
import org.junit.platform.suite.engine.IsSuiteClass;
import org.junit.platform.suite.engine.SuiteEngineDescriptor;
import org.junit.platform.suite.engine.SuiteTestDescriptor;

final class ClassSelectorResolver
implements SelectorResolver {
    private static final IsSuiteClass isSuiteClass = new IsSuiteClass();
    private final Predicate<String> classNameFilter;
    private final SuiteEngineDescriptor suiteEngineDescriptor;
    private final ConfigurationParameters configurationParameters;

    ClassSelectorResolver(Predicate<String> classNameFilter, SuiteEngineDescriptor suiteEngineDescriptor, ConfigurationParameters configurationParameters) {
        this.classNameFilter = classNameFilter;
        this.suiteEngineDescriptor = suiteEngineDescriptor;
        this.configurationParameters = configurationParameters;
    }

    public SelectorResolver.Resolution resolve(ClassSelector selector, SelectorResolver.Context context) {
        Class testClass = selector.getJavaClass();
        if (isSuiteClass.test(testClass) && this.classNameFilter.test(testClass.getName())) {
            Optional<SuiteTestDescriptor> suiteWithDiscoveryRequest = context.addToParent(parent -> this.newSuiteDescriptor(testClass, (TestDescriptor)parent)).map(suite -> suite.addDiscoveryRequestFrom(testClass));
            return ClassSelectorResolver.toResolution(suiteWithDiscoveryRequest);
        }
        return SelectorResolver.Resolution.unresolved();
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        UniqueId engineId = this.suiteEngineDescriptor.getUniqueId();
        List resolvedSegments = engineId.getSegments();
        return uniqueId.getSegments().stream().skip(resolvedSegments.size()).findFirst().filter(suiteSegment -> "suite".equals(suiteSegment.getType())).flatMap(ClassSelectorResolver::tryLoadSuiteClass).filter(isSuiteClass).map(suiteClass -> context.addToParent(parent -> this.newSuiteDescriptor((Class<?>)suiteClass, (TestDescriptor)parent)).map(suite -> uniqueId.equals((Object)suite.getUniqueId()) ? suite.addDiscoveryRequestFrom((Class<?>)suiteClass) : suite.addDiscoveryRequestFrom(uniqueId))).map(ClassSelectorResolver::toResolution).orElseGet(SelectorResolver.Resolution::unresolved);
    }

    private static Optional<Class<?>> tryLoadSuiteClass(UniqueId.Segment segment) {
        return ReflectionUtils.tryToLoadClass((String)segment.getValue()).toOptional();
    }

    private static SelectorResolver.Resolution toResolution(Optional<SuiteTestDescriptor> suite) {
        return suite.map(SelectorResolver.Match::exact).map(SelectorResolver.Resolution::match).orElseGet(SelectorResolver.Resolution::unresolved);
    }

    private Optional<SuiteTestDescriptor> newSuiteDescriptor(Class<?> suiteClass, TestDescriptor parent) {
        UniqueId id = parent.getUniqueId().append("suite", suiteClass.getName());
        return Optional.of(new SuiteTestDescriptor(id, suiteClass, this.configurationParameters));
    }
}

