/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareFilter;
import org.eclipse.compare.internal.CompareFilterDescriptor;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public class ChangeCompareFilterPropertyAction
extends Action
implements IPropertyChangeListener,
DisposeListener {
    public static final String COMPARE_FILTERS = "COMPARE_FILTERS";
    public static final String COMPARE_FILTER_ACTIONS = "COMPARE_FILTER_ACTIONS";
    public static final String COMPARE_FILTERS_INITIALIZING = "COMPARE_FILTERS_INITIALIZING";
    private CompareConfiguration fCompareConfiguration;
    private ResourceBundle fBundle;
    private String fPrefix = "filter.";
    private CompareFilterDescriptor fCompareFilterDescriptor;
    private ICompareFilter fCompareFilter;

    public ChangeCompareFilterPropertyAction(CompareFilterDescriptor compareFilterDescriptor, CompareConfiguration compareConfiguration) {
        this.fBundle = compareFilterDescriptor.getResourceBundle();
        this.fCompareFilterDescriptor = compareFilterDescriptor;
        this.fCompareFilter = compareFilterDescriptor.createCompareFilter();
        Utilities.initAction((IAction)this, this.fBundle, this.fPrefix);
        this.setImageDescriptor(compareFilterDescriptor.getImageDescriptor());
        this.setId(compareFilterDescriptor.getFilterId());
        this.setActionDefinitionId(compareFilterDescriptor.getDefinitionId());
        this.setCompareConfiguration(compareConfiguration);
        if (this.fCompareFilter.isEnabledInitially()) {
            this.setChecked(true);
            this.setProperty(true);
        }
    }

    void setProperty(boolean state) {
        if (this.fCompareConfiguration != null) {
            HashMap<String, ICompareFilter> filters = new HashMap<String, ICompareFilter>();
            if (this.fCompareConfiguration.getProperty(COMPARE_FILTERS) != null) {
                filters.putAll((Map)this.fCompareConfiguration.getProperty(COMPARE_FILTERS));
            }
            if (state) {
                filters.put(this.fCompareFilterDescriptor.getFilterId(), this.fCompareFilter);
            } else {
                filters.remove(this.fCompareFilterDescriptor.getFilterId());
            }
            this.fCompareConfiguration.setProperty(COMPARE_FILTERS, filters);
        }
    }

    boolean getProperty() {
        HashMap filters = (HashMap)this.fCompareConfiguration.getProperty(COMPARE_FILTERS);
        if (filters == null) {
            filters = new HashMap();
        }
        return filters.containsKey(this.fCompareFilterDescriptor.getFilterId());
    }

    public void run() {
        boolean b = !this.getProperty();
        this.setChecked(b);
        this.setProperty(b);
    }

    public void setChecked(boolean state) {
        super.setChecked(state);
        Utilities.initToggleAction((IAction)this, this.fBundle, this.fPrefix, state);
    }

    public void setCompareConfiguration(CompareConfiguration cc) {
        if (this.fCompareConfiguration != null) {
            this.fCompareConfiguration.removePropertyChangeListener(this);
        }
        this.fCompareConfiguration = cc;
        if (this.fCompareConfiguration != null) {
            this.fCompareConfiguration.addPropertyChangeListener(this);
        }
        this.setChecked(this.getProperty());
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(COMPARE_FILTERS) && event.getNewValue() instanceof Map) {
            this.setChecked(((Map)event.getNewValue()).containsKey(this.fCompareFilterDescriptor.getFilterId()));
        }
    }

    public void dispose() {
        if (this.fCompareConfiguration != null) {
            this.fCompareConfiguration.removePropertyChangeListener(this);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public String getFilterId() {
        return this.fCompareFilterDescriptor.getFilterId();
    }

    public void setInput(Object input, Object ancestor, Object left, Object right) {
        this.fCompareFilter.setInput(input, ancestor, left, right);
    }
}

