/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.EnumSet;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class ResolutionBasedComputationResult
implements ITypeComputationResult {
    private final XExpression expression;
    private final ResolvedTypes resolution;

    public ResolutionBasedComputationResult(XExpression expression, ResolvedTypes resolution) {
        this.expression = expression;
        this.resolution = resolution;
    }

    @Override
    public LightweightTypeReference getActualExpressionType() {
        return this.resolution.getActualType(this.expression);
    }

    @Override
    public LightweightTypeReference getReturnType() {
        return this.resolution.getReturnType(this.expression);
    }

    @Override
    public XExpression getExpression() {
        return this.expression;
    }

    @Override
    public LightweightTypeReference getExpectedExpressionType() {
        return this.resolution.getExpectedType(this.expression);
    }

    @Override
    public LightweightTypeReference getExpectedReturnType() {
        return this.resolution.getExpectedReturnType(this.expression);
    }

    @Override
    public EnumSet<ConformanceHint> getConformanceHints() {
        return ConformanceHint.fromFlags(this.getConformanceFlags());
    }

    @Override
    public int getConformanceFlags() {
        TypeData typeData = this.resolution.getTypeData(this.expression, false);
        if (typeData == null) {
            return 0;
        }
        return typeData.getConformanceFlags();
    }

    @Override
    public EnumSet<ConformanceHint> getCheckedConformanceHints() {
        return ConformanceHint.fromFlags(this.getCheckedConformanceFlags());
    }

    @Override
    public int getCheckedConformanceFlags() {
        TypeData typeData = this.resolution.getTypeData(this.expression, false);
        if (typeData == null) {
            return 0;
        }
        return this.resolution.getConformanceFlags(typeData, false);
    }

    public String toString() {
        return String.format("Result %s for %s", this.getActualExpressionType(), this.expression);
    }
}

