/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifest;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ConvertProjectToPluginOperation
extends WorkspaceModifyOperation {
    private IProject[] projectsToConvert;
    private boolean enableApiAnalysis;
    private String fLibraryName;
    private String[] fSrcEntries;
    private String[] fLibEntries;
    private static final String NO_EXECUTION_ENVIRONMENT = PDEUIMessages.PluginContentPage_noEE;

    public ConvertProjectToPluginOperation(IProject[] theProjectsToConvert, boolean enableApiAnalysis) {
        this.projectsToConvert = theProjectsToConvert;
        this.enableApiAnalysis = enableApiAnalysis;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask(PDEUIMessages.ConvertedProjectWizard_converting, this.projectsToConvert.length);
                IProject[] iProjectArray = this.projectsToConvert;
                int n = this.projectsToConvert.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject projectToConvert = iProjectArray[n2];
                    this.convertProject(projectToConvert, monitor);
                    monitor.worked(1);
                    ++n2;
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void convertProject(IProject projectToConvert, IProgressMonitor monitor) throws CoreException {
        if (projectToConvert == null || !projectToConvert.exists()) {
            return;
        }
        if (projectToConvert.hasNature("org.eclipse.pde.PluginNature")) {
            return;
        }
        CoreUtility.addNatureToProject((IProject)projectToConvert, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)monitor);
        if (this.enableApiAnalysis) {
            if (!projectToConvert.hasNature("org.eclipse.jdt.core.javanature")) {
                CoreUtility.addNatureToProject((IProject)projectToConvert, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
            }
            CoreUtility.addNatureToProject((IProject)projectToConvert, (String)"org.eclipse.pde.api.tools.apiAnalysisNature", (IProgressMonitor)monitor);
        }
        this.loadClasspathEntries(projectToConvert, monitor);
        this.loadLibraryName(projectToConvert);
        this.createManifestFile(PDEProject.getManifest((IProject)projectToConvert), monitor);
        IFile buildFile = PDEProject.getBuildProperties((IProject)projectToConvert);
        if (!buildFile.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(buildFile);
            IBuild build = model.getBuild(true);
            IBuildEntry entry = model.getFactory().createEntry("bin.includes");
            if (PDEProject.getPluginXml((IProject)projectToConvert).exists()) {
                entry.addToken("plugin.xml");
            }
            if (PDEProject.getManifest((IProject)projectToConvert).exists()) {
                entry.addToken("META-INF/");
            }
            String[] stringArray = this.fLibEntries;
            int n = this.fLibEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String libEntry = stringArray[n2];
                entry.addToken(libEntry);
                ++n2;
            }
            if (this.fSrcEntries.length > 0) {
                entry.addToken(this.fLibraryName);
                IBuildEntry source = model.getFactory().createEntry("source." + this.fLibraryName);
                String[] stringArray2 = this.fSrcEntries;
                int n3 = this.fSrcEntries.length;
                n = 0;
                while (n < n3) {
                    String srcEntry = stringArray2[n];
                    source.addToken(srcEntry);
                    ++n;
                }
                build.add(source);
            }
            if (entry.getTokens().length > 0) {
                build.add(entry);
            }
            model.save();
        }
    }

    private void loadClasspathEntries(IProject project, IProgressMonitor monitor) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] currentClassPath = new IClasspathEntry[]{};
        ArrayList<String> sources = new ArrayList<String>();
        ArrayList<String> libraries = new ArrayList<String>();
        try {
            currentClassPath = javaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {}
        IClasspathEntry[] iClasspathEntryArray = currentClassPath;
        int n = currentClassPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry element = iClasspathEntryArray[n2];
            int contentType = element.getEntryKind();
            if (contentType == 3) {
                String relativePath = this.getRelativePath(element, project);
                if (relativePath.equals("")) {
                    sources.add(".");
                } else {
                    sources.add(String.valueOf(relativePath) + "/");
                }
            } else if (contentType == 1) {
                String path = this.getRelativePath(element, project);
                if (path.length() > 0) {
                    libraries.add(path);
                } else {
                    libraries.add(".");
                }
            }
            ++n2;
        }
        this.fSrcEntries = sources.toArray(new String[sources.size()]);
        this.fLibEntries = libraries.toArray(new String[libraries.size()]);
        IClasspathEntry[] classPath = new IClasspathEntry[currentClassPath.length + 1];
        System.arraycopy(currentClassPath, 0, classPath, 0, currentClassPath.length);
        classPath[classPath.length - 1] = ClasspathComputer.createContainerEntry();
        try {
            javaProject.setRawClasspath(classPath, monitor);
        }
        catch (JavaModelException javaModelException) {}
    }

    private String getRelativePath(IClasspathEntry cpe, IProject project) {
        IPath path = project.getFile(cpe.getPath()).getProjectRelativePath();
        return path.removeFirstSegments(1).toString();
    }

    private void loadLibraryName(IProject project) {
        if (this.isOldTarget() || this.fLibEntries.length > 0 && this.fSrcEntries.length > 0) {
            String libName = project.getName();
            int i = libName.lastIndexOf(".");
            if (i != -1) {
                libName = libName.substring(i + 1);
            }
            this.fLibraryName = String.valueOf(libName) + ".jar";
        } else {
            this.fLibraryName = ".";
        }
    }

    private void organizeExports(final IProject project) {
        PDEModelUtility.modifyModel(new ModelModification(PDEProject.getManifest((IProject)project)){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (!(model instanceof IBundlePluginModelBase)) {
                    return;
                }
                OrganizeManifest.organizeExportPackages(((IBundlePluginModelBase)model).getBundleModel().getBundle(), project, true, true);
            }
        }, null);
    }

    private String createInitialName(String id) {
        int loc = id.lastIndexOf(46);
        if (loc == -1) {
            return id;
        }
        StringBuilder buf = new StringBuilder(id.substring(loc + 1));
        buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
        return buf.toString();
    }

    private void createManifestFile(IFile file, IProgressMonitor monitor) throws CoreException {
        boolean missingInfo;
        WorkspaceBundlePluginModel model = new WorkspaceBundlePluginModel(file, null);
        model.load();
        IBundle pluginBundle = model.getBundleModel().getBundle();
        String pluginId = pluginBundle.getHeader("Bundle-SymbolicName");
        String pluginName = pluginBundle.getHeader("Bundle-Name");
        String pluginVersion = pluginBundle.getHeader("Bundle-Version");
        boolean bl = missingInfo = pluginId == null || pluginName == null || pluginVersion == null;
        if (pluginId == null) {
            pluginId = IdUtil.getValidId((String)file.getProject().getName());
        }
        if (pluginVersion == null) {
            pluginVersion = "1.0.0.qualifier";
        }
        if (pluginName == null) {
            pluginName = this.createInitialName(pluginId);
        }
        pluginBundle.setHeader("Bundle-SymbolicName", pluginId);
        pluginBundle.setHeader("Bundle-Version", pluginVersion);
        pluginBundle.setHeader("Bundle-Name", pluginName);
        IJavaProject jp = JavaCore.create((IProject)file.getProject());
        IModuleDescription moduleDescription = null;
        if (jp != null) {
            try {
                moduleDescription = jp.getModuleDescription();
            }
            catch (JavaModelException javaModelException) {}
        }
        if (moduleDescription == null) {
            pluginBundle.setHeader("Automatic-Module-Name", NewProjectCreationOperation.determineAutomaticModuleNameFromBSN(pluginId));
        }
        IExecutionEnvironment[] exeEnvs = VMUtil.getExecutionEnvironments();
        IExecutionEnvironment ee = null;
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        int i = 0;
        while (i < exeEnvs.length) {
            if (!exeEnvs[i].getId().equals(NO_EXECUTION_ENVIRONMENT) && VMUtil.getExecutionEnvironment((String)exeEnvs[i].getId()).isStrictlyCompatible(defaultVM)) {
                ee = exeEnvs[i];
                break;
            }
            ++i;
        }
        if (ee == null) {
            i = exeEnvs.length - 1;
            while (i >= 0) {
                List<IVMInstall> vmList;
                IVMInstall[] vm;
                if (!exeEnvs[i].getId().equals(NO_EXECUTION_ENVIRONMENT) && (vm = VMUtil.getExecutionEnvironment((String)exeEnvs[i].getId()).getCompatibleVMs()) != null && vm.length != 0 && (vmList = Arrays.asList(vm)).contains(defaultVM)) {
                    ee = exeEnvs[i];
                    break;
                }
                --i;
            }
        }
        if (ee != null) {
            pluginBundle.setHeader("Bundle-RequiredExecutionEnvironment", ee.getId());
        }
        if (missingInfo) {
            IPluginModelFactory factory = model.getPluginFactory();
            IPluginBase base = model.getPluginBase();
            if (this.fLibraryName != null && !this.fLibraryName.equals(".")) {
                IPluginLibrary library = factory.createLibrary();
                library.setName(this.fLibraryName);
                library.setExported(true);
                base.add(library);
            }
            String[] stringArray = this.fLibEntries;
            int n = this.fLibEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String libEntry = stringArray[n2];
                IPluginLibrary library = factory.createLibrary();
                library.setName(libEntry);
                library.setExported(true);
                base.add(library);
                ++n2;
            }
            if (TargetPlatformHelper.getTargetVersion() >= 3.1) {
                pluginBundle.setHeader("Bundle-ManifestVersion", "2");
            }
        }
        model.save();
        monitor.done();
        this.organizeExports(file.getProject());
    }

    private boolean isOldTarget() {
        return TargetPlatformHelper.getTargetVersion() < 3.1;
    }
}

