/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RefactoringSearchEngine2 {
    public static final int GRANULARITY_COMPILATION_UNIT = 2;
    public static final int GRANULARITY_SEARCH_MATCH = 1;
    private boolean fBinary = false;
    private RefactoringSearchCollector fCollector = null;
    private int fGranularity = 1;
    private boolean fGrouping = true;
    private boolean fInaccurate = true;
    private WorkingCopyOwner fOwner = null;
    private SearchPattern fPattern = null;
    private IRefactoringSearchRequestor fRequestor = new DefaultSearchRequestor();
    private IJavaSearchScope fScope = SearchEngine.createWorkspaceScope();
    private int fSeverity = 2;
    private RefactoringStatus fStatus = new RefactoringStatus();
    private ICompilationUnit[] fWorkingCopies = new ICompilationUnit[0];

    public RefactoringSearchEngine2() {
    }

    public RefactoringSearchEngine2(SearchPattern pattern) {
        Assert.isNotNull((Object)pattern);
        this.fPattern = pattern;
    }

    public void clearResults() {
        this.getCollector().clearResults();
        this.fStatus = new RefactoringStatus();
    }

    public ICompilationUnit[] getAffectedCompilationUnits() {
        if (this.fGranularity == 2) {
            Collection<?> collection = this.getCollector().getCollectedMatches();
            ICompilationUnit[] units = new ICompilationUnit[collection.size()];
            int index = 0;
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                units[index] = (ICompilationUnit)iterator.next();
                ++index;
            }
            return units;
        }
        SearchResultGroup[] groups = this.getGroupedMatches();
        ICompilationUnit[] units = new ICompilationUnit[groups.length];
        int index = 0;
        while (index < groups.length) {
            units[index] = groups[index].getCompilationUnit();
            ++index;
        }
        return units;
    }

    public Map<IJavaProject, ? extends Set<?>> getAffectedProjects() {
        if (this.fGranularity == 2) {
            HashMap<IJavaProject, HashSet<ICompilationUnit>> map = new HashMap<IJavaProject, HashSet<ICompilationUnit>>();
            ICompilationUnit[] iCompilationUnitArray = this.getAffectedCompilationUnits();
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit unit = iCompilationUnitArray[n2];
                IJavaProject project = unit.getJavaProject();
                if (project != null) {
                    HashSet<ICompilationUnit> set = (HashSet<ICompilationUnit>)map.get(project);
                    if (set == null) {
                        set = new HashSet<ICompilationUnit>();
                        map.put(project, set);
                    }
                    set.add(unit);
                }
                ++n2;
            }
            return map;
        }
        HashMap<IJavaProject, HashSet<SearchResultGroup>> map = new HashMap<IJavaProject, HashSet<SearchResultGroup>>();
        SearchResultGroup[] searchResultGroupArray = this.getGroupedMatches();
        int n = searchResultGroupArray.length;
        int n3 = 0;
        while (n3 < n) {
            IJavaProject project;
            SearchResultGroup group = searchResultGroupArray[n3];
            ICompilationUnit unit = group.getCompilationUnit();
            if (unit != null && (project = unit.getJavaProject()) != null) {
                HashSet<SearchResultGroup> set = (HashSet<SearchResultGroup>)map.get(project);
                if (set == null) {
                    set = new HashSet<SearchResultGroup>();
                    map.put(project, set);
                }
                set.add(group);
            }
            ++n3;
        }
        return map;
    }

    private RefactoringSearchCollector getCollector() {
        if (this.fCollector == null) {
            if (this.fGranularity == 2) {
                this.fCollector = new RefactoringCompilationUnitCollector();
            } else if (this.fGranularity == 1) {
                this.fCollector = new RefactoringSearchMatchCollector();
            } else {
                Assert.isTrue((boolean)false);
            }
        }
        return this.fCollector;
    }

    private SearchResultGroup[] getGroupedMatches() {
        HashMap grouped = new HashMap();
        List matches = null;
        IResource resource2 = null;
        SearchMatch match = null;
        for (Object name : this.getSearchMatches()) {
            match = (SearchMatch)name;
            resource2 = match.getResource();
            if (!grouped.containsKey(resource2)) {
                grouped.put(resource2, new ArrayList(4));
            }
            matches = (List)grouped.get(resource2);
            matches.add(match);
        }
        if (this.fBinary) {
            Collection<IResource> collection = this.getCollector().getBinaryResources();
            Iterator iterator = grouped.keySet().iterator();
            while (iterator.hasNext()) {
                resource2 = (IResource)iterator.next();
                if (!collection.contains(resource2)) continue;
                iterator.remove();
            }
        }
        SearchResultGroup[] result = new SearchResultGroup[grouped.size()];
        int index = 0;
        for (IResource resource2 : grouped.keySet()) {
            matches = (List)grouped.get(resource2);
            result[index++] = new SearchResultGroup(resource2, matches.toArray(new SearchMatch[matches.size()]));
        }
        return result;
    }

    public SearchPattern getPattern() {
        return this.fPattern;
    }

    public Object[] getResults() {
        if (this.fGranularity == 2) {
            return this.getAffectedCompilationUnits();
        }
        if (this.fGrouping) {
            return this.getGroupedMatches();
        }
        return this.getUngroupedMatches();
    }

    private Collection<?> getSearchMatches() {
        Collection<?> results = null;
        if (this.fInaccurate) {
            results = new LinkedList(this.getCollector().getCollectedMatches());
            Collection<SearchMatch> collection = this.getCollector().getInaccurateMatches();
            SearchMatch match = null;
            Iterator<?> iterator = results.iterator();
            while (iterator.hasNext()) {
                match = (SearchMatch)iterator.next();
                if (!collection.contains(match)) continue;
                iterator.remove();
            }
        } else {
            results = this.getCollector().getCollectedMatches();
        }
        return results;
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    private SearchMatch[] getUngroupedMatches() {
        Collection<?> results = null;
        if (this.fBinary) {
            results = new LinkedList(this.getSearchMatches());
            Collection<IResource> collection = this.getCollector().getBinaryResources();
            SearchMatch match = null;
            Iterator<?> iterator = results.iterator();
            while (iterator.hasNext()) {
                match = (SearchMatch)iterator.next();
                if (!collection.contains(match.getResource())) continue;
                iterator.remove();
            }
        } else {
            results = this.getSearchMatches();
        }
        SearchMatch[] matches = new SearchMatch[results.size()];
        results.toArray(matches);
        return matches;
    }

    public void searchPattern(IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)this.fPattern);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_occurrences);
            try {
                SearchEngine engine = null;
                engine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine(this.fWorkingCopies);
                engine.search(this.fPattern, SearchUtils.getDefaultSearchParticipants(), this.fScope, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
            catch (CoreException exception) {
                throw new JavaModelException(exception);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void searchReferencedFields(IJavaElement element, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)element);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_referenced_fields);
            try {
                SearchEngine engine = null;
                engine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine(this.fWorkingCopies);
                engine.searchDeclarationsOfAccessedFields(element, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
            catch (CoreException exception) {
                throw new JavaModelException(exception);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void searchReferencedMethods(IJavaElement element, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)element);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_referenced_methods);
            try {
                SearchEngine engine = null;
                engine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine(this.fWorkingCopies);
                engine.searchDeclarationsOfSentMessages(element, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
            catch (CoreException exception) {
                throw new JavaModelException(exception);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void searchReferencedTypes(IJavaElement element, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)element);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_referenced_types);
            try {
                SearchEngine engine = null;
                engine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine(this.fWorkingCopies);
                engine.searchDeclarationsOfReferencedTypes(element, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
            catch (CoreException exception) {
                throw new JavaModelException(exception);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void setFiltering(boolean inaccurate, boolean binary) {
        this.fInaccurate = inaccurate;
        this.fBinary = binary;
    }

    public void setGranularity(int granularity) {
        Assert.isTrue((granularity == 2 || granularity == 1 ? 1 : 0) != 0);
        this.fGranularity = granularity;
    }

    public void setWorkingCopies(ICompilationUnit[] copies) {
        Assert.isNotNull((Object)copies);
        this.fWorkingCopies = new ICompilationUnit[copies.length];
        System.arraycopy(copies, 0, this.fWorkingCopies, 0, copies.length);
    }

    public void setGrouping(boolean grouping) {
        this.fGrouping = grouping;
    }

    public void setOrPattern(SearchPattern first, SearchPattern second) {
        Assert.isNotNull((Object)first);
        Assert.isNotNull((Object)second);
        this.fPattern = SearchPattern.createOrPattern((SearchPattern)first, (SearchPattern)second);
    }

    public void setOwner(WorkingCopyOwner owner) {
        this.fOwner = owner;
    }

    public void setPattern(IJavaElement[] elements, int limitTo) {
        Assert.isNotNull((Object)elements);
        Assert.isTrue((elements.length > 0 ? 1 : 0) != 0);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)elements[0], (int)limitTo, (int)24);
        IJavaElement element = null;
        int index = 1;
        while (index < elements.length) {
            element = elements[index];
            pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)SearchPattern.createPattern((IJavaElement)element, (int)limitTo, (int)24));
            ++index;
        }
        this.setPattern(pattern);
    }

    public void setPattern(SearchPattern pattern) {
        Assert.isNotNull((Object)pattern);
        this.fPattern = pattern;
    }

    public void setRequestor(IRefactoringSearchRequestor requestor) {
        Assert.isNotNull((Object)requestor);
        this.fRequestor = requestor;
    }

    public void setScope(IJavaSearchScope scope) {
        Assert.isNotNull((Object)scope);
        this.fScope = scope;
    }

    public void setSeverity(int severity) {
        Assert.isTrue((severity == 2 || severity == 1 || severity == 4 || severity == 3 ? 1 : 0) != 0);
        this.fSeverity = severity;
    }

    public void setStatus(RefactoringStatus status) {
        Assert.isNotNull((Object)status);
        this.fStatus = status;
    }

    private static class DefaultSearchRequestor
    implements IRefactoringSearchRequestor {
        private DefaultSearchRequestor() {
        }

        @Override
        public final SearchMatch acceptSearchMatch(SearchMatch match) {
            return match;
        }
    }

    private class RefactoringCompilationUnitCollector
    extends RefactoringSearchCollector {
        private final Set<ICompilationUnit> fCollectedUnits = new HashSet<ICompilationUnit>();
        private final Set<SearchMatch> fInaccurateMatches = new HashSet<SearchMatch>();

        private RefactoringCompilationUnitCollector() {
        }

        public final void acceptSearchMatch(SearchMatch match) throws CoreException {
            SearchMatch accepted = RefactoringSearchEngine2.this.fRequestor.acceptSearchMatch(match);
            if (accepted != null) {
                IJavaElement element;
                IResource resource = accepted.getResource();
                if (!resource.equals((Object)this.fLastResource) && (element = JavaCore.create((IResource)resource)) instanceof ICompilationUnit) {
                    this.fCollectedUnits.add((ICompilationUnit)element);
                }
                if (RefactoringSearchEngine2.this.fInaccurate && accepted.getAccuracy() == 1 && !this.fInaccurateMatches.contains(accepted)) {
                    RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_inaccurate_match, BasicElementLabels.getResourceName(accepted.getResource())), null, null, -1);
                    this.fInaccurateMatches.add(accepted);
                }
            }
        }

        @Override
        public final void clearResults() {
            super.clearResults();
            this.fCollectedUnits.clear();
            this.fInaccurateMatches.clear();
        }

        @Override
        public final Collection<IResource> getBinaryResources() {
            return Collections.emptySet();
        }

        public final Collection<ICompilationUnit> getCollectedMatches() {
            return this.fCollectedUnits;
        }

        @Override
        public final Collection<SearchMatch> getInaccurateMatches() {
            return this.fInaccurateMatches;
        }
    }

    private static abstract class RefactoringSearchCollector
    extends SearchRequestor {
        protected IResource fLastResource = null;

        private RefactoringSearchCollector() {
        }

        public void clearResults() {
            this.fLastResource = null;
        }

        public abstract Collection<IResource> getBinaryResources();

        public abstract Collection<?> getCollectedMatches();

        public abstract Collection<SearchMatch> getInaccurateMatches();
    }

    private class RefactoringSearchMatchCollector
    extends RefactoringSearchCollector {
        private final Set<IResource> fBinaryResources = new HashSet<IResource>();
        private final List<SearchMatch> fCollectedMatches = new ArrayList<SearchMatch>();
        private final Set<SearchMatch> fInaccurateMatches = new HashSet<SearchMatch>();

        private RefactoringSearchMatchCollector() {
        }

        public final void acceptSearchMatch(SearchMatch match) throws CoreException {
            SearchMatch accepted = RefactoringSearchEngine2.this.fRequestor.acceptSearchMatch(match);
            if (accepted != null) {
                this.fCollectedMatches.add(accepted);
                IResource resource = accepted.getResource();
                if (!resource.equals((Object)this.fLastResource)) {
                    IJavaElement element;
                    if (RefactoringSearchEngine2.this.fBinary && !((element = JavaCore.create((IResource)resource)) instanceof ICompilationUnit)) {
                        IProject project = resource.getProject();
                        if (!RefactoringSearchEngine2.this.fGrouping) {
                            RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_binary_match_ungrouped, BasicElementLabels.getResourceName((IResource)project)), null, null, -1);
                        } else if (!this.fBinaryResources.contains(resource)) {
                            RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_binary_match_grouped, BasicElementLabels.getResourceName((IResource)project)), null, null, -1);
                        }
                        this.fBinaryResources.add(resource);
                    }
                    if (RefactoringSearchEngine2.this.fInaccurate && accepted.getAccuracy() == 1 && !this.fInaccurateMatches.contains(accepted)) {
                        RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_inaccurate_match, BasicElementLabels.getResourceName(resource)), null, null, -1);
                        this.fInaccurateMatches.add(accepted);
                    }
                }
            }
        }

        @Override
        public final void clearResults() {
            super.clearResults();
            this.fCollectedMatches.clear();
            this.fInaccurateMatches.clear();
            this.fBinaryResources.clear();
        }

        @Override
        public final Collection<IResource> getBinaryResources() {
            return this.fBinaryResources;
        }

        public final Collection<SearchMatch> getCollectedMatches() {
            return this.fCollectedMatches;
        }

        @Override
        public final Collection<SearchMatch> getInaccurateMatches() {
            return this.fInaccurateMatches;
        }
    }
}

