/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.constraints;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitoringContext;
import org.eclipse.comma.monitoring.lib.constraints.CConstraintValue;
import org.eclipse.comma.monitoring.lib.constraints.CDataRule;
import org.eclipse.comma.monitoring.lib.constraints.CGenericRule;
import org.eclipse.comma.monitoring.lib.constraints.CRule;
import org.eclipse.comma.monitoring.lib.constraints.CRuleError;
import org.eclipse.comma.monitoring.lib.constraints.CTimeRule;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CRulesExecutor
implements Serializable {
    private List<CRule> listOfRules;
    private List<CRule> listOfActivatedRules = new ArrayList<CRule>();
    private CInterfaceMonitoringContext context;

    public CRulesExecutor(CInterfaceMonitoringContext monitoringContext) {
        this.listOfRules = new ArrayList<CRule>();
        this.context = monitoringContext;
    }

    public void setListOfRules(List<CRule> rules) {
        this.listOfRules = rules;
    }

    public List<CRuleError> consumeEvent(CObservedMessage message) {
        ArrayList<CRuleError> errors = new ArrayList<CRuleError>();
        if (!(this.listOfRules.isEmpty() || this.context.dataConstraintsSkipped() && this.context.timeConstraintsSkipped())) {
            CConstraintValue ruleResult;
            ArrayList<CRule> newlyActivatedRules = new ArrayList<CRule>();
            for (CRule rule : this.listOfRules) {
                if (!(!this.context.dataConstraintsSkipped() && rule instanceof CDataRule || !this.context.timeConstraintsSkipped() && rule instanceof CTimeRule) && !(rule instanceof CGenericRule)) continue;
                ruleResult = (rule = rule.deepCopy()).consume(message);
                if (ruleResult == CConstraintValue.UNKNOWN) {
                    newlyActivatedRules.add(rule);
                }
                if (ruleResult != CConstraintValue.FALSE) continue;
                errors.add(rule.getError());
            }
            for (CRule rule : this.listOfActivatedRules) {
                ruleResult = rule.consume(message);
                if (ruleResult == CConstraintValue.FALSE) {
                    errors.add(rule.getError());
                }
                if (ruleResult != CConstraintValue.UNKNOWN) continue;
                newlyActivatedRules.add(rule);
            }
            this.listOfActivatedRules = newlyActivatedRules;
        }
        return errors;
    }
}

