/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.actions.actions.ActionsPackage;
import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.behavior.BehaviorPackage;
import org.eclipse.comma.behavior.behavior.DataConstraint;
import org.eclipse.comma.behavior.behavior.DataConstraintEvent;
import org.eclipse.comma.behavior.behavior.DataConstraintStep;
import org.eclipse.comma.behavior.behavior.DataConstraintsBlock;
import org.eclipse.comma.behavior.validation.EventsValidator;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionPackage;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class DataConstraintsValidator
extends EventsValidator {
    @Check
    public void checkDuplicatesInDataConstraints(DataConstraintsBlock dcBlock) {
        this.checkForNameDuplications((Iterable)dcBlock.getDataConstraints(), "data constraint", null, new String[0]);
        this.checkForNameDuplications((Iterable)dcBlock.getVars(), "variable", null, new String[0]);
    }

    @Check
    public void checkDataConstraint(DataConstraint dc) {
        final HashSet boundVars = new HashSet();
        EList<DataConstraintStep> _steps = dc.getSteps();
        for (DataConstraintStep step : _steps) {
            Consumer<ExpressionVariable> _function = new Consumer<ExpressionVariable>(){

                @Override
                public void accept(ExpressionVariable it) {
                    boolean _tripleNotEquals;
                    Variable _variable = it.getVariable();
                    boolean bl = _tripleNotEquals = _variable != null;
                    if (_tripleNotEquals) {
                        boolean _not;
                        boolean _add = boundVars.add(it.getVariable());
                        boolean bl2 = _not = !_add;
                        if (_not) {
                            DataConstraintsValidator.this.error("The variable is already bound to a value.", (EObject)it, (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_VARIABLE__VARIABLE);
                        }
                    }
                }
            };
            EcoreUtil2.getAllContentsOfType((EObject)step, ExpressionVariable.class).forEach(_function);
        }
        Functions.Function1<ExpressionVariable, Boolean> _function_1 = new Functions.Function1<ExpressionVariable, Boolean>(){

            public Boolean apply(ExpressionVariable it) {
                return it.getVariable() != null && it.getVariable().eContainer() instanceof DataConstraintsBlock;
            }
        };
        Consumer<ExpressionVariable> _function_2 = new Consumer<ExpressionVariable>(){

            @Override
            public void accept(ExpressionVariable it) {
                boolean _not;
                boolean _contains = boundVars.contains(it.getVariable());
                boolean bl = _not = !_contains;
                if (_not) {
                    DataConstraintsValidator.this.error("The variable is not previously bound to a value.", (EObject)it, (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_VARIABLE__VARIABLE);
                }
            }
        };
        IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)dc.getCondition(), ExpressionVariable.class), (Functions.Function1)_function_1).forEach(_function_2);
    }

    @Check
    public void checkUnusedVariables(DataConstraintsBlock dcb) {
        Functions.Function1<ExpressionVariable, Variable> _function = new Functions.Function1<ExpressionVariable, Variable>(){

            public Variable apply(ExpressionVariable it) {
                return it.getVariable();
            }
        };
        Functions.Function1<Variable, Boolean> _function_1 = new Functions.Function1<Variable, Boolean>(){

            public Boolean apply(Variable it) {
                return it != null && it.eContainer() instanceof DataConstraintsBlock;
            }
        };
        Set usedVars = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)EcoreUtil2.getAllContentsOfType((EObject)dcb, ExpressionVariable.class), (Functions.Function1)_function), (Functions.Function1)_function_1));
        EList _vars = dcb.getVars();
        for (Variable v : _vars) {
            boolean _not;
            boolean _contains = usedVars.contains(v);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            this.warning("Variable not used.", (EStructuralFeature)ActionsPackage.Literals.VARIABLE_DECL_BLOCK__VARS, dcb.getVars().indexOf((Object)v));
        }
    }

    @Check
    public void checkConditionType(DataConstraint dc) {
        boolean _tripleNotEquals;
        Expression _condition = dc.getCondition();
        boolean bl = _tripleNotEquals = _condition != null;
        if (_tripleNotEquals) {
            boolean _not;
            boolean _identical = this.identical(this.typeOf(dc.getCondition()), (TypeObject)this.boolType);
            boolean bl2 = _not = !_identical;
            if (_not) {
                this.error("Condition has to be of boolean type.", (EStructuralFeature)BehaviorPackage.Literals.DATA_CONSTRAINT__CONDITION);
            }
        }
    }

    @Check
    public void checkWhereConditionVariables(DataConstraint dc) {
        Functions.Function1<ExpressionVariable, Boolean> _function = new Functions.Function1<ExpressionVariable, Boolean>(){

            public Boolean apply(ExpressionVariable it) {
                return it.getVariable() != null && it.getVariable().eContainer() instanceof AbstractBehavior;
            }
        };
        Iterable interfaceVars = IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)dc.getCondition(), ExpressionVariable.class), (Functions.Function1)_function);
        for (ExpressionVariable v : interfaceVars) {
            this.error("Interface variables not allowed.", (EObject)v, (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_VARIABLE__VARIABLE);
        }
    }

    @Check
    public void checkVarsInNegation(DataConstraintEvent e) {
        boolean _equals = e.getNegated().equals("no");
        if (_equals) {
            List _allContentsOfType = EcoreUtil2.getAllContentsOfType((EObject)e, ExpressionVariable.class);
            for (ExpressionVariable v : _allContentsOfType) {
                this.error("Variables cannot be used in negated events.", (EObject)v, (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_VARIABLE__VARIABLE);
            }
        }
    }
}

