/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.registry.internal;

import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.equinox.http.registry.internal.HttpServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    private ServiceTracker httpServiceTracker;
    private ServiceTracker packageAdminTracker;
    private ServiceTracker registryTracker;
    private PackageAdmin packageAdmin;
    private IExtensionRegistry registry;
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.packageAdminTracker = new ServiceTracker(context, PackageAdmin.class, (ServiceTrackerCustomizer)this);
        this.packageAdminTracker.open();
        this.registryTracker = new ServiceTracker(context, IExtensionRegistry.class, (ServiceTrackerCustomizer)this);
        this.registryTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.packageAdminTracker.close();
        this.packageAdminTracker = null;
        this.registryTracker.close();
        this.registryTracker = null;
        this.context = null;
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        if (service instanceof PackageAdmin && this.packageAdmin == null) {
            this.packageAdmin = (PackageAdmin)service;
        }
        if (service instanceof IExtensionRegistry && this.registry == null) {
            this.registry = (IExtensionRegistry)service;
        }
        if (this.packageAdmin != null && this.registry != null) {
            this.httpServiceTracker = new HttpServiceTracker(this.context, this.packageAdmin, this.registry);
            this.httpServiceTracker.open();
        }
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service == this.packageAdmin) {
            this.packageAdmin = null;
        }
        if (service == this.registry) {
            this.registry = null;
        }
        if ((this.packageAdmin == null || this.registry == null) && this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        this.context.ungetService(reference);
    }
}

