/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.AbstractOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.EStructuralFeatureNode;
import org.eclipse.xtext.ui.editor.outline.impl.IOutlineTreeStructureProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OutlineNodeFactory {
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    public IOutlineNode createRoot(IXtextDocument document, ImageDescriptor imageDescriptor, Object text, IOutlineTreeStructureProvider provider) {
        DocumentRootNode documentNode = new DocumentRootNode(imageDescriptor, text, document, provider);
        documentNode.setTextRegion((ITextRegion)new TextRegion(0, document.getLength()));
        return documentNode;
    }

    public EStructuralFeatureNode createEStructuralFeatureNode(IOutlineNode parentNode, EObject owner, EStructuralFeature feature, ImageDescriptor imageDescriptor, Object text, boolean isLeaf) {
        boolean isFeatureSet = owner.eIsSet(feature);
        EStructuralFeatureNode eStructuralFeatureNode = new EStructuralFeatureNode(owner, feature, parentNode, imageDescriptor, text, isLeaf || !isFeatureSet);
        if (isFeatureSet) {
            int numValues;
            ITextRegion fullTextRegion;
            ITextRegion region = this.locationInFileProvider.getFullTextRegion(owner, feature, 0);
            if (feature.isMany() && (fullTextRegion = this.locationInFileProvider.getFullTextRegion(owner, feature, (numValues = ((Collection)owner.eGet(feature)).size()) - 1)) != null) {
                region = region.merge(fullTextRegion);
            }
            eStructuralFeatureNode.setTextRegion(region);
        }
        return eStructuralFeatureNode;
    }

    public EObjectNode createEObjectNode(IOutlineNode parentNode, EObject modelElement, ImageDescriptor imageDescriptor, Object text, boolean isLeaf) {
        EObjectNode eObjectNode = new EObjectNode(modelElement, parentNode, imageDescriptor, text, isLeaf);
        ICompositeNode parserNode = NodeModelUtils.getNode((EObject)modelElement);
        if (parserNode != null) {
            eObjectNode.setTextRegion(parserNode.getTextRegion());
        }
        if (this.isLocalElement(parentNode, modelElement)) {
            eObjectNode.setShortTextRegion(this.locationInFileProvider.getSignificantTextRegion(modelElement));
        }
        return eObjectNode;
    }

    protected boolean isLocalElement(IOutlineNode node, final EObject element) {
        if (node instanceof AbstractOutlineNode) {
            return (Boolean)((AbstractOutlineNode)node).getDocument().tryReadOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

                public Boolean exec(XtextResource state) throws Exception {
                    if (element.eResource() == state) {
                        return true;
                    }
                    return false;
                }
            }, () -> false);
        }
        return true;
    }

    protected ILocationInFileProvider getLocationInFileProvider() {
        return this.locationInFileProvider;
    }
}

