/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;

public class DirectoryBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "Directory";
    private final String fPath;

    public DirectoryBundleContainer(String path) {
        this.fPath = path;
    }

    @Override
    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            return this.getDirectory().toString();
        }
        return this.fPath;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        File dir = this.getDirectory();
        if (dir.isDirectory()) {
            File site = this.getSite(dir);
            File[] files = site.listFiles();
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DirectoryBundleContainer_0, (int)files.length);
            return (TargetBundle[])((Stream)Arrays.stream(files).parallel()).map(file -> {
                localMonitor.split(1);
                try {
                    return new TargetBundle((File)file);
                }
                catch (CoreException coreException) {
                    return null;
                }
            }).filter(Objects::nonNull).toArray(TargetBundle[]::new);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.DirectoryBundleContainer_1, (Object)dir.toString())));
    }

    @Override
    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        File dir = this.getDirectory();
        if (dir.isDirectory()) {
            File site = this.getFeatureSite(dir);
            File[] files = site.listFiles();
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DirectoryBundleContainer_0, (int)files.length);
            return (TargetFeature[])((Stream)Arrays.stream(files).parallel()).map(file -> {
                localMonitor.split(1);
                try {
                    return new TargetFeature((File)file);
                }
                catch (CoreException coreException) {
                    return null;
                }
            }).filter(Objects::nonNull).toArray(TargetFeature[]::new);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.DirectoryBundleContainer_1, (Object)dir.toString())));
    }

    protected File getDirectory() throws CoreException {
        String path = this.resolveVariables(this.fPath);
        return new File(path);
    }

    public boolean equals(Object o) {
        if (o instanceof DirectoryBundleContainer) {
            DirectoryBundleContainer dbc = (DirectoryBundleContainer)o;
            return this.fPath.equals(dbc.fPath);
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode();
    }

    public String toString() {
        return "Directory " + this.fPath;
    }

    private File getSite(File root) {
        File file = new File(root, "plugins");
        if (file.exists()) {
            return file;
        }
        return root;
    }

    private File getFeatureSite(File root) {
        File file = new File(root, "features");
        if (file.exists()) {
            return file;
        }
        return root;
    }

    public void reload() {
        this.clearResolutionStatus();
    }
}

