/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.OperationScheduler;
import org.eclipse.cft.server.core.internal.client.CFOperation;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.editor.EditorMessageTypes;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class FormMessageHandler {
    private final int MAX_MESSAGE_DISPLAY_SIZE = 100;
    private CloudFoundryServer cloudServer;
    private ScrolledForm form;

    public FormMessageHandler(CloudFoundryServer cloudServer, ScrolledForm form) {
        this.cloudServer = cloudServer;
        this.form = form;
    }

    protected IStatus getStatusFromRunningOperation() {
        if (this.cloudServer != null) {
            CFOperation op;
            OperationScheduler scheduler = this.cloudServer.getBehaviour().getOperationScheduler();
            CFOperation cFOperation = op = scheduler != null ? scheduler.getCurrentOperation() : null;
            if (op != null && op.getOperationName() != null) {
                return CloudFoundryPlugin.getStatus((String)op.getOperationName(), (int)1);
            }
        }
        return null;
    }

    public void setMessage(IStatus status) {
        IStatus opStatus = this.getStatusFromRunningOperation();
        if (opStatus != null) {
            status = opStatus;
        }
        String message = null;
        message = status != null && !Status.OK_STATUS.getMessage().equals(status.getMessage()) ? status.getMessage() : null;
        int messageProviderType = EditorMessageTypes.getMessageProviderType(status);
        if (message == null) {
            this.setMessageInForm(null, messageProviderType);
            return;
        }
        StringBuffer buffer = new StringBuffer(message);
        int i = 0;
        while (i < buffer.length()) {
            char ch = buffer.charAt(i);
            if (ch == '\r' || ch == '\n') {
                buffer.replace(i, i + 1, " ");
            }
            ++i;
        }
        String fullMessage = buffer.toString();
        if (buffer.length() > 100) {
            String endingSegment = Messages.CloudFoundryApplicationsEditorPage_TEXT_SEE_ERRORLOG;
            message = String.valueOf(buffer.substring(0, 100).trim()) + endingSegment;
        } else {
            message = fullMessage;
        }
        this.setMessageInForm(message, messageProviderType);
    }

    protected void setMessageInForm(String message, int messageProviderType) {
        if (this.form != null && !this.form.isDisposed()) {
            this.form.setMessage(message, messageProviderType);
        }
    }
}

