/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.rules.fa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.activity.AbstractAction;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.FunctionalChainAttachmentHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IPremise;

public class FunctionalChainInvolvementRule
extends org.polarsys.capella.core.transition.system.rules.fa.FunctionalChainInvolvementRule {
    public IStatus transformRequired(EObject element_p, IContext context_p) {
        FunctionalChainInvolvement element = (FunctionalChainInvolvement)element_p;
        NamedElement involved = (NamedElement)element.getInvolved();
        IStatus result = TransformationHandlerHelper.getInstance((IContext)context_p).isOrWillBeTransformed((EObject)element.getInvolver(), context_p);
        if (!result.isOK()) {
            return result;
        }
        result = TransformationHandlerHelper.getInstance((IContext)context_p).isOrWillBeTransformed((EObject)involved, context_p);
        FunctionalChainAttachmentHelper helper = FunctionalChainAttachmentHelper.getInstance(context_p);
        if (result.isOK()) {
            if (helper.isValidElement((EObject)element, context_p) != Boolean.TRUE) {
                result = new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Functional Chain Involvement ''{0}'' is not valid.", (Object)LogHelper.getInstance().getText((Object)element_p)));
            }
        } else if (helper.isValidElement((EObject)element, context_p) == Boolean.TRUE) {
            result = Status.OK_STATUS;
        }
        if (result.isOK() && involved instanceof FunctionalExchange) {
            boolean res = true;
            Collection<FunctionalChainInvolvement> nextsValid = helper.getNextValid(element, context_p);
            if (nextsValid.isEmpty()) {
                res = false;
            } else if (!this.FCIsCollectionMatching((Collection<FunctionalChainInvolvement>)element.getNextFunctionalChainInvolvements(), nextsValid)) {
                res = false;
            }
            Collection<FunctionalChainInvolvement> prevsValid = helper.getPreviousValid(element, context_p);
            if (prevsValid.isEmpty()) {
                res = false;
            } else if (!this.FCIsCollectionMatching((Collection<FunctionalChainInvolvement>)element.getPreviousFunctionalChainInvolvements(), prevsValid)) {
                res = false;
            }
            if (!res) {
                result = new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Functional Chain Involvement ''{0}'' is not valid.", (Object)LogHelper.getInstance().getText((Object)element_p)));
            }
        }
        return result;
    }

    private boolean FCIsCollectionMatching(Collection<FunctionalChainInvolvement> fci1, Collection<FunctionalChainInvolvement> fci2) {
        boolean containOne = false;
        for (FunctionalChainInvolvement fci : fci1) {
            for (FunctionalChainInvolvement nextValid : fci2) {
                if (nextValid.getInvolved() == null || !nextValid.getInvolved().equals(fci.getInvolved())) continue;
                containOne = true;
                break;
            }
            if (containOne) break;
        }
        return containOne;
    }

    protected void attachRelated(EObject src, EObject trg, IContext context) {
        super.attachRelated(src, trg, context);
        FunctionalChainAttachmentHelper helper = FunctionalChainAttachmentHelper.getInstance(context);
        FunctionalChainInvolvement fSrc = (FunctionalChainInvolvement)src;
        FunctionalChainInvolvement fTrg = (FunctionalChainInvolvement)trg;
        if (!fSrc.getNextFunctionalChainInvolvements().isEmpty()) {
            for (FunctionalChainInvolvement nextSrcValid : helper.getNextValid(fSrc, context)) {
                Collection nextTrgs;
                if (nextSrcValid instanceof FunctionalChainInvolvementLink && !this.isDirectJump(nextSrcValid, fSrc)) {
                    nextSrcValid = (FunctionalChainInvolvement)nextSrcValid.getNextFunctionalChainInvolvements().get(0);
                }
                if ((nextTrgs = this.retrieveTracedElements((EObject)nextSrcValid, context)) == null || nextTrgs.isEmpty()) continue;
                FunctionalChainInvolvement nextTrgValid = (FunctionalChainInvolvement)nextTrgs.iterator().next();
                if (fSrc.getNextFunctionalChainInvolvements().contains((Object)nextSrcValid)) {
                    if (fSrc instanceof FunctionalChainInvolvementFunction && nextSrcValid instanceof FunctionalChainInvolvementLink) {
                        ((FunctionalChainInvolvementLink)nextTrgValid).setSource((FunctionalChainInvolvementFunction)fTrg);
                        continue;
                    }
                    if (!(fSrc instanceof FunctionalChainInvolvementLink) || !(nextSrcValid instanceof FunctionalChainInvolvementFunction)) continue;
                    ((FunctionalChainInvolvementLink)fTrg).setTarget((FunctionalChainInvolvementFunction)nextTrgValid);
                    continue;
                }
                if (nextSrcValid instanceof FunctionalChainInvolvementLink && fSrc instanceof FunctionalChainInvolvementFunction) {
                    ((FunctionalChainInvolvementLink)nextTrgValid).setSource((FunctionalChainInvolvementFunction)fTrg);
                    continue;
                }
                if (!(fSrc instanceof FunctionalChainInvolvementFunction) || !(nextSrcValid instanceof FunctionalChainInvolvementFunction)) continue;
                Collection<FunctionalChainInvolvement> involvments = this.listInvolvments((FunctionalChainInvolvement)((FunctionalChainInvolvementFunction)fSrc), (FunctionalChainInvolvement)((FunctionalChainInvolvementFunction)nextSrcValid));
                String description = this.buildDescription(involvments);
                Collection nextTrgFcts = this.retrieveTracedElements((EObject)nextSrcValid.getInvolved(), context);
                AbstractFunction nextTrgFct = (AbstractFunction)nextTrgFcts.iterator().next();
                String idDiff = nextTrgFct.getClass().getSimpleName().replaceAll("Function", "").replaceAll("Impl", "");
                FunctionalExchange fakeFE = this.createFakeFE(fTrg, nextTrgFct, context, description, idDiff);
                this.createInvolvements((FunctionalChainInvolvementFunction)fSrc, (FunctionalChainInvolvementFunction)nextSrcValid, context, fakeFE, idDiff);
            }
        }
    }

    private boolean isDirectJump(FunctionalChainInvolvement nextSrcValid, FunctionalChainInvolvement fSrc) {
        for (FunctionalChainInvolvement fci : nextSrcValid.getPreviousFunctionalChainInvolvements()) {
            if (!fSrc.getInvolved().equals(fci.getInvolved())) continue;
            return fSrc.getNextFunctionalChainInvolvements().contains((Object)nextSrcValid);
        }
        return false;
    }

    public Collection<List<FunctionalChainReference>> getPaths(FunctionalChainInvolvement invs) {
        HashMap<FunctionalChainInvolvement, ArrayList> paths = new HashMap<FunctionalChainInvolvement, ArrayList>();
        ArrayList<List<FunctionalChainReference>> result = new ArrayList<List<FunctionalChainReference>>();
        Function<FunctionalChainInvolvement, ArrayList> defaultValue = x -> new ArrayList();
        LinkedList<Object> toVisit = new LinkedList<Object>();
        toVisit.add(invs);
        while (!toVisit.isEmpty()) {
            FunctionalChainInvolvement currentInv = (FunctionalChainInvolvement)toVisit.removeFirst();
            List currentPath = paths.computeIfAbsent(currentInv, defaultValue);
            FunctionalChain chain = (FunctionalChain)currentInv.getInvolver();
            Collection<FunctionalChainReference> referencingRefs = this.getReferencingChainReferences(chain);
            if (!referencingRefs.isEmpty()) {
                for (FunctionalChainReference ref : referencingRefs) {
                    paths.computeIfAbsent((FunctionalChainInvolvement)ref, x -> new ArrayList(currentPath)).add(ref);
                }
                toVisit.addAll(referencingRefs);
                continue;
            }
            result.add(currentPath);
        }
        return result;
    }

    public Collection<FunctionalChainReference> getReferencingChainReferences(FunctionalChain chain) {
        ArrayList<FunctionalChainReference> result = new ArrayList<FunctionalChainReference>();
        for (EObject ref : EObjectExt.getReferencers((EObject)chain, (EReference)CapellacorePackage.Literals.INVOLVEMENT__INVOLVED)) {
            if (!(ref instanceof FunctionalChainReference)) continue;
            result.add((FunctionalChainReference)ref);
        }
        return result;
    }

    private Collection<FunctionalChainInvolvement> listInvolvments(FunctionalChainInvolvement startFci, FunctionalChainInvolvement endFci) {
        ArrayList<FunctionalChainInvolvement> res = new ArrayList<FunctionalChainInvolvement>();
        FunctionalChainInvolvement current = startFci;
        while (!current.getNextFunctionalChainInvolvements().isEmpty()) {
            FunctionalChainInvolvement next = (FunctionalChainInvolvement)current.getNextFunctionalChainInvolvements().get(0);
            if (next.equals(endFci)) break;
            current = next;
            res.add(current);
        }
        return res;
    }

    public ArrayList<EObject> createFullPath(FunctionalChainInvolvementFunction startFci, List<FunctionalChainReference> sourcePath) {
        ArrayList<FunctionalChainReference> fullSourcePath = new ArrayList<FunctionalChainReference>(sourcePath);
        if (sourcePath.isEmpty()) {
            fullSourcePath.add((FunctionalChainReference)startFci.eContainer());
        } else {
            fullSourcePath.add((FunctionalChainReference)sourcePath.get(sourcePath.size() - 1).eContainer());
        }
        return fullSourcePath;
    }

    private void createInvolvements(FunctionalChainInvolvementFunction startFci, FunctionalChainInvolvementFunction endFci, IContext context, FunctionalExchange ex, String id) {
        Collection<List<FunctionalChainReference>> sourcePaths = this.getPaths((FunctionalChainInvolvement)startFci);
        Collection<List<FunctionalChainReference>> targetPaths = this.getPaths((FunctionalChainInvolvement)endFci);
        for (List<FunctionalChainReference> sourcePath : sourcePaths) {
            ArrayList<EObject> fullSourcePath = this.createFullPath(startFci, sourcePath);
            for (List<FunctionalChainReference> targetPath : targetPaths) {
                ArrayList<EObject> fullTargetPath = this.createFullPath(endFci, targetPath);
                ArrayList<EObject> commonParents = new ArrayList<EObject>(fullSourcePath);
                commonParents.retainAll(fullTargetPath);
                this.sort(commonParents, fullSourcePath);
                if (commonParents.isEmpty()) continue;
                EObject firstCommon = (EObject)commonParents.get(0);
                EObject container = firstCommon instanceof FunctionalChainReference ? ((FunctionalChainReference)firstCommon).getInvolved() : firstCommon;
                List<FunctionalChainReference> sHierarchy = firstCommon instanceof FunctionalChainReference ? sourcePath.subList(0, sourcePath.indexOf(firstCommon)) : sourcePath;
                List<FunctionalChainReference> tHierarchy = firstCommon instanceof FunctionalChainReference ? targetPath.subList(0, targetPath.indexOf(firstCommon)) : targetPath;
                this.createFakeFunctionalChainInvolvementLink(startFci, endFci, ex, context, id, (FunctionalChain)container, sHierarchy, tHierarchy);
            }
        }
    }

    private void sort(List<EObject> commonParents, final List<EObject> fullSourcePath) {
        commonParents.sort(new Comparator<EObject>(){

            @Override
            public int compare(EObject o1, EObject o2) {
                return fullSourcePath.indexOf(o1) - fullSourcePath.indexOf(o2);
            }
        });
    }

    private String buildDescription(Collection<FunctionalChainInvolvement> involvedElements) {
        StringBuilder descriptionBuilder = new StringBuilder();
        for (FunctionalChainInvolvement current : involvedElements) {
            NamedElement iv = (NamedElement)current.getInvolved();
            descriptionBuilder.append(String.format("%s(%s);<br/>", iv.getName(), iv.getId()));
        }
        return descriptionBuilder.toString();
    }

    protected void premicesRelated(EObject element_p, ArrayList<IPremise> needed_p) {
        super.premicesRelated(element_p, needed_p);
        if (element_p instanceof FunctionalChainInvolvement) {
            FunctionalChainInvolvement src = (FunctionalChainInvolvement)element_p;
            ArrayList<FunctionalChainInvolvement> nexts = new ArrayList<FunctionalChainInvolvement>();
            while (src.getNextFunctionalChainInvolvements() != null && !src.getNextFunctionalChainInvolvements().isEmpty()) {
                src = (FunctionalChainInvolvement)src.getNextFunctionalChainInvolvements().get(0);
                nexts.add(src);
            }
            needed_p.addAll(this.createDefaultPrecedencePremices(nexts, "nextsInvolvements"));
        }
        if (element_p instanceof FunctionalChainReference) {
            ArrayList fcis = new ArrayList();
            FunctionalChain fc = ((FunctionalChainReference)element_p).getReferencedFunctionalChain();
            fcis.addAll(fc.getOwnedFunctionalChainInvolvements());
            needed_p.addAll(this.createDefaultCriticalPremices(fcis, "referencedInvolvements"));
        }
    }

    private <T extends EObject> T tracedOf(T e, IContext context) {
        Collection values = this.retrieveTracedElements(e, context);
        return (T)((EObject)values.stream().findFirst().orElse(null));
    }

    private <T extends EObject> Collection<T> tracedOf(Collection<T> e, IContext context) {
        return e.stream().map(x -> this.tracedOf(x, context)).collect(Collectors.toList());
    }

    private FunctionalChainInvolvementLink createFakeFunctionalChainInvolvementLink(FunctionalChainInvolvementFunction src, FunctionalChainInvolvementFunction trg, FunctionalExchange fe, IContext context_p, String idPrefix, FunctionalChain parent, Collection<FunctionalChainReference> sH, Collection<FunctionalChainReference> tH) {
        FunctionalChainInvolvementFunction tSrc = this.tracedOf(src, context_p);
        FunctionalChainInvolvementFunction tTgt = this.tracedOf(trg, context_p);
        FunctionalChain tParent = this.tracedOf(parent, context_p);
        Collection<FunctionalChainReference> tsH = this.tracedOf(sH, context_p);
        Collection<FunctionalChainReference> ttH = this.tracedOf(tH, context_p);
        String id = String.format("ID_FakeFunctionalChainInvolvement_%s_%s_%s", idPrefix, tSrc.getSid(), tTgt.getSid());
        if (!sH.isEmpty()) {
            id = String.valueOf(id) + sH.stream().map(x -> x.getSid()).collect(Collectors.joining("_"));
        }
        if (!tH.isEmpty()) {
            id = String.valueOf(id) + tH.stream().map(x -> x.getSid()).collect(Collectors.joining("_"));
        }
        FunctionalChainInvolvementLink res = null;
        for (FunctionalChainInvolvement fci : tSrc.getNextFunctionalChainInvolvements()) {
            if (!(fci instanceof FunctionalChainInvolvementLink) || !fci.getSid().equals(id)) continue;
            res = (FunctionalChainInvolvementLink)fci;
            break;
        }
        for (FunctionalChainInvolvement fci : tTgt.getPreviousFunctionalChainInvolvements()) {
            if (!(fci instanceof FunctionalChainInvolvementLink) || !fci.getSid().equals(id)) continue;
            res = (FunctionalChainInvolvementLink)fci;
            break;
        }
        if (res == null) {
            res = FaFactory.eINSTANCE.createFunctionalChainInvolvementLink();
            res.setSid(id);
            res.getSourceReferenceHierarchy().addAll(tsH);
            res.getTargetReferenceHierarchy().addAll(ttH);
            res.setSource(tSrc);
            res.setTarget(tTgt);
            res.setInvolved((InvolvedElement)fe);
            tParent.getOwnedFunctionalChainInvolvements().add((Object)res);
        }
        return res;
    }

    private FunctionalExchange createFakeFE(FunctionalChainInvolvement srcFci, AbstractFunction targetFunction, IContext context_p, String description, String idPrefix) {
        FunctionalExchange fe = null;
        if (srcFci.getInvolved() instanceof AbstractFunction) {
            AbstractFunction src = (AbstractFunction)srcFci.getInvolved();
            AbstractFunction trg = targetFunction;
            String id = String.format("ID_FakeFunctionalExchange_%s_%s_%s", idPrefix, src.getSid(), trg.getSid());
            String srcPortId = String.format("ID_FakeFunctionPortOut_%s_%s", src.getSid(), id);
            String trgPortId = String.format("ID_FakeFunctionPortIn_%s_%s", trg.getSid(), id);
            EObject container = src.eContainer();
            for (FunctionalExchange existingFE : ((AbstractFunction)container).getOwnedFunctionalExchanges()) {
                if (!existingFE.getSid().equals(id)) continue;
                fe = existingFE;
                break;
            }
            if (fe == null) {
                String feName = String.format("FakeFE_%s_%s", src.getName(), trg.getName());
                String outPortName = "out_" + feName;
                String inPortName = "in_" + feName;
                FunctionOutputPort srcPort = (FunctionOutputPort)this.getOrCreateFakePort(srcPortId, outPortName, (AbstractAction)src, false, context_p);
                FunctionInputPort trgPort = (FunctionInputPort)this.getOrCreateFakePort(trgPortId, inPortName, (AbstractAction)trg, true, context_p);
                fe = FaFactory.eINSTANCE.createFunctionalExchange();
                fe.setSid(id);
                fe.setId(id);
                fe.setDescription(description);
                fe.setName(feName);
                fe.setSource((ActivityNode)srcPort);
                fe.setTarget((ActivityNode)trgPort);
                if (container instanceof AbstractFunction) {
                    ((AbstractFunction)container).getOwnedFunctionalExchanges().add((Object)fe);
                }
            }
        }
        return fe;
    }

    private FunctionPort getOrCreateFakePort(String id, String name, AbstractAction fct, boolean input, IContext context_p) {
        FunctionInputPort res = null;
        if (res == null) {
            if (input) {
                for (InputPin port : fct.getInputs()) {
                    if (!port.getId().equals(id)) continue;
                    res = (FunctionPort)port;
                    break;
                }
                if (res == null) {
                    res = FaFactory.eINSTANCE.createFunctionInputPort();
                    fct.getInputs().add((Object)res);
                }
            } else {
                for (OutputPin port : fct.getOutputs()) {
                    if (!port.getId().equals(id)) continue;
                    res = (FunctionPort)port;
                    break;
                }
                if (res == null) {
                    res = FaFactory.eINSTANCE.createFunctionOutputPort();
                    fct.getOutputs().add((Object)((FunctionOutputPort)res));
                }
            }
            res.setSid(id);
            res.setId(id);
            res.setName(name);
        }
        return res;
    }
}

