/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.launch;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.util.classpath.ClasspathUtils;
import org.eclipse.buildship.ui.internal.launch.SelectionJavaElementResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public final class TestLaunchShortcutValidator {
    private TestLaunchShortcutValidator() {
    }

    public static boolean validateTypesAndMethods(Collection<IType> types, Collection<IMethod> methods) {
        ImmutableList allElements = ImmutableList.builder().addAll(types).addAll(methods).build();
        return TestLaunchShortcutValidator.validateJavaElements((List<? extends IJavaElement>)allElements) && TestLaunchShortcutValidator.validateTypes(types) && TestLaunchShortcutValidator.validateMethods(methods);
    }

    private static boolean validateTypes(Collection<IType> types) {
        for (IType type : types) {
            if (TestLaunchShortcutValidator.isInSourceFolder(type)) continue;
            return false;
        }
        for (IType type : types) {
            if (TestLaunchShortcutValidator.isTestType(type)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateMethods(Collection<IMethod> methods) {
        for (IMethod element : methods) {
            IType type = element.getDeclaringType();
            if (type != null && TestLaunchShortcutValidator.isInSourceFolder(type)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInSourceFolder(IType type) {
        IPackageFragmentRoot packageFragmentRoot = TestLaunchShortcutValidator.getPackageFragmentRoot(type);
        if (packageFragmentRoot != null) {
            try {
                return packageFragmentRoot.getKind() == 1 && packageFragmentRoot.getRawClasspathEntry() != null;
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return false;
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IType type) {
        IJavaElement fragmentRoot = type.getPackageFragment().getParent();
        if (fragmentRoot instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)fragmentRoot;
        }
        return null;
    }

    private static boolean validateJavaElements(List<? extends IJavaElement> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        for (IJavaElement iJavaElement : elements) {
            if (iJavaElement.getJavaProject() != null && iJavaElement.getJavaProject().getProject() != null) continue;
            return false;
        }
        IProject project = elements.get(0).getJavaProject().getProject();
        for (IJavaElement iJavaElement : elements) {
            if (iJavaElement.getJavaProject().getProject().equals(project)) continue;
            return false;
        }
        return GradleProjectNature.isPresentOn((IProject)project);
    }

    private static boolean isTestType(IType type) {
        IClasspathEntry fragmentRootEntry = null;
        try {
            fragmentRootEntry = TestLaunchShortcutValidator.getPackageFragmentRoot(type).getRawClasspathEntry();
        }
        catch (JavaModelException e) {
            throw new GradlePluginsRuntimeException((Throwable)e);
        }
        Optional scopes = ClasspathUtils.scopesFor((IClasspathEntry)fragmentRootEntry);
        if (scopes.isPresent()) {
            return TestLaunchShortcutValidator.hasElementContainingTheWordTest((Collection)scopes.get());
        }
        return TestLaunchShortcutValidator.hasElementContainingTheWordTest(TestLaunchShortcutValidator.projectRelativePathSegments(type));
    }

    private static List<String> projectRelativePathSegments(IType type) {
        return Arrays.asList(type.getPath().makeRelativeTo(type.getJavaProject().getProject().getFullPath()).segments());
    }

    private static boolean hasElementContainingTheWordTest(Collection<String> elements) {
        for (String element : elements) {
            if (!element.toLowerCase().contains("test")) continue;
            return true;
        }
        return false;
    }

    public static final class PropertyTester
    extends org.eclipse.core.expressions.PropertyTester {
        private static final String PROPERTY_NAME_SELECTION_CAN_BE_LAUNCHED_AS_TEST = "selectioncanbelaunchedastest";

        public boolean test(Object receiver, String propertyString, Object[] args, Object expectedValue) {
            if (propertyString.equals(PROPERTY_NAME_SELECTION_CAN_BE_LAUNCHED_AS_TEST)) {
                return receiver instanceof Collection && this.selectionIsLaunchableAsTest((Collection)receiver);
            }
            throw new GradlePluginsRuntimeException("Unrecognized property to test: " + propertyString);
        }

        private boolean selectionIsLaunchableAsTest(Collection<?> elements) {
            SelectionJavaElementResolver elementResolver = SelectionJavaElementResolver.from(elements);
            return TestLaunchShortcutValidator.validateTypesAndMethods(elementResolver.resolveTypes(), elementResolver.resolveMethods());
        }
    }
}

