/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.internal.PluginImage;
import org.eclipse.buildship.ui.internal.PluginImages;
import org.eclipse.buildship.ui.internal.view.MultiPageView;
import org.eclipse.buildship.ui.internal.view.Page;
import org.eclipse.jface.action.Action;

public class RemovePageAction
extends Action {
    private final Page page;

    public RemovePageAction(Page page, String tooltip) {
        this.page = (Page)Preconditions.checkNotNull((Object)page);
        this.setToolTipText(tooltip);
        this.setImageDescriptor(PluginImages.REMOVE_PAGE.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.REMOVE_PAGE.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.enableIfCloseable();
    }

    protected Page getPage() {
        return this.page;
    }

    protected void enableIfCloseable() {
        this.setEnabled(this.page.isCloseable());
    }

    public void run() {
        MultiPageView view = (MultiPageView)this.page.getSite().getViewSite().getPart();
        if (this.page.isCloseable()) {
            view.removePage(this.page);
        }
    }
}

