/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.internal.preferences.DefaultPersistentModel;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;

public final class PersistentModelBuilder {
    private final PersistentModel previous;
    private IPath buildDir;
    private IPath buildScriptPath;
    private Collection<IPath> subprojectPaths;
    private List<IClasspathEntry> classpath;
    private Collection<IPath> derivedResources;
    private Collection<IPath> linkedResources;
    private Collection<String> managedNatures;
    private Collection<ICommand> managedBuilders;
    private boolean hasAutoBuildTasks;

    public PersistentModelBuilder(PersistentModel previous) {
        this.previous = (PersistentModel)Preconditions.checkNotNull((Object)previous);
        if (previous.isPresent()) {
            this.buildDir = previous.getBuildDir();
            this.buildScriptPath = previous.getbuildScriptPath();
            this.subprojectPaths = previous.getSubprojectPaths();
            this.classpath = previous.getClasspath();
            this.derivedResources = previous.getDerivedResources();
            this.linkedResources = previous.getLinkedResources();
            this.managedNatures = previous.getManagedNatures();
            this.managedBuilders = previous.getManagedBuilders();
        }
    }

    public PersistentModelBuilder buildDir(IPath buildDir) {
        this.buildDir = buildDir;
        return this;
    }

    public PersistentModelBuilder subprojectPaths(Collection<IPath> subprojectPaths) {
        this.subprojectPaths = subprojectPaths;
        return this;
    }

    public PersistentModelBuilder classpath(List<IClasspathEntry> classpath) {
        this.classpath = classpath;
        return this;
    }

    public PersistentModelBuilder derivedResources(Collection<IPath> derivedResources) {
        this.derivedResources = derivedResources;
        return this;
    }

    public PersistentModelBuilder linkedResources(Collection<IPath> linkedResources) {
        this.linkedResources = linkedResources;
        return this;
    }

    public PersistentModelBuilder managedNatures(Collection<String> managedNatures) {
        this.managedNatures = managedNatures;
        return this;
    }

    public PersistentModelBuilder managedBuilders(Collection<ICommand> managedBuilders) {
        this.managedBuilders = managedBuilders;
        return this;
    }

    public PersistentModelBuilder buildScriptPath(IPath buildScriptPath) {
        this.buildScriptPath = buildScriptPath;
        return this;
    }

    public PersistentModelBuilder hasAutoBuildTasks(boolean hasAutoBuildTasks) {
        this.hasAutoBuildTasks = hasAutoBuildTasks;
        return this;
    }

    public PersistentModel getPrevious() {
        return this.previous;
    }

    public PersistentModel build() {
        return new DefaultPersistentModel(this.previous.getProject(), this.buildDir, this.buildScriptPath, this.subprojectPaths, this.classpath, this.derivedResources, this.linkedResources, this.managedNatures, this.managedBuilders, this.hasAutoBuildTasks);
    }
}

