/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.buildship.core.internal.util.gradle.CompatEclipseExternalDependency;
import org.eclipse.buildship.core.internal.util.gradle.CompatEclipseProjectDependency;
import org.eclipse.buildship.core.internal.util.gradle.CompatEclipseSourceDirectory;
import org.eclipse.buildship.core.internal.util.gradle.CompatGradleProject;
import org.eclipse.buildship.core.internal.util.gradle.CompatModelElement;
import org.eclipse.buildship.core.internal.util.gradle.CompatSourceSettings;
import org.eclipse.buildship.core.internal.util.gradle.ModelUtils;
import org.gradle.api.JavaVersion;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.eclipse.EclipseBuildCommand;
import org.gradle.tooling.model.eclipse.EclipseClasspathContainer;
import org.gradle.tooling.model.eclipse.EclipseExternalDependency;
import org.gradle.tooling.model.eclipse.EclipseJavaSourceSettings;
import org.gradle.tooling.model.eclipse.EclipseLinkedResource;
import org.gradle.tooling.model.eclipse.EclipseOutputLocation;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseProjectDependency;
import org.gradle.tooling.model.eclipse.EclipseProjectNature;
import org.gradle.tooling.model.eclipse.EclipseSourceDirectory;
import org.gradle.tooling.model.java.InstalledJdk;

public class CompatEclipseProject
extends CompatModelElement<EclipseProject>
implements EclipseProject {
    private static final DomainObjectSet<? extends EclipseClasspathContainer> UNSUPPORTED_CONTAINERS = ModelUtils.emptyDomainObjectSet();
    static final EclipseJavaSourceSettings FALLBACK_JAVA_SOURCE_SETTINGS = new FallbackJavaSourceSettings();
    static final EclipseOutputLocation FALLBACK_OUTPUT_LOCATION = new FallbackOutputLocation();

    CompatEclipseProject(EclipseProject delegate) {
        super(delegate);
    }

    public DomainObjectSet<? extends EclipseBuildCommand> getBuildCommands() {
        try {
            return ((EclipseProject)this.getElement()).getBuildCommands();
        }
        catch (Exception ignore) {
            return ModelUtils.emptyDomainObjectSet();
        }
    }

    public DomainObjectSet<? extends EclipseProject> getChildren() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (EclipseProject child : ((EclipseProject)this.getElement()).getChildren()) {
            result.add((Object)new CompatEclipseProject(child));
        }
        return ModelUtils.asDomainObjectSet(result.build());
    }

    public DomainObjectSet<? extends EclipseExternalDependency> getClasspath() {
        DomainObjectSet dependencies = ((EclipseProject)this.getElement()).getClasspath();
        ArrayList result = Lists.newArrayListWithCapacity((int)dependencies.size());
        for (EclipseExternalDependency dependency : dependencies) {
            result.add(new CompatEclipseExternalDependency(dependency));
        }
        return ModelUtils.asDomainObjectSet(result);
    }

    public DomainObjectSet<? extends EclipseClasspathContainer> getClasspathContainers() {
        try {
            return ((EclipseProject)this.getElement()).getClasspathContainers();
        }
        catch (Exception ignore) {
            return UNSUPPORTED_CONTAINERS;
        }
    }

    public String getDescription() {
        return ((EclipseProject)this.getElement()).getDescription();
    }

    public GradleProject getGradleProject() {
        return new CompatGradleProject(((EclipseProject)this.getElement()).getGradleProject());
    }

    public EclipseJavaSourceSettings getJavaSourceSettings() {
        try {
            EclipseJavaSourceSettings sourceSettings = ((EclipseProject)this.getElement()).getJavaSourceSettings();
            return sourceSettings == null ? null : new CompatSourceSettings(sourceSettings);
        }
        catch (Exception e) {
            return this.getSourceDirectories().isEmpty() ? null : FALLBACK_JAVA_SOURCE_SETTINGS;
        }
    }

    public DomainObjectSet<? extends EclipseLinkedResource> getLinkedResources() {
        return ((EclipseProject)this.getElement()).getLinkedResources();
    }

    public String getName() {
        return ((EclipseProject)this.getElement()).getName();
    }

    public EclipseOutputLocation getOutputLocation() {
        try {
            EclipseOutputLocation outputLocation = ((EclipseProject)this.getElement()).getOutputLocation();
            return outputLocation != null ? outputLocation : FALLBACK_OUTPUT_LOCATION;
        }
        catch (Exception ignore) {
            return FALLBACK_OUTPUT_LOCATION;
        }
    }

    public EclipseProject getParent() {
        EclipseProject parent = ((EclipseProject)this.getElement()).getParent();
        return parent == null ? parent : new CompatEclipseProject(parent);
    }

    public DomainObjectSet<? extends EclipseProjectDependency> getProjectDependencies() {
        DomainObjectSet projectDependencies = ((EclipseProject)this.getElement()).getProjectDependencies();
        ArrayList result = Lists.newArrayListWithCapacity((int)projectDependencies.size());
        for (EclipseProjectDependency dependency : projectDependencies) {
            result.add(new CompatEclipseProjectDependency(dependency));
        }
        return ModelUtils.asDomainObjectSet(result);
    }

    public File getProjectDirectory() {
        return ((EclipseProject)this.getElement()).getProjectDirectory();
    }

    public ProjectIdentifier getProjectIdentifier() {
        return ((EclipseProject)this.getElement()).getProjectIdentifier();
    }

    public DomainObjectSet<? extends EclipseProjectNature> getProjectNatures() {
        try {
            return ((EclipseProject)this.getElement()).getProjectNatures();
        }
        catch (Exception e) {
            return ModelUtils.emptyDomainObjectSet();
        }
    }

    public DomainObjectSet<? extends EclipseSourceDirectory> getSourceDirectories() {
        DomainObjectSet directories = ((EclipseProject)this.getElement()).getSourceDirectories();
        ArrayList result = Lists.newArrayListWithCapacity((int)directories.size());
        for (EclipseSourceDirectory directory : directories) {
            result.add(new CompatEclipseSourceDirectory(directory));
        }
        return ModelUtils.asDomainObjectSet(result);
    }

    public static boolean supportsClasspathContainers(EclipseProject project) {
        return project.getClasspathContainers() != UNSUPPORTED_CONTAINERS;
    }

    private static final class FallbackJavaSourceSettings
    implements EclipseJavaSourceSettings {
        private FallbackJavaSourceSettings() {
        }

        public JavaVersion getTargetBytecodeVersion() {
            return JavaVersion.current();
        }

        public JavaVersion getSourceLanguageLevel() {
            return JavaVersion.current();
        }

        public InstalledJdk getJdk() {
            return new InstalledJdk(){

                public JavaVersion getJavaVersion() {
                    return JavaVersion.current();
                }

                public File getJavaHome() {
                    return new File(System.getProperty("java.home")).getAbsoluteFile();
                }
            };
        }
    }

    private static final class FallbackOutputLocation
    implements EclipseOutputLocation {
        private FallbackOutputLocation() {
        }

        public String getPath() {
            return "bin";
        }
    }
}

