/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal;

import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.internal.CacheKey;
import org.eclipse.buildship.core.internal.InspectableResultHandler;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.events.OperationType;

final class CachingModelBuilder<T>
implements ModelBuilder<T> {
    private final ModelBuilder<T> delegate;
    private final Cache<Object, Object> cache;
    private final CacheKey cacheKey;

    CachingModelBuilder(ModelBuilder<T> delegate, Cache<Object, Object> cache, Class<T> modelType) {
        this.delegate = delegate;
        this.cache = cache;
        this.cacheKey = new CacheKey();
        this.cacheKey.setModelType(modelType);
    }

    public CachingModelBuilder<T> withArguments(String ... arguments) {
        this.cacheKey.setArguments(Arrays.asList(arguments));
        this.delegate.withArguments(arguments);
        return this;
    }

    public CachingModelBuilder<T> withArguments(Iterable<String> arguments) {
        this.cacheKey.setArguments(arguments == null ? null : Lists.newArrayList(arguments));
        this.delegate.withArguments(arguments);
        return this;
    }

    public ModelBuilder<T> addArguments(String ... arguments) {
        this.cacheKey.addArguments(Arrays.asList(arguments));
        this.delegate.addArguments(arguments);
        return this;
    }

    public ModelBuilder<T> addArguments(Iterable<String> arguments) {
        this.cacheKey.addArguments(Lists.newArrayList(arguments));
        this.delegate.addArguments(arguments);
        return this;
    }

    public CachingModelBuilder<T> setStandardOutput(OutputStream outputStream) {
        this.cacheKey.markInvalid();
        this.delegate.setStandardOutput(outputStream);
        return this;
    }

    public CachingModelBuilder<T> setStandardError(OutputStream outputStream) {
        this.cacheKey.markInvalid();
        this.delegate.setStandardError(outputStream);
        return this;
    }

    public CachingModelBuilder<T> setColorOutput(boolean colorOutput) {
        this.cacheKey.markInvalid();
        this.delegate.setColorOutput(colorOutput);
        return this;
    }

    public CachingModelBuilder<T> setStandardInput(InputStream inputStream) {
        this.cacheKey.markInvalid();
        this.delegate.setStandardInput(inputStream);
        return this;
    }

    public CachingModelBuilder<T> setJavaHome(File javaHome) {
        this.cacheKey.setJavaHome(javaHome);
        this.delegate.setJavaHome(javaHome);
        return this;
    }

    public CachingModelBuilder<T> setJvmArguments(String ... jvmArguments) {
        this.cacheKey.setJvmArguments(Arrays.asList(jvmArguments));
        this.delegate.setJvmArguments(jvmArguments);
        return this;
    }

    public CachingModelBuilder<T> setJvmArguments(Iterable<String> jvmArguments) {
        this.cacheKey.setJvmArguments(jvmArguments == null ? null : Lists.newArrayList(jvmArguments));
        this.delegate.setJvmArguments(jvmArguments);
        return this;
    }

    public ModelBuilder<T> addJvmArguments(String ... jvmArguments) {
        this.cacheKey.addJvmArguments(Arrays.asList(jvmArguments));
        this.delegate.addJvmArguments(jvmArguments);
        return this;
    }

    public ModelBuilder<T> addJvmArguments(Iterable<String> jvmArguments) {
        this.cacheKey.addJvmArguments(Lists.newArrayList(jvmArguments));
        this.delegate.addJvmArguments(jvmArguments);
        return this;
    }

    public CachingModelBuilder<T> setEnvironmentVariables(Map<String, String> envVariables) {
        this.cacheKey.setEnvironmentVariables(envVariables);
        this.delegate.setEnvironmentVariables(envVariables);
        return this;
    }

    public CachingModelBuilder<T> addProgressListener(ProgressListener listener) {
        this.cacheKey.markInvalid();
        this.delegate.addProgressListener(listener);
        return this;
    }

    public CachingModelBuilder<T> addProgressListener(org.gradle.tooling.events.ProgressListener listener) {
        this.cacheKey.markInvalid();
        this.delegate.addProgressListener(listener);
        return this;
    }

    public CachingModelBuilder<T> addProgressListener(org.gradle.tooling.events.ProgressListener listener, Set<OperationType> eventTypes) {
        this.cacheKey.markInvalid();
        this.delegate.addProgressListener(listener, eventTypes);
        return this;
    }

    public CachingModelBuilder<T> addProgressListener(org.gradle.tooling.events.ProgressListener listener, OperationType ... operationTypes) {
        this.cacheKey.markInvalid();
        this.delegate.addProgressListener(listener, operationTypes);
        return this;
    }

    public CachingModelBuilder<T> withCancellationToken(CancellationToken cancellationToken) {
        this.delegate.withCancellationToken(cancellationToken);
        return this;
    }

    public CachingModelBuilder<T> forTasks(String ... tasks) {
        this.cacheKey.setTasks(Arrays.asList(tasks));
        this.delegate.forTasks(tasks);
        return this;
    }

    public CachingModelBuilder<T> forTasks(Iterable<String> tasks) {
        this.cacheKey.setTasks(tasks == null ? null : Lists.newArrayList(tasks));
        this.delegate.forTasks(tasks);
        return this;
    }

    public T get() throws GradleConnectionException, IllegalStateException {
        Object cachedValue;
        Object object = cachedValue = this.cacheKey.isInvalid() ? null : this.cache.getIfPresent((Object)this.cacheKey);
        if (cachedValue != null) {
            return (T)cachedValue;
        }
        Object result = this.delegate.get();
        this.cache.put((Object)this.cacheKey, result);
        return (T)result;
    }

    public void get(ResultHandler<? super T> handler) throws IllegalStateException {
        Object cachedValue;
        Object object = cachedValue = this.cacheKey.isInvalid() ? null : this.cache.getIfPresent((Object)this.cacheKey);
        if (cachedValue != null) {
            handler.onComplete(cachedValue);
        } else {
            InspectableResultHandler<? super T> inspectableResultHandler = new InspectableResultHandler<T>();
            this.delegate.get(inspectableResultHandler);
            inspectableResultHandler.getResult().ifPresent(r -> this.cache.put((Object)this.cacheKey, r));
            inspectableResultHandler.forwardResults(handler);
        }
    }
}

