/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.launch;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.configuration.Test;
import org.eclipse.buildship.core.internal.launch.JavaElementSelection;
import org.eclipse.buildship.core.internal.launch.LaunchMessages;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.classpath.ClasspathUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;

public abstract class TestExecutionTarget {
    private TestExecutionTarget() {
    }

    public abstract IProject getProject();

    public abstract Optional<String> validate();

    private static Optional<String> canExecuteTestRun(Collection<IType> types, Collection<IMethod> methods) {
        ImmutableList allElements = ImmutableList.builder().addAll(types).addAll(methods).build();
        Optional<String> result = TestExecutionTarget.validateJavaElements((List<? extends IJavaElement>)allElements);
        if (!result.isPresent()) {
            result = TestExecutionTarget.validateTypes(types);
        }
        if (!result.isPresent()) {
            result = TestExecutionTarget.validateMethods(methods);
        }
        return result;
    }

    private static Optional<String> validateTypes(Collection<IType> types) {
        for (IType type : types) {
            if (TestExecutionTarget.isInSourceFolder(type)) continue;
            return Optional.of(LaunchMessages.Validation_Message_BinaryType);
        }
        for (IType type : types) {
            if (TestExecutionTarget.isTestType(type)) continue;
            return Optional.of(LaunchMessages.Validation_Message_NotTestType);
        }
        return Optional.empty();
    }

    private static Optional<String> validateMethods(Collection<IMethod> methods) {
        for (IMethod element : methods) {
            IType type = element.getDeclaringType();
            if (type != null && TestExecutionTarget.isInSourceFolder(type)) continue;
            return Optional.of(LaunchMessages.Validation_Message_BinaryMethod);
        }
        return Optional.empty();
    }

    private static Optional<String> supportsTestDebugging(IProject project) {
        PersistentModel model = CorePlugin.modelPersistence().loadModel(project);
        return model.isPresent() && model.getGradleVersion().supportsTestDebugging() ? Optional.empty() : Optional.of(NLS.bind((String)LaunchMessages.Validation_Message_NoTestDebugSupport_0_1, (Object)model.getGradleVersion().getVersion(), (Object)project.getName()));
    }

    private static boolean isInSourceFolder(IType type) {
        IPackageFragmentRoot packageFragmentRoot = TestExecutionTarget.getPackageFragmentRoot(type);
        if (packageFragmentRoot != null) {
            try {
                return packageFragmentRoot.getKind() == 1 && packageFragmentRoot.getRawClasspathEntry() != null;
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return false;
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IType type) {
        IJavaElement fragmentRoot = type.getPackageFragment().getParent();
        if (fragmentRoot instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)fragmentRoot;
        }
        return null;
    }

    private static Optional<String> validateJavaElements(List<? extends IJavaElement> elements) {
        if (elements.isEmpty()) {
            return Optional.of(LaunchMessages.Validation_Message_NoTests);
        }
        for (IJavaElement iJavaElement : elements) {
            if (iJavaElement.getJavaProject() != null && iJavaElement.getJavaProject().getProject() != null) continue;
            return Optional.of(LaunchMessages.Validation_Message_NoProject);
        }
        IProject project = elements.get(0).getJavaProject().getProject();
        for (IJavaElement iJavaElement : elements) {
            if (iJavaElement.getJavaProject().getProject().equals((Object)project)) continue;
            return Optional.of(LaunchMessages.Validation_Message_DifferentProject);
        }
        return TestExecutionTarget.validateGradleProject(project);
    }

    private static Optional<String> validateGradleProject(IProject project) {
        if (project == null) {
            return Optional.of(LaunchMessages.Validation_Message_NullProject);
        }
        if (!project.isOpen()) {
            return Optional.of(NLS.bind((String)LaunchMessages.Validation_Message_ClosedProject_0, (Object)project.getName()));
        }
        return GradleProjectNature.isPresentOn(project) ? Optional.empty() : Optional.of(NLS.bind((String)LaunchMessages.Validation_Message_NotGradleProject_0, (Object)project.getName()));
    }

    private static boolean isTestType(IType type) {
        IClasspathEntry fragmentRootEntry = null;
        try {
            fragmentRootEntry = TestExecutionTarget.getPackageFragmentRoot(type).getRawClasspathEntry();
        }
        catch (JavaModelException e) {
            throw new GradlePluginsRuntimeException(e);
        }
        Optional<Set<String>> scopes = ClasspathUtils.scopesFor(fragmentRootEntry);
        if (scopes.isPresent()) {
            return TestExecutionTarget.hasElementContainingTheWordTest((Collection<String>)scopes.get());
        }
        return TestExecutionTarget.hasElementContainingTheWordTest(TestExecutionTarget.projectRelativePathSegments(type));
    }

    private static List<String> projectRelativePathSegments(IType type) {
        return Arrays.asList(type.getPath().makeRelativeTo(type.getJavaProject().getProject().getFullPath()).segments());
    }

    private static boolean hasElementContainingTheWordTest(Collection<String> elements) {
        for (String element : elements) {
            if (!element.toLowerCase().contains("test")) continue;
            return true;
        }
        return false;
    }

    public static TestExecutionTarget from(JavaElementSelection selection, String mode) {
        return new SelectionBackedTestExecutionTarget(selection, mode);
    }

    public static TestExecutionTarget from(IProject project, List<Test> tests, String mode) {
        return new TestBackedTestExecutionTarget(project, tests, mode);
    }

    private static class SelectionBackedTestExecutionTarget
    extends TestExecutionTarget {
        private final JavaElementSelection selection;
        private final String mode;
        private final IProject project;

        public SelectionBackedTestExecutionTarget(JavaElementSelection selection, String mode) {
            this.selection = selection;
            this.mode = mode;
            this.project = ImmutableList.builder().addAll(selection.getSelectedTypes()).addAll(selection.getSelectedMethods()).build().stream().findFirst().map(javaElement -> javaElement.getJavaProject()).map(javaProject -> javaProject.getProject()).orElse(null);
        }

        @Override
        public Optional<String> validate() {
            Optional<String> result = TestExecutionTarget.canExecuteTestRun(this.selection.getSelectedTypes(), this.selection.getSelectedMethods());
            if (!result.isPresent() && "debug".equals(this.mode)) {
                result = TestExecutionTarget.supportsTestDebugging(this.project);
            }
            return result;
        }

        @Override
        public IProject getProject() {
            return this.project;
        }
    }

    private static class TestBackedTestExecutionTarget
    extends TestExecutionTarget {
        private final IProject project;
        private final List<Test> tests;
        private final String mode;

        public TestBackedTestExecutionTarget(IProject project, List<Test> tests, String mode) {
            this.project = project;
            this.tests = tests;
            this.mode = mode;
        }

        @Override
        public Optional<String> validate() {
            Optional<String> result = TestExecutionTarget.validateGradleProject(this.project);
            if (!result.isPresent()) {
                Optional<Object> optional = result = this.tests.isEmpty() ? Optional.of(NLS.bind((String)LaunchMessages.Validation_Message_NoTests_0, (Object)this.project.getName())) : Optional.empty();
            }
            if (!result.isPresent()) {
                result = "debug".equals(this.mode) ? TestExecutionTarget.supportsTestDebugging(this.project) : Optional.empty();
            }
            return result;
        }

        @Override
        public IProject getProject() {
            return this.project;
        }
    }
}

