/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import org.eclipse.buildship.core.internal.util.gradle.CompatModelElement;
import org.eclipse.buildship.core.internal.util.gradle.CompatTask;
import org.eclipse.buildship.core.internal.util.gradle.ModelUtils;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.gradle.GradleScript;

class CompatGradleProject
extends CompatModelElement<GradleProject>
implements GradleProject {
    public CompatGradleProject(GradleProject delegate) {
        super(delegate);
    }

    public String getDescription() {
        return ((GradleProject)this.getElement()).getDescription();
    }

    public String getName() {
        return ((GradleProject)this.getElement()).getName();
    }

    public GradleProject findByPath(String path) {
        return ((GradleProject)this.getElement()).findByPath(path);
    }

    public File getBuildDirectory() {
        try {
            return ((GradleProject)this.getElement()).getBuildDirectory();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public GradleScript getBuildScript() {
        try {
            return ((GradleProject)this.getElement()).getBuildScript();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public DomainObjectSet<? extends GradleProject> getChildren() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (GradleProject child : ((GradleProject)this.getElement()).getChildren()) {
            result.add((Object)new CompatGradleProject(child));
        }
        return ModelUtils.asDomainObjectSet(result.build());
    }

    public GradleProject getParent() {
        GradleProject parent = ((GradleProject)this.getElement()).getParent();
        return parent == null ? parent : new CompatGradleProject(parent);
    }

    public String getPath() {
        return ((GradleProject)this.getElement()).getPath();
    }

    public File getProjectDirectory() {
        try {
            return ((GradleProject)this.getElement()).getProjectDirectory();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public ProjectIdentifier getProjectIdentifier() {
        return ((GradleProject)this.getElement()).getProjectIdentifier();
    }

    public DomainObjectSet<? extends GradleTask> getTasks() {
        ImmutableList tasks = FluentIterable.from((Iterable)((GradleProject)this.getElement()).getTasks()).transform((Function)new Function<GradleTask, GradleTask>(){

            public GradleTask apply(GradleTask task) {
                return new CompatTask(task);
            }
        }).toList();
        return ModelUtils.asDomainObjectSet(tasks);
    }
}

