/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.io.File;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.osgi.framework.Bundle;

public class BundleIndex {
    private final ConcurrentHashMap<URI, Bundle> _uriToBundle = new ConcurrentHashMap();
    private final ConcurrentHashMap<Bundle, Resource> _bundleToResource = new ConcurrentHashMap();
    private final ConcurrentHashMap<Resource, Bundle> _resourceToBundle = new ConcurrentHashMap();
    private final ConcurrentHashMap<Bundle, URI> _bundleToUri = new ConcurrentHashMap();

    public Resource indexBundle(ResourceFactory resourceFactory, Bundle bundle) throws Exception {
        File bundleFile = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
        Resource resource = resourceFactory.newResource(bundleFile.toURI());
        URI uri = resource.getURI();
        this._uriToBundle.putIfAbsent(uri, bundle);
        this._bundleToUri.putIfAbsent(bundle, uri);
        this._bundleToResource.putIfAbsent(bundle, resource);
        this._resourceToBundle.putIfAbsent(resource, bundle);
        return resource;
    }

    public URI getURI(Bundle bundle) {
        return this._bundleToUri.get(bundle);
    }

    public Resource getResource(Bundle bundle) {
        return this._bundleToResource.get(bundle);
    }

    public Bundle getBundle(Resource resource) {
        return this._resourceToBundle.get(resource);
    }
}

