/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import org.eclipse.datatools.modelbase.sql.schema.Database;

public class VendorHelper {
    protected Database database;

    public VendorHelper(Database database) {
        this.database = database;
    }

    public static boolean isFullSelectSupported(Database database) {
        boolean isSupported = true;
        if (database != null && (database.getVendor().equals("My SQL") || database.getVendor().equals("DB2 Everyplace") || database.getVendor().equals("Instant DB"))) {
            isSupported = false;
        }
        return isSupported;
    }

    public static boolean isWithSupported(Database database) {
        boolean isSupported = false;
        if (database != null && database.getVendor().startsWith("DB2 UDB")) {
            isSupported = true;
        }
        return isSupported;
    }

    public boolean isDB2UDBNT_V8() {
        boolean isDB = false;
        if (this.isDB2UDBNT() && this.database != null && this.database.getVersion().startsWith("V8")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isDB2forLUW_v9() {
        boolean isDB = false;
        if (this.isDB2UDBNT() && this.database != null && this.database.getVersion().startsWith("V9")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isDB2UDBOS390_V6() {
        boolean isDB = false;
        if (this.isDB2UDBOS390() && this.database != null && this.database.getVersion().equals("6")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isDB2UDBOS390() {
        boolean isDB = false;
        if (this.database != null && this.database.getVendor().equals("DB2 UDB zSeries")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isDB2forZOS_v9() {
        boolean isDB = false;
        if (this.isDB2UDBOS390() && this.database != null && this.database.getVersion().startsWith("9")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isDB2Everyplace() {
        boolean isDB = false;
        if (this.database != null && this.database.getVendor().equals("DB2 Everyplace")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isOracle() {
        boolean isDB = false;
        if (this.database != null && this.database.getVendor().equals("Oracle")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isOracle_V8() {
        boolean isDB = false;
        if (this.isOracle() && this.database != null && this.database.getVersion().equals("8")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isOracle_V9() {
        boolean isDB = false;
        if (this.isOracle() && this.database != null && this.database.getVersion().equals("9")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isOracle_V10() {
        boolean isDB = false;
        if (this.isOracle() && this.database != null && this.database.getVersion().equals("10")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isInformix() {
        boolean isDB = false;
        if (this.database != null && this.database.getVendor().equals("Informix")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isMSSQLServer() {
        boolean isDB = false;
        if (this.database != null && this.database.getVendor().equals("SQL Server")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isInstantDB() {
        boolean isDB = false;
        if (this.database != null && this.database.getVendor().equals("Instant DB")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isSybase() {
        boolean isDB = false;
        if (this.database != null && this.database.getVendor().equals("Sybase")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isMySQL() {
        boolean isDB = false;
        if (this.database != null && this.database.getVendor().equals("My SQL")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isDB2() {
        boolean isDB = false;
        if (this.database != null && this.database.getVendor().startsWith("DB2 UDB")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isDB2UDBNT() {
        boolean isDB = false;
        if (this.database != null && this.database.getVendor().equals("DB2 UDB")) {
            isDB = true;
        }
        return isDB;
    }

    public boolean isCloudscape() {
        boolean isDB = false;
        if (this.database != null && (this.database.getVendor().equals("IBM Cloudscape") || this.database.getVendor().equals("Apache Derby") || this.database.getVendor().equals("Derby"))) {
            isDB = true;
        }
        return isDB;
    }
}

