/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogStatistics;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogCheckConstraint;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogColumn;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDistinctUserDefinedType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogForeignKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogIndex;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrimaryKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrivilege;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTrigger;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogUniqueConstraint;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogView;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.StorageProvider;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWCatalogMessages;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWDdlParser;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDataPartition;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDataPartitionKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWIndex;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWStorageTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTableSpace;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWTableImpl;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2IdentitySpecifier;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2IndexType;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2ModelPackage;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Package;
import org.eclipse.datatools.enablement.ibm.db2.model.GenerateType;
import org.eclipse.datatools.enablement.ibm.util.IRowCountCache;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogTable
extends LUWTableImpl
implements IRowCountCache,
ICatalogObject,
IDatabaseObject {
    public static final String PROP_TABLE_PROPERTIES = "PROP_TABLE_PROPERTIES";
    public static final String PROP_TABLE_ROWCOUNT = "PROP_TABLE_ROWCOUNT";
    public static final String PROP_TABLE_TABLESPACE = "PROP_TABLE_TABLESPACE";
    private static final String PROP_TABLE_COLUMNS = "PROP_TABLE_COLUMNS";
    private boolean columnsLoaded = false;
    private boolean constraintLoaded = false;
    private boolean indexLoaded = false;
    private boolean triggerLoaded = false;
    private boolean partitionKeyLoaded = false;
    private boolean dataPartitionLoaded = false;
    private boolean tablespaceLoaded = false;
    private boolean privilegeLoaded = false;
    private boolean statisticsLoaded = false;
    private boolean impactsLoaded = false;
    private boolean rowCountLoaded = false;
    private HashMap cachedColumn = new HashMap();
    private String partitionMode = "";
    private String tbspaceName = null;
    private String indexTbspaceName = null;
    private String longTbspaceName = null;
    private Collection impacts = new ArrayList();
    private Collection statistics = new ArrayList();
    private String rowCount = null;

    public void refresh() {
        this.columnsLoaded = false;
        this.constraintLoaded = false;
        this.indexLoaded = false;
        this.triggerLoaded = false;
        this.partitionKeyLoaded = false;
        this.dataPartitionLoaded = false;
        this.tablespaceLoaded = false;
        this.privilegeLoaded = false;
        this.rowCountLoaded = false;
        this.reset();
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
        if ((1 & refreshType) == 1) {
            this.statistics.clear();
            this.statisticsLoaded = false;
            this.rowCountLoaded = false;
        }
    }

    public EList getColumns() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getColumns();
        }
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public synchronized EList getConstraints() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getConstraints();
        }
        if (!this.constraintLoaded) {
            this.loadConstraints();
        }
        return this.constraints;
    }

    public EList getIndex() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getIndex();
        }
        if (!this.indexLoaded) {
            this.loadIndexes();
        }
        return this.index;
    }

    public EList getTriggers() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getTriggers();
        }
        if (!this.triggerLoaded) {
            this.loadTriggers();
        }
        return this.triggers;
    }

    @Override
    public LUWPartitionKey getPartitionKey() {
        if (!this.partitionKeyLoaded) {
            this.loadPartitionKey();
        }
        return this.partitionKey;
    }

    @Override
    public LUWTableSpace getRegularDataTableSpace() {
        if (!this.tablespaceLoaded) {
            this.loadTablespace();
        }
        return this.regularDataTableSpace;
    }

    @Override
    public LUWTableSpace getIndexDataTableSpace() {
        if (!this.tablespaceLoaded) {
            this.loadTablespace();
        }
        return this.indexDataTableSpace;
    }

    @Override
    public LUWTableSpace getLOBDataTableSpace() {
        if (!this.tablespaceLoaded) {
            this.loadTablespace();
        }
        return this.lobDataTableSpace;
    }

    @Override
    public EList getDataPartitions() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDataPartitions();
        }
        if (!this.dataPartitionLoaded) {
            this.loadDataPartitions();
        }
        return this.dataPartitions;
    }

    @Override
    public LUWDataPartitionKey getDataPartitionKey() {
        if (!this.dataPartitionLoaded) {
            this.loadDataPartitions();
        }
        return this.dataPartitionKey;
    }

    @Override
    public List getTableSpaces() {
        Vector<LUWTableSpace> tableSpaces = new Vector<LUWTableSpace>();
        tableSpaces.addAll(super.getTableSpaces());
        if (this.getDataPartitions().size() != 0) {
            for (LUWDataPartition dataPartition : this.getDataPartitions()) {
                if (!tableSpaces.contains(dataPartition.getRegularDataTableSpace())) {
                    tableSpaces.add(dataPartition.getRegularDataTableSpace());
                }
                if (tableSpaces.contains(dataPartition.getLOBDataTableSpace())) continue;
                tableSpaces.add(dataPartition.getLOBDataTableSpace());
            }
        }
        return tableSpaces;
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        if (!this.statisticsLoaded) {
            this.statistics = LUWCatalogTable.getStatistics(this.getConnection(), (Table)this);
            this.statisticsLoaded = true;
        }
        return this.statistics;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getColumns();
        } else if (id == 18) {
            this.getConstraints();
        } else if (id == 14) {
            this.getIndex();
        } else if (id == 13) {
            this.getTriggers();
        } else if (id == 34) {
            this.getPartitionKey();
        } else if (id == 37) {
            this.getRegularDataTableSpace();
        } else if (id == 35) {
            this.getIndexDataTableSpace();
        } else if (id == 36) {
            this.getLOBDataTableSpace();
        } else if (id == 38) {
            this.getDataPartitions();
        } else if (id == 39) {
            this.getDataPartitionKey();
        } else if (id == 7) {
            this.getPrivileges();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        this.columnsLoaded = true;
        EList columns = super.getColumns();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadColumns(this.getConnection(), columns, (Table)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cacheColumn(columns);
        this.eSetDeliver(deliver);
    }

    private synchronized void loadConstraints() {
        if (this.constraintLoaded) {
            return;
        }
        this.constraintLoaded = true;
        EList constraintList = super.getConstraints();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadConstraints(this.getConnection(), constraintList, (Table)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LUWCatalogDatabase cfr_ignored_0 = (LUWCatalogDatabase)this.getCatalogDatabase();
        this.eSetDeliver(deliver);
    }

    private synchronized void loadIndexes() {
        if (this.indexLoaded) {
            return;
        }
        this.indexLoaded = true;
        EList indexes = super.getIndex();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadIndexes(this.getConnection(), indexes, (Table)this, ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LUWCatalogDatabase cfr_ignored_0 = (LUWCatalogDatabase)this.getCatalogDatabase();
        this.eSetDeliver(deliver);
    }

    private synchronized void loadTriggers() {
        if (this.triggerLoaded) {
            return;
        }
        this.triggerLoaded = true;
        EList triggerList = super.getTriggers();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadTriggers(this.getConnection(), triggerList, (Table)this, ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LUWCatalogDatabase cfr_ignored_0 = (LUWCatalogDatabase)this.getCatalogDatabase();
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPartitionKey() {
        if (this.partitionKeyLoaded) {
            return;
        }
        this.partitionKeyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadPartitionKey(this.getConnection(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadTablespace() {
        if (this.tablespaceLoaded) {
            return;
        }
        this.tablespaceLoaded = true;
        this.getCatalogDatabase();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            if (this.tbspaceName != null || this.indexTbspaceName != null || this.longTbspaceName != null) {
                this.setAssociatedTablespace();
            } else {
                LUWCatalogTable.loadTablespace(this.getConnection(), (Table)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDataPartitions() {
        if (this.dataPartitionLoaded) {
            return;
        }
        this.dataPartitionLoaded = true;
        super.getDataPartitions().clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadDataPartitions(this.getConnection(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        EList privileges = super.getPrivileges();
        for (Privilege privilege : privileges) {
            privilege.setGrantor(null);
            privilege.setGrantee(null);
        }
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadPrivileges(this.getConnection(), privileges, (Table)this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadColumns(Connection connection, EList columnList, Table table) throws SQLException {
        Schema schema = table.getSchema();
        Database database = ModelHelper.getDatabase((Schema)schema);
        String cfr_ignored_0 = String.valueOf(schema.getName()) + "." + table.getName();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        String version = databaseDefinition.getVersion();
        float ver = 9.0f;
        try {
            ver = Float.parseFloat(version.substring(1));
        }
        catch (NumberFormatException numberFormatException) {}
        String query = "SELECT COLNAME, REMARKS, GENERATED, IDENTITY, NULLS, TYPESCHEMA, TYPENAME, LENGTH, SCALE, CODEPAGE, DEFAULT, TARGET_TYPESCHEMA, TARGET_TYPENAME, LOGGED, COMPACT,";
        if (ver >= 9.5f) {
            query = String.valueOf(query) + " ROWCHANGETIMESTAMP,";
        }
        query = String.valueOf(query) + " TABSCHEMA, TABNAME FROM SYSCAT.COLUMNS";
        query = String.valueOf(query) + " WHERE TABSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "'" + " AND TABNAME='" + LUWUtil.getIdentifier(table.getName()) + "'";
        query = String.valueOf(query) + " ORDER BY TABSCHEMA, TABNAME, COLNO";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        TableColumnInfo tinfo = null;
        try {
            while (r.next()) {
                String schemaName = r.getString("TABSCHEMA").trim();
                String tableName = r.getString("TABNAME").trim();
                if (tinfo == null || !tinfo.schemaName.equals(schemaName) || !tinfo.tableName.equals(tableName)) {
                    tinfo = new TableColumnInfo();
                    tinfo.schemaName = schemaName;
                    tinfo.tableName = tableName;
                }
                ColumnInfo info = new ColumnInfo();
                info.columnName = r.getString(1);
                info.remarks = r.getString(2);
                info.generated = r.getString(3);
                info.isIdentity = r.getString(4);
                info.nulls = r.getString(5);
                info.typeSchemaName = r.getString(6).trim();
                info.typeName = r.getString(7);
                info.length = r.getInt(8);
                info.scale = r.getInt(9);
                info.codePage = r.getInt(10);
                info.dflt = r.getString(11);
                String str = r.getString("TARGET_TYPESCHEMA");
                if (str != null) {
                    info.targetTypeSchemaName = str.trim();
                }
                info.targetUdtName = r.getString("TARGET_TYPENAME");
                info.logged = r.getString("LOGGED");
                info.compact = r.getString("COMPACT");
                if (ver >= 9.5f) {
                    info.rowChangeTimestamp = r.getString("ROWCHANGETIMESTAMP");
                }
                tinfo.columns.add(info);
            }
            if (tinfo != null) {
                tinfo.setColumnInfoIn(table, (List<Column>)columnList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadProperties(Connection connection, Table table) throws SQLException {
        String schemaname = table.getSchema().getName();
        String tablename = table.getName();
        String cfr_ignored_0 = String.valueOf(schemaname) + "." + tablename;
        LUWCatalogDatabase cfr_ignored_1 = (LUWCatalogDatabase)table.getSchema().getDatabase();
        String query = "SELECT TABSCHEMA, TABNAME, REMARKS FROM SYSCAT.TABLES";
        query = String.valueOf(query) + " WHERE TABSCHEMA='" + LUWUtil.getIdentifier(schemaname) + "' AND TABNAME='" + LUWUtil.getIdentifier(tablename) + "'";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                r.getString("TABSCHEMA").trim();
                r.getString("TABNAME").trim();
                String description = r.getString("REMARKS");
                table.setDescription(description);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadTriggers(Connection connection, EList triggerList, Table table, int options) throws SQLException {
        Schema schema = table.getSchema();
        LUWCatalogDatabase database = (LUWCatalogDatabase)ModelHelper.getDatabase((Schema)schema);
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition((Database)database);
        databaseDefinition.getDataModelElementFactory();
        Object[] list = triggerList.toArray();
        triggerList.clear();
        if ((options & 2) == 2) {
            return;
        }
        String query = "SELECT TRIGSCHEMA, TRIGNAME, REMARKS, TRIGTIME, TRIGEVENT, GRANULARITY, TEXT, TABSCHEMA, TABNAME FROM SYSCAT.TRIGGERS";
        query = String.valueOf(query) + " WHERE TABSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "' AND TABNAME='" + LUWUtil.getIdentifier(table.getName()) + "'";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                LUWCatalogTrigger trigger;
                r.getString("TABSCHEMA").trim();
                r.getString("TABNAME").trim();
                String trigName = r.getString(2);
                EClass metaclass = SQLTablesPackage.eINSTANCE.getTrigger();
                Object element = LUWCatalogTable.findElement(list, trigName, metaclass);
                if (element != null) {
                    trigger = (LUWCatalogTrigger)((Object)element);
                    triggerList.add((Object)trigger);
                    ((ICatalogObject)element).refresh();
                } else {
                    trigger = new LUWCatalogTrigger();
                    trigger.setName(trigName);
                    triggerList.add((Object)trigger);
                }
                String text = r.getString(7);
                if (text != null) {
                    text = text.replaceAll("[\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f]", " ");
                }
                String trigSchema = r.getString(1).trim();
                trigger.setSchema(LUWCatalogTable.getSchema(table, trigSchema));
                String remarks = r.getString(3);
                trigger.setDescription(remarks);
                String trigTime = r.getString(4);
                if (trigTime.equals("A")) {
                    trigger.setActionTime(ActionTimeType.AFTER_LITERAL);
                } else if (trigTime.equals("B")) {
                    trigger.setActionTime(ActionTimeType.BEFORE_LITERAL);
                } else {
                    if (!trigTime.equals("I")) continue;
                    trigger.setActionTime(ActionTimeType.INSTEADOF_LITERAL);
                }
                String trigEvent = r.getString(5);
                if (trigEvent.equals("I")) {
                    trigger.setInsertType(true);
                } else if (trigEvent.equals("D")) {
                    trigger.setDeleteType(true);
                } else {
                    if (!trigEvent.equals("U")) continue;
                    trigger.setUpdateType(true);
                }
                String granularity = r.getString(6);
                if (granularity.equals("S")) {
                    trigger.setActionGranularity(ActionGranularityType.STATEMENT_LITERAL);
                } else {
                    if (!granularity.equals("R")) continue;
                    trigger.setActionGranularity(ActionGranularityType.ROW_LITERAL);
                }
                LUWDdlParser ddlParser = new LUWDdlParser(RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(table.getSchema().getDatabase()));
                ddlParser.parseTrigger((Trigger)trigger, text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadIndexes(Connection connection, EList indexList, Table table, int options) throws SQLException {
        LUWCatalogDatabase database = (LUWCatalogDatabase)table.getSchema().getDatabase();
        Object[] list = indexList.toArray();
        indexList.clear();
        if (database.isBatchLoad()) {
            return;
        }
        if ((options & 1) == 1) {
            return;
        }
        String sname = table.getSchema().getName();
        String tname = table.getName();
        String q = "SELECT INDEXTYPE, INDSCHEMA, INDNAME, REMARKS, UNIQUERULE, PCTFREE,SYSTEM_REQUIRED,USER_DEFINED, TABSCHEMA, TABNAME FROM SYSCAT.INDEXES";
        q = String.valueOf(q) + " WHERE TABSCHEMA='" + LUWUtil.getIdentifier(sname) + "' AND TABNAME='" + LUWUtil.getIdentifier(tname) + "'";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(q);
        try {
            while (r.next()) {
                int pctfree;
                r.getString("TABSCHEMA").trim();
                r.getString("TABNAME").trim();
                String indSchema = r.getString(2).trim();
                Schema schema = LUWCatalogTable.getSchema(table, indSchema);
                String indName = r.getString(3);
                Object index = null;
                Object element = LUWCatalogTable.findElement(list, indName, SQLConstraintsPackage.eINSTANCE.getIndex());
                if (element != null) {
                    index = (Index)element;
                    ((ICatalogObject)element).refresh();
                } else {
                    String type = r.getString(1).trim();
                    if (type.equals("REG")) {
                        index = new LUWCatalogIndex();
                    } else if (type.equals("CLUS")) {
                        index = new LUWCatalogIndex();
                        index.setClustered(true);
                    } else if (type.equals("DIM")) {
                        index = new LUWCatalogIndex();
                        ((LUWCatalogIndex)index).setIndexType(DB2IndexType.DIMENSION_LITERAL);
                    } else {
                        if (!type.equals("BLOK")) continue;
                        index = new LUWCatalogIndex();
                        ((LUWCatalogIndex)index).setIndexType(DB2IndexType.BLOCK_LITERAL);
                    }
                    index.setSchema(schema);
                    index.setName(indName);
                }
                String remarks = r.getString(4);
                index.setDescription(remarks);
                String uniqueRule = r.getString(5);
                if (!uniqueRule.equals("D")) {
                    index.setUnique(true);
                }
                if ("P".equalsIgnoreCase(uniqueRule)) {
                    ((LUWCatalogIndex)index).setIndexUniqueRule(LUWCatalogIndex.IndexUniqueRule.PRIMARYKEY);
                }
                if ((pctfree = r.getInt(6)) == -1) {
                    index.setFillFactor(10);
                } else {
                    index.setFillFactor(pctfree);
                }
                int userDefined = r.getInt("USER_DEFINED");
                if (userDefined == 0) {
                    index.setSystemGenerated(true);
                } else {
                    index.setSystemGenerated(false);
                }
                int systemRequred = r.getInt("SYSTEM_REQUIRED");
                if (index instanceof LUWIndex) {
                    if (systemRequred != 0) {
                        ((LUWIndex)index).setSystemRequired(true);
                    } else {
                        ((LUWIndex)index).setSystemRequired(false);
                    }
                }
                DB2IndexType indexType = ((LUWCatalogIndex)index).getIndexType();
                switch (indexType.getValue()) {
                    case 1: 
                    case 2: {
                        indexList.add(0, index);
                        break;
                    }
                    default: {
                        indexList.add(index);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadConstraints(Connection connection, EList constraintList, Table table) throws SQLException {
        table.getSchema().getDatabase();
        Object[] list = constraintList.toArray();
        constraintList.clear();
        String query = "SELECT DISTINCT A.CONSTNAME, A.REMARKS, A.TYPE, A.ENFORCED, B.TYPE CHECKTYPE,  A.TABSCHEMA, A.TABNAME FROM SYSCAT.TABCONST A LEFT OUTER JOIN SYSCAT.CHECKS B  ON A.CONSTNAME = B.CONSTNAME";
        query = String.valueOf(query) + " WHERE A.TABSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "' AND A.TABNAME='" + LUWUtil.getIdentifier(table.getName()) + "'";
        query = String.valueOf(query) + " ORDER BY TYPE DESC";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                r.getString("TABSCHEMA").trim();
                r.getString("TABNAME").trim();
                String constName = r.getString(1);
                Object constraint = null;
                String type = r.getString(3);
                EClass metaclass = null;
                if (type.equals("K")) {
                    metaclass = SQLConstraintsPackage.eINSTANCE.getCheckConstraint();
                } else if (type.equals("P")) {
                    metaclass = SQLConstraintsPackage.eINSTANCE.getPrimaryKey();
                } else if (type.equals("U")) {
                    metaclass = SQLConstraintsPackage.eINSTANCE.getUniqueConstraint();
                } else if (type.equals("F")) {
                    metaclass = SQLConstraintsPackage.eINSTANCE.getForeignKey();
                }
                Object sqlElement = LUWCatalogTable.findElement(list, constName, metaclass);
                if (sqlElement != null) {
                    constraint = (Constraint)sqlElement;
                    ((ICatalogObject)constraint).refresh();
                } else {
                    if (type.equals("K")) {
                        String checktype = r.getString("CHECKTYPE");
                        if (checktype == null || !checktype.equals("C")) continue;
                        constraint = new LUWCatalogCheckConstraint();
                    } else if (type.equals("P")) {
                        constraint = new LUWCatalogPrimaryKey();
                    } else if (type.equals("U")) {
                        constraint = new LUWCatalogUniqueConstraint();
                    } else {
                        if (!type.equals("F")) continue;
                        constraint = new LUWCatalogForeignKey();
                    }
                    constraint.setName(constName);
                }
                String remarks = r.getString(2);
                constraint.setDescription(remarks);
                String enforced = r.getString(4);
                if (enforced.equals("Y")) {
                    constraint.setEnforced(true);
                } else {
                    constraint.setEnforced(false);
                }
                constraintList.add(constraint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadPartitionKey(Connection connection, LUWStorageTable table) throws SQLException {
        try {
            StorageProvider provider = LUWCatalogDatabase.getCatalogStorageProvider();
            if (provider != null) {
                LUWPartitionKey partitionKey = provider.getPartitionKey(table);
                table.setPartitionKey(partitionKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadTablespace(Connection connection, Table table) throws SQLException {
        if (!(table instanceof LUWStorageTable)) {
            return;
        }
        Table luwtable = table;
        luwtable.getSchema().getDatabase();
        String schemaName = LUWUtil.getIdentifier(luwtable.getSchema().getName());
        String tableName = LUWUtil.getIdentifier(luwtable.getName());
        String cfr_ignored_0 = String.valueOf(schemaName) + "." + tableName;
        String query = "SELECT TBSPACE, INDEX_TBSPACE,LONG_TBSPACE, TABSCHEMA, TABNAME FROM SYSCAT.TABLES";
        query = String.valueOf(query) + " WHERE TABSCHEMA='" + schemaName + "'" + " AND TABNAME='" + tableName + "'";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                String tbspaceName = r.getString("TBSPACE");
                String indexTbspaceName = r.getString("INDEX_TBSPACE");
                String longTbspaceName = r.getString("LONG_TBSPACE");
                if (tbspaceName == null && indexTbspaceName == null && longTbspaceName == null) continue;
                TablespaceInfo info = new TablespaceInfo();
                info.tbspaceName = tbspaceName;
                info.indexTbspaceName = indexTbspaceName;
                info.longTbspaceName = longTbspaceName;
                info.setInfoInTable(luwtable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadDataPartitions(Connection connection, LUWStorageTable table) throws SQLException {
        try {
            EList partList = table.getDataPartitions();
            StorageProvider provider = LUWCatalogDatabase.getCatalogStorageProvider();
            if (provider != null) {
                for (LUWDataPartition part : provider.getDataPartition(table)) {
                    partList.add((Object)part);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadPrivileges(Connection connection, EList privilegeList, Table table, String granteeFilter) throws SQLException {
        Schema schema = table.getSchema();
        Database database = ModelHelper.getDatabase((Schema)schema);
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        databaseDefinition.getDataModelElementFactory();
        int options = ((LUWCatalogDatabase)database).getLoadOptions();
        if ((options & 0x800) == 2048) {
            return;
        }
        Statement s = connection.createStatement();
        String query = "SELECT GRANTOR,GRANTEE,GRANTEETYPE,CONTROLAUTH,ALTERAUTH,DELETEAUTH,INDEXAUTH,INSERTAUTH,SELECTAUTH,REFAUTH,UPDATEAUTH FROM SYSCAT.TABAUTH WHERE GRANTOR <> GRANTEE  AND TABSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "'" + " AND TABNAME='" + LUWUtil.getIdentifier(table.getName()) + "'";
        if (granteeFilter != null && !"".equals(granteeFilter)) {
            query = String.valueOf(query) + " AND " + granteeFilter;
        }
        ResultSet r = s.executeQuery(query);
        try {
            String userName = connection.getMetaData().getUserName();
            while (r.next()) {
                String updateAuth;
                String refAuth;
                String selectAuth;
                String insertAuth;
                String indexAuth;
                String deleteAuth;
                String alterAuth;
                String grantorId = r.getString("GRANTOR").trim();
                AuthorizationIdentifier grantor = LUWCatalogDatabase.getAuthorizationId(database, grantorId, null);
                String granteeId = r.getString("GRANTEE").trim();
                AuthorizationIdentifier grantee = null;
                String granteeType = r.getString("GRANTEETYPE");
                grantee = "G".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "G") : ("R".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "R") : LUWCatalogDatabase.getAuthorizationId(database, granteeId, "U"));
                LUWCatalogPrivilege privilege = null;
                boolean isSystemGranted = granteeId.equalsIgnoreCase(userName);
                String controlAuth = r.getString("CONTROLAUTH");
                if ("Y".equals(controlAuth)) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("CONTROL");
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!"N".equals(alterAuth = r.getString("ALTERAUTH"))) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("ALTER");
                    if ("G".equals(alterAuth)) {
                        privilege.setGrantable(true);
                    }
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!"N".equals(deleteAuth = r.getString("DELETEAUTH"))) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("DELETE");
                    if ("G".equals(deleteAuth)) {
                        privilege.setGrantable(true);
                    }
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!"N".equals(indexAuth = r.getString("INDEXAUTH"))) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("INDEX");
                    if ("G".equals(indexAuth)) {
                        privilege.setGrantable(true);
                    }
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!"N".equals(insertAuth = r.getString("INSERTAUTH"))) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("INSERT");
                    if ("G".equals(insertAuth)) {
                        privilege.setGrantable(true);
                    }
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!"N".equals(selectAuth = r.getString("SELECTAUTH"))) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("SELECT");
                    if ("G".equals(selectAuth)) {
                        privilege.setGrantable(true);
                    }
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if (!"N".equals(refAuth = r.getString("REFAUTH"))) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("REFERENCES");
                    if ("G".equals(refAuth)) {
                        privilege.setGrantable(true);
                    }
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if ("N".equals(updateAuth = r.getString("UPDATEAUTH"))) continue;
                privilege = new LUWCatalogPrivilege();
                privilege.setAction("UPDATE");
                if ("G".equals(updateAuth)) {
                    privilege.setGrantable(true);
                }
                privilegeList.add((Object)privilege);
                privilege.setGrantor(grantor);
                privilege.setGrantee(grantee);
                LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    protected static Schema getSchema(Table table, String schemaName) {
        Schema s2 = table.getSchema();
        if (s2.getName().equals(schemaName)) {
            return s2;
        }
        Database db = s2.getDatabase();
        if (db instanceof LUWCatalogDatabase && (s2 = ((LUWCatalogDatabase)db).getSchema(schemaName)) != null) {
            return s2;
        }
        for (Schema s2 : db.getSchemas()) {
            if (!s2.getName().equals(schemaName)) continue;
            return s2;
        }
        LUWCatalogSchema schema = new LUWCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(db);
        if (db instanceof LUWCatalogDatabase) {
            ((LUWCatalogDatabase)db).cacheSchema((Schema)schema);
        }
        return schema;
    }

    public static UserDefinedType getUserDefinedType(Table table, String schemaName, String userDefinedTypeName) {
        LUWCatalogDistinctUserDefinedType userDefinedType2;
        Schema schema = LUWCatalogTable.getSchema(table, schemaName);
        for (LUWCatalogDistinctUserDefinedType userDefinedType2 : schema.getUserDefinedTypes()) {
            if (!userDefinedType2.getName().equals(userDefinedTypeName)) continue;
            return userDefinedType2;
        }
        userDefinedType2 = new LUWCatalogDistinctUserDefinedType();
        userDefinedType2.setName(userDefinedTypeName);
        userDefinedType2.setSchema(schema);
        return userDefinedType2;
    }

    private static LUWTableSpace getTablespace(Table table, String tsNameName) {
        if (!(table instanceof LUWStorageTable)) {
            return null;
        }
        LUWCatalogDatabase db = (LUWCatalogDatabase)table.getSchema().getDatabase();
        StorageProvider provider = LUWCatalogDatabase.getCatalogStorageProvider();
        if (provider != null) {
            return provider.getTablespace(db, tsNameName);
        }
        return null;
    }

    private static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        int i = 0;
        while (i < list.length) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (sqlObject.getName().equals(name) && sqlObject.eClass() == metaclass && sqlObject instanceof ICatalogObject) {
                object = list[i];
                break;
            }
            ++i;
        }
        return object;
    }

    private void cacheColumn(EList columns) {
        for (Column column : columns) {
            this.cachedColumn.put(column.getName(), column);
        }
    }

    private void setAssociatedTablespace() {
        LUWTableSpace tbSpace;
        if (this.tbspaceName != null && (tbSpace = LUWCatalogTable.getTablespace((Table)this, this.tbspaceName)) != null) {
            tbSpace.getRegularDataTables().add((Object)this);
        }
        if (this.indexTbspaceName != null && (tbSpace = LUWCatalogTable.getTablespace((Table)this, this.indexTbspaceName)) != null) {
            tbSpace.getIndexDataTables().add((Object)this);
        }
        if (this.longTbspaceName != null && (tbSpace = LUWCatalogTable.getTablespace((Table)this, this.longTbspaceName)) != null) {
            tbSpace.getLOBDataTables().add((Object)this);
        }
    }

    private void reset() {
        this.cachedColumn.clear();
        this.tbspaceName = null;
        this.indexTbspaceName = null;
        this.longTbspaceName = null;
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogTable.getImpactedAlias(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedTables(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedRoutines(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedTriggers(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedConstraints(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedPackages(connection, (Table)this));
        return impacts;
    }

    protected static Collection getImpactedAlias(Connection connection, Table table) {
        ArrayList<Table> impacts = new ArrayList<Table>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT TABNAME, TABSCHEMA  FROM SYSCAT.TABLES WHERE TYPE='A' AND BASE_TABNAME='" + LUWUtil.getIdentifier(table.getName()) + "'" + " AND BASE_TABSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Table t = LUWCatalogView.getTable(table, schemaName, tabName);
                if (t == null) continue;
                impacts.add(t);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    protected static Collection getImpactedTables(Connection connection, Table table) {
        ArrayList<Table> impacts = new ArrayList<Table>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT TABNAME, TABSCHEMA FROM SYSCAT.TABDEP WHERE DTYPE in ('V','S') AND BTYPE in ('T','V','S','A','N') AND BNAME='" + LUWUtil.getIdentifier(table.getName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "'" + "FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Table t = LUWCatalogView.getTable(table, schemaName, tabName);
                if (t == null) continue;
                impacts.add(t);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    protected static Collection getImpactedRoutines(Connection connection, Table table) {
        ArrayList<Routine> impacts = new ArrayList<Routine>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT ROUTINENAME, ROUTINESCHEMA FROM SYSCAT.ROUTINEDEP WHERE BTYPE in ('T','S','V','A','N') AND BNAME='" + LUWUtil.getIdentifier(table.getName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String routineName = r.getString("ROUTINENAME").trim();
                String schemaName = r.getString("ROUTINESCHEMA").trim();
                Routine routine = LUWCatalogView.getRountine(table, schemaName, routineName);
                if (routine == null) continue;
                impacts.add(routine);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    protected static Collection getImpactedTriggers(Connection connection, Table table) {
        ArrayList<Trigger> impacts = new ArrayList<Trigger>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT DISTINCT A.TABSCHEMA, A.TABNAME, A.TRIGNAME FROM SYSCAT.TRIGGERS A, SYSCAT.TRIGDEP B WHERE (B.BNAME='" + LUWUtil.getIdentifier(table.getName()) + "'" + " AND B.BSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "'" + " AND BTYPE in ('T','S','V','A','N')" + " AND A.TRIGNAME=B.TRIGNAME" + " AND A.TRIGSCHEMA=B.TRIGSCHEMA)" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String trigName = r.getString("TRIGNAME").trim();
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Trigger trigger = LUWCatalogView.getTrigger(table, schemaName, tabName, trigName);
                if (trigger == null) continue;
                impacts.add(trigger);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    protected static Collection getImpactedConstraints(Connection connection, Table table) {
        ArrayList<TableConstraint> impacts = new ArrayList<TableConstraint>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT CONSTNAME,TABNAME,TABSCHEMA FROM SYSCAT.REFERENCES WHERE REFTABNAME='" + LUWUtil.getIdentifier(table.getName()) + "'" + " AND REFTABSCHEMA ='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String constName = r.getString("CONSTNAME").trim();
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                TableConstraint constraint = LUWCatalogView.getTableConstraint(table, schemaName, tabName, constName);
                if (constraint == null) continue;
                impacts.add(constraint);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    protected static Collection getImpactedPackages(Connection connection, Table table) {
        ArrayList<DB2Package> impacts = new ArrayList<DB2Package>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT PKGNAME, PKGSCHEMA, HEX(UNIQUE_ID) AS UID FROM SYSCAT.PACKAGEDEP WHERE BTYPE IN ('T','V','S','A','N') AND BNAME='" + LUWUtil.getIdentifier(table.getName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String pkgUniqueID;
                String pkgName = r.getString("PKGNAME").trim();
                String schemaName = r.getString("PKGSCHEMA").trim();
                DB2Package pkg = LUWCatalogView.getDb2Package(table, schemaName, pkgName, pkgUniqueID = r.getString("UID").trim());
                if (pkg == null) continue;
                impacts.add(pkg);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    public static Collection getStatistics(Connection connection, Table table) {
        ArrayList<CatalogStatistics> statistics = new ArrayList<CatalogStatistics>();
        try {
            DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(table.getSchema().getDatabase());
            String version = definition.getVersion();
            float ver = 8.0f;
            try {
                ver = Float.parseFloat(version.substring(1));
            }
            catch (NumberFormatException numberFormatException) {}
            String query = "";
            query = ver < 9.0f ? "SELECT T.STATS_TIME,S.CARD,S.NPAGES, S.FPAGES, S.OVERFLOW, S.ACTIVE_BLOCKS ,-1 AS AVGCOMPRESSEDROWSIZE,-1 AS AVGROWCOMPRESSIONRATIO, -1 AS AVGROWSIZE ,-1 AS PCTROWSCOMPRESSED, -1 AS PCTPAGESSAVED FROM SYSSTAT.TABLES S, SYSCAT.TABLES T WHERE S.TABSCHEMA = T.TABSCHEMA AND S.TABNAME = T.TABNAME  AND S.TABSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "'" + " AND S.TABNAME ='" + LUWUtil.getIdentifier(table.getName()) + "'" + " FOR FETCH ONLY" : "SELECT T.STATS_TIME,S.CARD,S.NPAGES, S.FPAGES, S.OVERFLOW, S.ACTIVE_BLOCKS ,S.AVGCOMPRESSEDROWSIZE,S.AVGROWCOMPRESSIONRATIO, S.AVGROWSIZE ,S.PCTROWSCOMPRESSED,S.PCTPAGESSAVED FROM SYSSTAT.TABLES S, SYSCAT.TABLES T WHERE S.TABSCHEMA = T.TABSCHEMA AND S.TABNAME = T.TABNAME  AND S.TABSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "'" + " AND S.TABNAME ='" + LUWUtil.getIdentifier(table.getName()) + "'" + " FOR FETCH ONLY";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                float pctPagesSaved;
                float pctRowsCompressed;
                int avgRowSize;
                float avgRowCompressionRatio;
                int avgCompressedRowSize;
                BigInteger activeBlocks;
                BigInteger overflow;
                BigInteger fpages;
                BigInteger npages;
                BigInteger card;
                CatalogStatistics stats = null;
                Timestamp stats_time = r.getTimestamp("STATS_TIME");
                if (stats_time != null) {
                    stats = new CatalogStatistics("STATS_TIME", LUWCatalogMessages.STAT_TIME, LUWCatalogMessages.STAT_TIME_DES, stats_time, "");
                    statistics.add(stats);
                }
                if ((card = r.getBigDecimal("CARD").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("CARD", LUWCatalogMessages.STAT_CARD, LUWCatalogMessages.STAT_CARD_DES, card, "SYSSTAT.TABLES");
                    statistics.add(stats);
                }
                if ((npages = r.getBigDecimal("NPAGES").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("NPAGES", LUWCatalogMessages.STAT_NPAGES, LUWCatalogMessages.STAT_NPAGES_DES, npages, "SYSSTAT.TABLES");
                    statistics.add(stats);
                }
                if ((fpages = r.getBigDecimal("FPAGES").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("FPAGES", LUWCatalogMessages.STAT_FPAGES, LUWCatalogMessages.STAT_FPAGES_DES, fpages, "SYSSTAT.TABLES");
                    statistics.add(stats);
                }
                if ((overflow = r.getBigDecimal("OVERFLOW").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("OVERFLOW", LUWCatalogMessages.STAT_OVERFLOW, LUWCatalogMessages.STAT_OVERFLOW_DES, overflow, "SYSSTAT.TABLES");
                    statistics.add(stats);
                }
                if ((activeBlocks = r.getBigDecimal("ACTIVE_BLOCKS").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("ACTIVE_BLOCKS", LUWCatalogMessages.STAT_ACTIVE_BLOCKS, LUWCatalogMessages.STAT_ACTIVE_BLOCKS_DES, activeBlocks, "SYSSTAT.TABLES");
                    statistics.add(stats);
                }
                if ((avgCompressedRowSize = r.getInt("AVGCOMPRESSEDROWSIZE")) != -1) {
                    stats = new CatalogStatistics("AVGCOMPRESSEDROWSIZE", LUWCatalogMessages.STAT_AVG_COMPRESSEDROWSIZE, LUWCatalogMessages.STAT_AVG_COMPRESSEDROWSIZE_DES, avgCompressedRowSize, "SYSSTAT.TABLES");
                    statistics.add(stats);
                }
                if ((avgRowCompressionRatio = r.getFloat("AVGROWCOMPRESSIONRATIO")) != -1.0f) {
                    stats = new CatalogStatistics("AVGROWCOMPRESSIONRATIO", LUWCatalogMessages.STAT_AVG_ROW_COMPRESSION_RATIO, LUWCatalogMessages.STAT_AVG_ROW_COMPRESSION_RATIO_DES, avgRowCompressionRatio, "SYSSTAT.TABLES");
                    statistics.add(stats);
                }
                if ((avgRowSize = r.getInt("AVGROWSIZE")) != -1) {
                    stats = new CatalogStatistics("AVGROWSIZE", LUWCatalogMessages.STAT_AVG_ROW_SIZE, LUWCatalogMessages.STAT_AVG_ROW_SIZE_DES, avgRowSize, "");
                    statistics.add(stats);
                }
                if ((pctRowsCompressed = r.getFloat("PCTROWSCOMPRESSED")) != -1.0f) {
                    stats = new CatalogStatistics("PCTROWSCOMPRESSED", LUWCatalogMessages.STAT_PCT_ROWS_COMPRESSED, LUWCatalogMessages.STAT_PCT_ROWS_COMPRESSED_DES, pctRowsCompressed, "SYSSTAT.TABLES");
                    statistics.add(stats);
                }
                if ((pctPagesSaved = r.getFloat("PCTPAGESSAVED")) == -1.0f) continue;
                stats = new CatalogStatistics("PCTPAGESSAVED", LUWCatalogMessages.STAT_PCT_PCT_PAGES_SAVED, LUWCatalogMessages.STAT_PCT_PCT_PAGES_SAVED_DES, pctPagesSaved, "SYSSTAT.TABLES");
                statistics.add(stats);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return statistics;
    }

    protected Column getColumn(String columnName) {
        return (Column)this.cachedColumn.get(columnName);
    }

    void setTablespaceName(String tbspaceName) {
        this.tbspaceName = tbspaceName;
    }

    void setIndexTbspaceName(String indexTbspaceName) {
        this.indexTbspaceName = indexTbspaceName;
    }

    void setlongTbspaceName(String longTbspaceName) {
        this.longTbspaceName = longTbspaceName;
    }

    protected void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadPrivileges(this.getConnection(), privileges, (Table)this, granteeFilter);
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    public String getRowCountString() {
        if (!this.rowCountLoaded) {
            this.rowCount = LUWCatalogTable.loadRowCount(this.getConnection(), (Table)this);
            this.rowCountLoaded = true;
        }
        return this.rowCount;
    }

    public void setRowCountString(String count) {
        this.rowCount = count;
        this.rowCountLoaded = true;
    }

    public static String loadRowCount(Connection connection, Table table) {
        table.getSchema().getDatabase();
        String schemaname = LUWUtil.getIdentifier(table.getSchema().getName());
        String tablename = LUWUtil.getIdentifier(table.getName());
        String cfr_ignored_0 = String.valueOf(schemaname) + "." + tablename;
        String rowCount = null;
        try {
            String query = "SELECT T.STATS_TIME,S.CARD,T.TABSCHEMA,T.TABNAME FROM SYSSTAT.TABLES S, SYSCAT.TABLES T WHERE S.TABSCHEMA = T.TABSCHEMA AND S.TABNAME = T.TABNAME ";
            query = String.valueOf(query) + " AND S.TABSCHEMA='" + schemaname + "'" + " AND S.TABNAME ='" + tablename + "'";
            query = String.valueOf(query) + " FOR FETCH ONLY";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                Timestamp stats_time;
                r.getString("TABSCHEMA").trim();
                r.getString("TABNAME").trim();
                String rc = "";
                BigInteger card = r.getBigDecimal("CARD").toBigInteger();
                if (card.intValue() != -1 && (stats_time = r.getTimestamp("STATS_TIME")) != null) {
                    DateFormat date = DateFormat.getDateInstance();
                    rc = String.valueOf(date.format(stats_time)) + " " + card;
                }
                rowCount = rc;
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return rowCount;
    }

    private static class ColumnInfo {
        String columnName;
        String remarks;
        String generated;
        String isIdentity;
        String nulls;
        String typeSchemaName;
        String typeName;
        int length;
        int scale;
        int codePage;
        String dflt;
        String targetTypeSchemaName;
        String targetUdtName;
        String logged;
        String compact;
        String rowChangeTimestamp = "";

        private ColumnInfo() {
        }
    }

    private static class TableColumnInfo {
        String schemaName;
        String tableName;
        List<ColumnInfo> columns = new ArrayList<ColumnInfo>();

        private TableColumnInfo() {
        }

        public String getKey() {
            return String.valueOf(this.schemaName) + "." + this.tableName;
        }

        public void setColumnInfoIn(Table table, List<Column> columnList) {
            Database database = table.getSchema().getDatabase();
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            Object[] list = columnList.toArray();
            columnList.clear();
            for (ColumnInfo info : this.columns) {
                PredefinedDataTypeDefinition typeDefinition;
                LUWCatalogColumn column;
                Object element = LUWCatalogTable.findElement(list, info.columnName, LUWPackage.eINSTANCE.getLUWColumn());
                if (element != null) {
                    column = (LUWCatalogColumn)element;
                    column.refresh();
                } else {
                    column = new LUWCatalogColumn();
                }
                column.setName(info.columnName);
                column.setDescription(info.remarks);
                if (info.generated.equals("A")) {
                    column.setGenerationType(GenerateType.ALWAYS_LITERAL);
                    column.setGenerated(true);
                } else if (info.generated.equals("D")) {
                    column.setGenerationType(GenerateType.BY_DEFAULT_LITERAL);
                    column.setGenerated(true);
                }
                if (info.isIdentity.equals("Y")) {
                    DB2IdentitySpecifier identitySpecifier = (DB2IdentitySpecifier)factory.create(DB2ModelPackage.eINSTANCE.getDB2IdentitySpecifier());
                    column.setIdentitySpecifier((IdentitySpecifier)identitySpecifier);
                } else {
                    column.setIdentitySpecifier(null);
                }
                column.setNullable(info.nulls.equals("Y"));
                if (info.typeName.equalsIgnoreCase("FLOAT")) {
                    info.typeName = info.length == 4 ? "REAL" : "DOUBLE";
                }
                if ((typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(info.typeName)) != null) {
                    EStructuralFeature feature;
                    if (typeDefinition.getPrimitiveType().getValue() == 0) {
                        if (info.codePage == 0) {
                            typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("CHAR () FOR BIT DATA");
                        }
                    } else if (typeDefinition.getPrimitiveType().getValue() == 1 && info.codePage == 0) {
                        typeDefinition = info.typeName.equals("LONG VARCHAR") ? databaseDefinition.getPredefinedDataTypeDefinition("LONG VARCHAR FOR BIT DATA") : databaseDefinition.getPredefinedDataTypeDefinition("VARCHAR () FOR BIT DATA");
                    }
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)info.length);
                    } else if (typeDefinition.isPrecisionSupported()) {
                        if (info.typeName.equals("TIMESTAMP")) {
                            feature = type.eClass().getEStructuralFeature("fractionalSecondsPrecision");
                            type.eSet(feature, (Object)info.scale);
                        } else {
                            if (info.typeName.equals("DECFLOAT")) {
                                info.length = info.length == 8 ? 16 : 34;
                            }
                            feature = type.eClass().getEStructuralFeature("precision");
                            type.eSet(feature, (Object)info.length);
                        }
                    }
                    if (typeDefinition.isScaleSupported()) {
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)info.scale);
                    }
                    column.setContainedType((SQLDataType)type);
                } else if (info.typeName.equals("REFERENCE")) {
                    column.setReferencedType(LUWCatalogTable.getUserDefinedType(table, info.targetTypeSchemaName, info.targetUdtName));
                } else {
                    column.setReferencedType(LUWCatalogTable.getUserDefinedType(table, info.typeSchemaName, info.typeName));
                }
                if (info.generated.equals(" ")) {
                    column.setDefaultValue(info.dflt);
                }
                column.setLobLogged(!info.logged.equals("N"));
                column.setLobCompacted(info.compact.equals("Y"));
                if (info.rowChangeTimestamp.equals("Y")) {
                    column.setRowChangeTimestamp(true);
                }
                columnList.add((Column)column);
            }
        }
    }

    private static class TablespaceInfo {
        String schemaName;
        String tableName;
        String tbspaceName;
        String indexTbspaceName;
        String longTbspaceName;

        private TablespaceInfo() {
        }

        public String getKey() {
            return String.valueOf(this.schemaName) + "." + this.tableName;
        }

        public void setInfoInTable(Table table) {
            LUWTableSpace tbSpace;
            if (this.tbspaceName != null && (tbSpace = LUWCatalogTable.getTablespace(table, this.tbspaceName)) != null) {
                tbSpace.getRegularDataTables().add((Object)table);
            }
            if (this.indexTbspaceName != null && (tbSpace = LUWCatalogTable.getTablespace(table, this.indexTbspaceName)) != null) {
                tbSpace.getIndexDataTables().add((Object)table);
            }
            if (this.longTbspaceName != null && (tbSpace = LUWCatalogTable.getTablespace(table, this.longTbspaceName)) != null) {
                tbSpace.getLOBDataTables().add((Object)table);
            }
        }
    }
}

