/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutorUtil;

public abstract class ReportItemExecutorTestAbs
extends TestCase {
    protected String getUpperXMLHeaderNoSpace() {
        return "<?XMLVERSION=\"1.0\"ENCODING=\"UTF-8\"?>";
    }

    protected String execute(String reportName, Locale locale) throws Exception {
        ReportEngine engine = new ReportEngine(new EngineConfig());
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(reportName);
        ReportItemExecutorTestAbs.assertTrue((in != null ? 1 : 0) != 0);
        ReportRunnable runnable = (ReportRunnable)engine.openReportDesign(in);
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ExecutionContext context = new ExecutionContext();
        this.setEngine(context, engine);
        context.setLocale(ULocale.forLocale((Locale)locale));
        context.setRunnable((IReportRunnable)runnable);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DumpEmitter emitter = new DumpEmitter(out);
        ReportExecutor executor = new ReportExecutor(context);
        context.setExecutor((IReportExecutor)executor);
        ReportExecutorUtil.execute((IReportExecutor)executor, (IContentEmitter)emitter);
        return out.toString();
    }

    private void setEngine(ExecutionContext context, ReportEngine engine) throws NoSuchFieldException, IllegalAccessException {
        Class<?> engineClass = engine.getClass();
        Field field = engineClass.getDeclaredField("engine");
        field.setAccessible(true);
        IReportEngine reportEngine = (IReportEngine)field.get(engine);
        Class<?> contextClass = context.getClass();
        field = contextClass.getDeclaredField("engine");
        field.setAccessible(true);
        field.set(context, reportEngine);
    }

    protected String execute(String reportName) throws Exception {
        return this.execute(reportName, Locale.getDefault());
    }

    protected String loadResource(String resourceName) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
        ReportItemExecutorTestAbs.assertTrue((in != null ? 1 : 0) != 0);
        byte[] buffer = new byte[in.available()];
        in.read(buffer);
        return new String(buffer);
    }

    protected void compare(String designFile, String goldenFile) {
        try {
            String result = this.execute(designFile);
            String golden = this.loadResource(goldenFile);
            result = result.replaceAll("\\s", "").toUpperCase();
            golden = golden.replaceAll("\\s", "").toUpperCase();
            ReportItemExecutorTestAbs.assertEquals((String)golden, (String)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportItemExecutorTestAbs.fail();
        }
    }

    protected class DumpEmitter
    extends ContentEmitterAdapter {
        protected IEmitterServices services;
        protected XMLWriter writer = new XMLWriter();

        public DumpEmitter(OutputStream out) {
            this.writer.open(out);
        }

        public void initialize(IEmitterServices services) {
            this.services = services;
        }

        public IEmitterServices getEmitterServices() {
            return this.services;
        }

        public String getOutputFormat() {
            return "TEXT";
        }

        public void start(IReportContent report) {
            this.writer.startWriter();
            this.writer.openTag("report");
        }

        public void end(IReportContent report) {
            this.writer.closeTag("report");
            this.writer.endWriter();
            this.writer.close();
        }

        public void startPage(IPageContent pageContent) {
            this.writer.openTag("page");
            this.writer.attribute("page-number", (float)pageContent.getPageNumber());
        }

        public void endPage(IPageContent pageConent) {
            this.writer.closeTag("page");
        }

        public void startImage(IImageContent image) {
            this.writer.openTag("image");
            String source = "unknown";
            switch (image.getImageSource()) {
                case 2: {
                    source = "expression";
                    break;
                }
                case 0: {
                    source = "file";
                    break;
                }
                case 1: {
                    source = "name";
                    break;
                }
                case 3: {
                    source = "uri";
                }
            }
            this.writer.attribute("source", source);
            this.writer.closeTag("image");
        }

        public void startTable(ITableContent tableObj) {
            this.writer.openTag("table");
            this.writer.attribute("caption", tableObj.getCaption());
            int i = 0;
            while (i < tableObj.getColumnCount()) {
                this.writer.openTag("column");
                this.writer.closeTag("column");
                ++i;
            }
        }

        public void endTable(ITableContent tableObj) {
            this.writer.closeTag("Table");
        }

        public void startRow(IRowContent rowObj) {
            this.writer.openTag("row");
        }

        public void endRow(IRowContent rowobj) {
            this.writer.closeTag("row");
        }

        public void startCell(ICellContent cellObj) {
            this.writer.openTag("cell");
            this.writer.attribute("column", cellObj.getColumn());
            this.writer.attribute("row-span", cellObj.getRowSpan());
            this.writer.attribute("col-span", cellObj.getColSpan());
        }

        public void endCell(ICellContent cell) {
            this.writer.closeTag("cell");
        }

        public void startForeign(IForeignContent foreign) {
            this.writer.openTag("foreign");
            this.writer.attribute("raw-type", foreign.getRawType());
            this.writer.closeTag("foreign");
        }

        public void startText(ITextContent textObj) {
            this.writer.openTag("text");
            this.writer.closeTag("text");
        }

        public void startLabel(ILabelContent label) {
            this.writer.openTag("label");
            this.writer.closeTag("label");
        }

        public void startAutoText(IAutoTextContent autoText) {
            this.writer.openTag("auto-text");
            this.writer.closeTag("auto-text");
        }

        public void startData(IDataContent data) {
            this.writer.openTag("data");
            this.writer.closeTag("data");
        }

        public void endList(IListContent list) {
            this.writer.closeTag("list");
        }

        public void endListBand(IListBandContent listBand) {
            this.writer.closeTag("list-band");
        }

        public void endTableBand(ITableBandContent band) {
            this.writer.closeTag("table-band");
        }

        public void startList(IListContent list) {
            this.writer.openTag("list");
        }

        public void startListBand(IListBandContent listBand) {
            this.writer.openTag("list-band");
        }

        public void startTableBand(ITableBandContent band) {
            this.writer.openTag("table-band");
        }

        public void endGroup(IGroupContent group) {
            this.writer.closeTag("group");
        }

        public void startGroup(IGroupContent group) {
            this.writer.openTag("group");
        }
    }
}

