/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.ICascadingParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;

public class GetParameterDefinitionTaskTest
extends EngineCase {
    protected IReportEngine engine = null;
    protected IReportRunnable runnable = null;
    protected IGetParameterDefinitionTask gpdTask = null;
    protected IScalarParameterDefn scalarParam = null;
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/GetParameterDefinitionTaskTest.rptdesign";

    public void setUp() throws Exception {
        String reportDesign = REPORT_DESIGN_RESOURCE;
        this.initialize(reportDesign);
    }

    private void initialize(String reportDesign) throws EngineException {
        this.useDesignFile(reportDesign);
        this.engine = this.createReportEngine();
        this.runnable = this.engine.openReportDesign("design.rptdesign");
        this.gpdTask = this.engine.createGetParameterDefinitionTask(this.runnable);
    }

    public void tearDown() {
        this.destroy();
    }

    private void destroy() {
        if (this.engine != null) {
            this.engine.shutdown();
        }
        this.removeFile("design.rptdesign");
    }

    public void testGetDefaultValue() {
        String[] paramDefnArray = new String[]{"paramString", "paramBoolean", "paramList", "paramListDynamic", "paramComboSort", "paramDispFormatNum", "paramDispFormatDateTime"};
        String[] goldenString = new String[]{"defaultStringValue", "false", "2", "0", "item2", "123", "08/10/2006 10:32:58 AM"};
        GetParameterDefinitionTaskTest.assertTrue((paramDefnArray.length == goldenString.length ? 1 : 0) != 0);
        int size = paramDefnArray.length;
        int index = 0;
        while (index < size) {
            this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn(paramDefnArray[index]);
            String resultString = this.scalarParam.getDefaultValue();
            GetParameterDefinitionTaskTest.assertTrue((resultString != null ? 1 : 0) != 0);
            GetParameterDefinitionTaskTest.assertTrue((boolean)goldenString[index].equals(resultString));
            ++index;
        }
    }

    public void testIsValueConcealed() {
        String[] paramDefnArray = new String[]{"paramConceal", "paramString"};
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] goldenResult = blArray;
        GetParameterDefinitionTaskTest.assertTrue((paramDefnArray.length == goldenResult.length ? 1 : 0) != 0);
        int size = paramDefnArray.length;
        int index = 0;
        while (index < size) {
            this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn(paramDefnArray[index]);
            GetParameterDefinitionTaskTest.assertEquals((boolean)this.scalarParam.isValueConcealed(), (boolean)goldenResult[index]);
            ++index;
        }
    }

    public void testGetDisplayFormat() {
        String[] paramArray = new String[]{"paramDispFormatString", "paramDispFormatDateTime", "paramDispFormatNum"};
        String[] goldenResult = new String[]{"(@@)", "Short Date", "Scientific"};
        GetParameterDefinitionTaskTest.assertTrue((paramArray.length == goldenResult.length ? 1 : 0) != 0);
        int size = paramArray.length;
        int index = 0;
        while (index < size) {
            this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn(paramArray[index]);
            GetParameterDefinitionTaskTest.assertEquals((String)goldenResult[index], (String)this.scalarParam.getDisplayFormat());
            ++index;
        }
    }

    public void testGetControlType() {
        String[] paramArray = new String[]{"paramString", "paramBoolean", "paramList", "paramComboSort", "paramRadio"};
        int[] nArray = new int[5];
        nArray[1] = 3;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        int[] results = nArray;
        GetParameterDefinitionTaskTest.assertTrue((paramArray.length == results.length ? 1 : 0) != 0);
        int size = paramArray.length;
        int index = 0;
        while (index < size) {
            this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn(paramArray[index]);
            GetParameterDefinitionTaskTest.assertEquals((int)results[index], (int)this.scalarParam.getControlType());
            ++index;
        }
    }

    public void testGetAlignment() {
        this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn("paramAlign");
        GetParameterDefinitionTaskTest.assertEquals((int)3, (int)this.scalarParam.getAlignment());
    }

    public void testGetSelectionList() {
        int LIST_SIZE = 3;
        String[] goldenResult = new String[]{"1", "2", "3"};
        this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn("paramList");
        GetParameterDefinitionTaskTest.assertEquals((int)3, (int)((ScalarParameterDefn)this.scalarParam).getSelectionList().size());
        GetParameterDefinitionTaskTest.assertEquals((String)this.scalarParam.getDefaultValue(), (String)"2");
        IParameterSelectionChoice choice = null;
        GetParameterDefinitionTaskTest.assertTrue((goldenResult.length == 3 ? 1 : 0) != 0);
        int index = 0;
        while (index < 3) {
            choice = (IParameterSelectionChoice)((ScalarParameterDefn)this.scalarParam).getSelectionList().get(index);
            GetParameterDefinitionTaskTest.assertEquals((String)goldenResult[index], (String)choice.getValue().toString());
            ++index;
        }
    }

    public void testGetSelectionListType() {
        this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn("paramList");
        GetParameterDefinitionTaskTest.assertEquals((int)2, (int)this.scalarParam.getSelectionListType());
        this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn("paramListDynamic");
        GetParameterDefinitionTaskTest.assertEquals((int)1, (int)this.scalarParam.getSelectionListType());
    }

    public void testDisplayInFixedOrder() {
        this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn("paramList");
        GetParameterDefinitionTaskTest.assertTrue((boolean)this.scalarParam.displayInFixedOrder());
        this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn("paramComboSort");
        GetParameterDefinitionTaskTest.assertFalse((boolean)this.scalarParam.displayInFixedOrder());
    }

    public void testGetDataType() {
        String[] paramArray = new String[]{"paramBoolean", "paramDatetimeFormat", "paramDispFormatNum", "paramFloat", "paramInteger", "paramString"};
        int[] results = new int[]{5, 4, 3, 2, 6, 1};
        GetParameterDefinitionTaskTest.assertTrue((paramArray.length == results.length ? 1 : 0) != 0);
        int size = paramArray.length;
        int index = 0;
        while (index < size) {
            this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn(paramArray[index]);
            GetParameterDefinitionTaskTest.assertEquals((int)results[index], (int)this.scalarParam.getDataType());
            ++index;
        }
    }

    public void testAllowNewValues() {
        this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn("paramList");
        GetParameterDefinitionTaskTest.assertFalse((boolean)this.scalarParam.allowNewValues());
        this.scalarParam = (IScalarParameterDefn)this.gpdTask.getParameterDefn("paramComboSort");
        GetParameterDefinitionTaskTest.assertTrue((boolean)this.scalarParam.allowNewValues());
    }

    public void testGetParameterDefns() {
        int PARAMS_COUNT_DO_INCLUDE_GROUP = 17;
        int PARAMS_COUNT_DONOT_INCLUDE_GROUP = 16;
        Collection collection = this.gpdTask.getParameterDefns(false);
        GetParameterDefinitionTaskTest.assertTrue((17 == collection.size() ? 1 : 0) != 0);
        collection = this.gpdTask.getParameterDefns(true);
        GetParameterDefinitionTaskTest.assertTrue((16 == collection.size() ? 1 : 0) != 0);
    }

    public void testGetParameterGroupDefn() {
        String GROUP_NAME = "paramGroup";
        String GROUP_DISPLAY_NAME = "paramGroupDispName";
        IParameterDefnBase base = this.gpdTask.getParameterDefn("paramGroup");
        GetParameterDefinitionTaskTest.assertTrue((boolean)"paramGroup".equals(base.getName()));
        GetParameterDefinitionTaskTest.assertTrue((4 == base.getParameterType() ? 1 : 0) != 0);
        GetParameterDefinitionTaskTest.assertTrue((boolean)"paramGroupDispName".equals(base.getDisplayName()));
    }

    public void testGetTypeName() {
        String[] paramNames = new String[]{"paramString", "paramGroup"};
        String[] goldenTypeNames = new String[]{"scalar", "group"};
        GetParameterDefinitionTaskTest.assertTrue((paramNames.length == goldenTypeNames.length ? 1 : 0) != 0);
        int index = 0;
        int size = paramNames.length;
        while (index < size) {
            IParameterDefnBase base = this.gpdTask.getParameterDefn(paramNames[index]);
            GetParameterDefinitionTaskTest.assertTrue((boolean)goldenTypeNames[index].equals(base.getTypeName()));
            ++index;
        }
    }

    public void testGetSelectionTree() throws EngineException {
        this.destroy();
        this.initialize("org/eclipse/birt/report/engine/api/GetSelectionTreeTest.rptdesign");
        HashMap<String, Object[]> parentToChildren = new HashMap<String, Object[]>();
        Object[] objectArray = new Object[3];
        objectArray[0] = new Integer(1621);
        objectArray[1] = new Integer(1612);
        parentToChildren.put("Singapore", objectArray);
        parentToChildren.put("Hong Kong", new Object[]{new Integer(1621)});
        String[] parent = new String[]{"Singapore", "Hong Kong"};
        this.checkTree("DistinctFixedOrder", parent, parentToChildren);
        this.checkTree("MultiDataSetDistinctFixedOrder", parent, parentToChildren);
        parent = new String[]{"Singapore", "Singapore", "Singapore", "Hong Kong"};
        this.checkTree("NotDistinctFixedOrder", parent, parentToChildren);
        this.checkTree("MultiDataSetNotDistinctFixedOrder", parent, parentToChildren);
        parent = new String[]{"Hong Kong", "Singapore"};
        this.checkTree("DistinctNotFixedOrder", parent, parentToChildren);
        this.checkTree("MultiDataSetDistinctNotFixedOrder", parent, parentToChildren);
        parent = new String[]{"Hong Kong", "Singapore", "Singapore", "Singapore"};
        this.checkTree("NotDistinctNotFixedOrder", parent, parentToChildren);
        this.checkTree("MultiDataSetNotDistinctNotFixedOrder", parent, parentToChildren);
    }

    private void checkTree(String parameterName, String[] parent, Map parentToChildren) {
        Collection tree = this.gpdTask.getSelectionTreeForCascadingGroup(parameterName);
        Iterator iterator = tree.iterator();
        GetParameterDefinitionTaskTest.assertEquals((int)parent.length, (int)tree.size());
        int i = 0;
        while (i < parent.length) {
            ICascadingParameterSelectionChoice choice = (ICascadingParameterSelectionChoice)iterator.next();
            Object value = choice.getValue();
            GetParameterDefinitionTaskTest.assertEquals((Object)parent[i], (Object)value);
            this.checkChildren((Object[])parentToChildren.get(value), choice.getChildSelectionList());
            ++i;
        }
    }

    private void checkChildren(Object[] expectedChildren, Collection children) {
        GetParameterDefinitionTaskTest.assertEquals((int)expectedChildren.length, (int)children.size());
        Iterator iterator = children.iterator();
        int i = 0;
        while (i < expectedChildren.length) {
            ICascadingParameterSelectionChoice choice = (ICascadingParameterSelectionChoice)iterator.next();
            if (expectedChildren[i] != null) {
                GetParameterDefinitionTaskTest.assertEquals((Object)expectedChildren[i], (Object)choice.getValue());
            } else {
                GetParameterDefinitionTaskTest.assertNull((Object)choice.getValue());
            }
            ++i;
        }
    }
}

