/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.MenuUpdateAction;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class ApplyThemeAction
extends MenuUpdateAction.DynamicItemAction {
    private static final String ID = "ApplyTheme";
    private static final String STACK_MSG_APPLY_STYLE = Messages.getString((String)"ApplyThemeAction.stackMsg.applyStyle");
    private ThemeHandle handle;

    public ApplyThemeAction(ThemeHandle theme) {
        this.handle = theme;
        this.setId(ID);
        if (this.handle == null) {
            this.setText(Messages.getString((String)Messages.getString((String)"ApplyThemeAction.actionLabel.none")));
        } else {
            this.setText(DEUtil.getEscapedMenuItemText((String)DEUtil.getDisplayLabel((Object)this.handle)));
        }
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Apply style rule action >> Run ...");
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(STACK_MSG_APPLY_STYLE);
        try {
            SessionHandleAdapter.getInstance().getReportDesignHandle().setTheme(this.handle);
            stack.commit();
        }
        catch (SemanticException e) {
            stack.rollbackAll();
            ExceptionHandler.handle(e);
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

